/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.jms.cf;

import java.util.List;
import javax.jms.ConnectionFactory;
import org.apache.nifi.annotation.behavior.DynamicProperty;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnDisabled;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.jms.cf.JMSConnectionFactoryProviderDefinition;
import org.apache.nifi.jms.cf.JndiJmsConnectionFactoryHandler;
import org.apache.nifi.jms.cf.JndiJmsConnectionFactoryProperties;

@Tags(value={"jms", "jndi", "messaging", "integration", "queue", "topic", "publish", "subscribe"})
@CapabilityDescription(value="Provides a service to lookup an existing JMS ConnectionFactory using the Java Naming and Directory Interface (JNDI).")
@DynamicProperty(description="In order to perform a JNDI Lookup, an Initial Context must be established. When this is done, an Environment can be established for the context. Any dynamic/user-defined property that is added to this Controller Service will be added as an Environment configuration/variable to this Context.", name="The name of a JNDI Initial Context environment variable.", value="The value of the JNDI Initial Context environment variable.", expressionLanguageScope=ExpressionLanguageScope.VARIABLE_REGISTRY)
@SeeAlso(classNames={"org.apache.nifi.jms.processors.ConsumeJMS", "org.apache.nifi.jms.processors.PublishJMS", "org.apache.nifi.jms.cf.JMSConnectionFactoryProvider"})
public class JndiJmsConnectionFactoryProvider
extends AbstractControllerService
implements JMSConnectionFactoryProviderDefinition {
    private volatile JndiJmsConnectionFactoryHandler delegate;

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return JndiJmsConnectionFactoryProperties.getPropertyDescriptors();
    }

    protected PropertyDescriptor getSupportedDynamicPropertyDescriptor(String propertyDescriptorName) {
        return JndiJmsConnectionFactoryProperties.getDynamicPropertyDescriptor(propertyDescriptorName);
    }

    @OnEnabled
    public void onEnabled(ConfigurationContext context) {
        this.delegate = new JndiJmsConnectionFactoryHandler(context, this.getLogger());
    }

    @OnDisabled
    public void onDisabled() {
        this.delegate = null;
    }

    public ConnectionFactory getConnectionFactory() {
        return this.delegate.getConnectionFactory();
    }

    public void resetConnectionFactory(ConnectionFactory cachedFactory) {
        this.delegate.resetConnectionFactory(cachedFactory);
    }
}

