/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.jms.processors;

import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.nifi.annotation.behavior.DynamicProperty;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.ReadsAttribute;
import org.apache.nifi.annotation.behavior.ReadsAttributes;
import org.apache.nifi.annotation.behavior.SystemResource;
import org.apache.nifi.annotation.behavior.SystemResourceConsideration;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.jms.cf.JMSConnectionFactoryProvider;
import org.apache.nifi.jms.processors.AbstractJMSProcessor;
import org.apache.nifi.jms.processors.ConsumeJMS;
import org.apache.nifi.jms.processors.JMSPublisher;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.stream.io.StreamUtils;
import org.springframework.jms.connection.CachingConnectionFactory;
import org.springframework.jms.core.JmsTemplate;

@Tags(value={"jms", "put", "message", "send", "publish"})
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@CapabilityDescription(value="Creates a JMS Message from the contents of a FlowFile and sends it to a JMS Destination (queue or topic) as JMS BytesMessage or TextMessage. FlowFile attributes will be added as JMS headers and/or properties to the outgoing JMS message.")
@ReadsAttributes(value={@ReadsAttribute(attribute="jms_deliveryMode", description="This attribute becomes the JMSDeliveryMode message header. Must be an integer."), @ReadsAttribute(attribute="jms_expiration", description="This attribute becomes the JMSExpiration message header. Must be an integer."), @ReadsAttribute(attribute="jms_priority", description="This attribute becomes the JMSPriority message header. Must be an integer."), @ReadsAttribute(attribute="jms_redelivered", description="This attribute becomes the JMSRedelivered message header."), @ReadsAttribute(attribute="jms_timestamp", description="This attribute becomes the JMSTimestamp message header. Must be a long."), @ReadsAttribute(attribute="jms_correlationId", description="This attribute becomes the JMSCorrelationID message header."), @ReadsAttribute(attribute="jms_type", description="This attribute becomes the JMSType message header. Must be an integer."), @ReadsAttribute(attribute="jms_replyTo", description="This attribute becomes the JMSReplyTo message header. Must be an integer."), @ReadsAttribute(attribute="jms_destination", description="This attribute becomes the JMSDestination message header. Must be an integer."), @ReadsAttribute(attribute="other attributes", description="All other attributes that do not start with jms_ are added as message properties."), @ReadsAttribute(attribute="other attributes .type", description="When an attribute will be added as a message property, a second attribute of the same name but with an extra `.type` at the end will cause the message property to be sent using that strong type. For example, attribute `delay` with value `12000` and another attribute `delay.type` with value `integer` will cause a JMS message property `delay` to be sent as an Integer rather than a String. Supported types are boolean, byte, short, integer, long, float, double, and string (which is the default).")})
@DynamicProperty(name="The name of a Connection Factory configuration property.", value="The value of a given Connection Factory configuration property.", description="Additional configuration property for the Connection Factory. It can be used when the Connection Factory is being configured via the 'JNDI *' or the 'JMS *'properties of the processor. For more information, see the Additional Details page.", expressionLanguageScope=ExpressionLanguageScope.VARIABLE_REGISTRY)
@SeeAlso(value={ConsumeJMS.class, JMSConnectionFactoryProvider.class})
@SystemResourceConsideration(resource=SystemResource.MEMORY)
public class PublishJMS
extends AbstractJMSProcessor<JMSPublisher> {
    static final PropertyDescriptor MESSAGE_BODY = new PropertyDescriptor.Builder().name("message-body-type").displayName("Message Body Type").description("The type of JMS message body to construct.").required(true).defaultValue("bytes").allowableValues(new String[]{"bytes", "text"}).build();
    static final PropertyDescriptor ALLOW_ILLEGAL_HEADER_CHARS = new PropertyDescriptor.Builder().name("allow-illegal-chars-in-jms-header-names").displayName("Allow Illegal Characters in Header Names").description("Specifies whether illegal characters in header names should be sent to the JMS broker. Usually hyphens and full-stops.").required(true).defaultValue("false").allowableValues(new String[]{"true", "false"}).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    static final PropertyDescriptor ATTRIBUTES_AS_HEADERS_REGEX = new PropertyDescriptor.Builder().name("attributes-to-send-as-jms-headers-regex").displayName("Attributes to Send as JMS Headers (Regex)").description("Specifies the Regular Expression that determines the names of FlowFile attributes that should be sent as JMS Headers").addValidator(StandardValidators.REGULAR_EXPRESSION_VALIDATOR).defaultValue(".*").required(true).build();
    public static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("All FlowFiles that are sent to the JMS destination are routed to this relationship").build();
    public static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("All FlowFiles that cannot be sent to JMS destination are routed to this relationship").build();
    private static final List<PropertyDescriptor> propertyDescriptors;
    private static final Set<Relationship> relationships;

    @Override
    protected void rendezvousWithJms(ProcessContext context, ProcessSession processSession, JMSPublisher publisher) throws ProcessException {
        FlowFile flowFile = processSession.get();
        if (flowFile != null) {
            try {
                String destinationName = context.getProperty(DESTINATION).evaluateAttributeExpressions(flowFile).getValue();
                String charset = context.getProperty(CHARSET).evaluateAttributeExpressions(flowFile).getValue();
                Boolean allowIllegalChars = context.getProperty(ALLOW_ILLEGAL_HEADER_CHARS).asBoolean();
                String attributeHeaderRegex = context.getProperty(ATTRIBUTES_AS_HEADERS_REGEX).getValue();
                HashMap<String, String> attributesToSend = new HashMap<String, String>();
                Pattern pattern = Pattern.compile(attributeHeaderRegex);
                for (Map.Entry entry : flowFile.getAttributes().entrySet()) {
                    String key = (String)entry.getKey();
                    if (!pattern.matcher(key).matches() || !allowIllegalChars.booleanValue() && !key.endsWith(".type") && (key.contains("-") || key.contains("."))) continue;
                    attributesToSend.put(key, flowFile.getAttribute(key));
                }
                switch (context.getProperty(MESSAGE_BODY).getValue()) {
                    case "text": {
                        try {
                            publisher.publish(destinationName, this.extractTextMessageBody(flowFile, processSession, charset), attributesToSend);
                            break;
                        }
                        catch (Exception e) {
                            publisher.setValid(false);
                            throw e;
                        }
                    }
                    default: {
                        try {
                            publisher.publish(destinationName, this.extractMessageBody(flowFile, processSession), attributesToSend);
                            break;
                        }
                        catch (Exception e) {
                            publisher.setValid(false);
                            throw e;
                        }
                    }
                }
                processSession.transfer(flowFile, REL_SUCCESS);
                processSession.getProvenanceReporter().send(flowFile, destinationName);
            }
            catch (Exception e) {
                processSession.transfer(flowFile, REL_FAILURE);
                this.getLogger().error("Failed while sending message to JMS via " + publisher, (Throwable)e);
                context.yield();
                publisher.setValid(false);
            }
        }
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return propertyDescriptors;
    }

    public Set<Relationship> getRelationships() {
        return relationships;
    }

    @Override
    protected JMSPublisher finishBuildingJmsWorker(CachingConnectionFactory connectionFactory, JmsTemplate jmsTemplate, ProcessContext processContext) {
        return new JMSPublisher(connectionFactory, jmsTemplate, this.getLogger());
    }

    private byte[] extractMessageBody(FlowFile flowFile, ProcessSession session) {
        byte[] messageContent = new byte[(int)flowFile.getSize()];
        session.read(flowFile, in -> StreamUtils.fillBuffer((InputStream)in, (byte[])messageContent, (boolean)true));
        return messageContent;
    }

    private String extractTextMessageBody(FlowFile flowFile, ProcessSession session, String charset) {
        StringWriter writer = new StringWriter();
        session.read(flowFile, in -> IOUtils.copy((InputStream)in, (Writer)writer, (Charset)Charset.forName(charset)));
        return writer.toString();
    }

    static {
        ArrayList<PropertyDescriptor> _propertyDescriptors = new ArrayList<PropertyDescriptor>();
        _propertyDescriptors.add(CF_SERVICE);
        _propertyDescriptors.add(DESTINATION);
        _propertyDescriptors.add(DESTINATION_TYPE);
        _propertyDescriptors.add(USER);
        _propertyDescriptors.add(PASSWORD);
        _propertyDescriptors.add(CLIENT_ID);
        _propertyDescriptors.add(SESSION_CACHE_SIZE);
        _propertyDescriptors.add(MESSAGE_BODY);
        _propertyDescriptors.add(CHARSET);
        _propertyDescriptors.add(ALLOW_ILLEGAL_HEADER_CHARS);
        _propertyDescriptors.add(ATTRIBUTES_AS_HEADERS_REGEX);
        _propertyDescriptors.addAll(JNDI_JMS_CF_PROPERTIES);
        _propertyDescriptors.addAll(JMS_CF_PROPERTIES);
        propertyDescriptors = Collections.unmodifiableList(_propertyDescriptors);
        HashSet<Relationship> _relationships = new HashSet<Relationship>();
        _relationships.add(REL_SUCCESS);
        _relationships.add(REL_FAILURE);
        relationships = Collections.unmodifiableSet(_relationships);
    }
}

