/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.jms.cf;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.ExceptionListener;
import javax.jms.JMSSecurityException;
import javax.jms.Session;
import org.apache.nifi.annotation.behavior.DynamicProperty;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnDisabled;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.components.ConfigVerificationResult;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.controller.VerifiableControllerService;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.jms.cf.JMSConnectionFactoryHandler;
import org.apache.nifi.jms.cf.JMSConnectionFactoryProperties;
import org.apache.nifi.jms.cf.JMSConnectionFactoryProviderDefinition;
import org.apache.nifi.logging.ComponentLog;

@Tags(value={"jms", "messaging", "integration", "queue", "topic", "publish", "subscribe"})
@CapabilityDescription(value="Provides a generic service to create vendor specific javax.jms.ConnectionFactory implementations. The Connection Factory can be served once this service is configured successfully.")
@DynamicProperty(name="The name of a Connection Factory configuration property.", value="The value of a given Connection Factory configuration property.", description="The properties that are set following Java Beans convention where a property name is derived from the 'set*' method of the vendor specific ConnectionFactory's implementation. For example, 'com.ibm.mq.jms.MQConnectionFactory.setChannel(String)' would imply 'channel' property and 'com.ibm.mq.jms.MQConnectionFactory.setTransportType(int)' would imply 'transportType' property.", expressionLanguageScope=ExpressionLanguageScope.VARIABLE_REGISTRY)
@SeeAlso(classNames={"org.apache.nifi.jms.processors.ConsumeJMS", "org.apache.nifi.jms.processors.PublishJMS"})
public class JMSConnectionFactoryProvider
extends AbstractControllerService
implements JMSConnectionFactoryProviderDefinition,
VerifiableControllerService {
    private static final String ESTABLISH_CONNECTION = "Establish Connection";
    private static final String VERIFY_JMS_INTERACTION = "Verify JMS Interaction";
    protected volatile JMSConnectionFactoryHandler delegate;

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return JMSConnectionFactoryProperties.getPropertyDescriptors();
    }

    protected PropertyDescriptor getSupportedDynamicPropertyDescriptor(String propertyDescriptorName) {
        return JMSConnectionFactoryProperties.getDynamicPropertyDescriptor(propertyDescriptorName);
    }

    @OnEnabled
    public void onEnabled(ConfigurationContext context) {
        this.delegate = new JMSConnectionFactoryHandler(context, this.getLogger());
    }

    @OnDisabled
    public void onDisabled() {
        this.delegate = null;
    }

    public ConnectionFactory getConnectionFactory() {
        return this.delegate.getConnectionFactory();
    }

    public void resetConnectionFactory(ConnectionFactory cachedFactory) {
        this.delegate.resetConnectionFactory(cachedFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ConfigVerificationResult> verify(ConfigurationContext context, ComponentLog verificationLogger, Map<String, String> variables) {
        ArrayList<ConfigVerificationResult> results = new ArrayList<ConfigVerificationResult>();
        JMSConnectionFactoryHandler handler = new JMSConnectionFactoryHandler(context, verificationLogger);
        AtomicReference failureReason = new AtomicReference();
        ExceptionListener listener = failureReason::set;
        Connection connection = this.createConnection(handler.getConnectionFactory(), results, listener, verificationLogger);
        if (connection != null) {
            try {
                this.createSession(connection, results, (Exception)failureReason.get(), verificationLogger);
            }
            finally {
                try {
                    connection.close();
                }
                catch (Exception exception) {}
            }
        }
        return results;
    }

    private Connection createConnection(ConnectionFactory connectionFactory, List<ConfigVerificationResult> results, ExceptionListener exceptionListener, ComponentLog logger) {
        try {
            Connection connection = connectionFactory.createConnection();
            connection.setExceptionListener(exceptionListener);
            results.add(new ConfigVerificationResult.Builder().verificationStepName(ESTABLISH_CONNECTION).outcome(ConfigVerificationResult.Outcome.SUCCESSFUL).explanation("Successfully established a JMS Connection").build());
            return connection;
        }
        catch (JMSSecurityException se) {
            logger.debug("Failed to establish a connection to the JMS Server in order to verify configuration because encountered JMS Security Exception", (Throwable)se);
            results.add(new ConfigVerificationResult.Builder().verificationStepName(ESTABLISH_CONNECTION).outcome(ConfigVerificationResult.Outcome.SKIPPED).explanation("Could not establish a Connection because doing so requires that a username and password be provided").build());
        }
        catch (Exception e) {
            logger.warn("Failed to establish a connection to the JMS Server in order to verify configuration", (Throwable)e);
            results.add(new ConfigVerificationResult.Builder().verificationStepName(ESTABLISH_CONNECTION).outcome(ConfigVerificationResult.Outcome.FAILED).explanation("Was not able to establish a connection to the JMS Server: " + e.toString()).build());
        }
        return null;
    }

    private void createSession(Connection connection, List<ConfigVerificationResult> results, Exception capturedException, ComponentLog logger) {
        try {
            Session session = connection.createSession(false, 2);
            session.close();
            results.add(new ConfigVerificationResult.Builder().verificationStepName(VERIFY_JMS_INTERACTION).outcome(ConfigVerificationResult.Outcome.SUCCESSFUL).explanation("Established a JMS Session with server and successfully terminated it").build());
        }
        catch (Exception e) {
            Exception failure;
            if (capturedException == null) {
                failure = e;
            } else {
                failure = capturedException;
                failure.addSuppressed(e);
            }
            logger.warn("Failed to create a JMS Session in order to verify configuration", (Throwable)failure);
            results.add(new ConfigVerificationResult.Builder().verificationStepName(VERIFY_JMS_INTERACTION).outcome(ConfigVerificationResult.Outcome.FAILED).explanation("Was not able to create a JMS Session: " + failure.toString()).build());
        }
    }
}

