/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.jms.cf;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.ExceptionListener;
import jakarta.jms.JMSSecurityException;
import jakarta.jms.Session;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.nifi.annotation.lifecycle.OnDisabled;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.components.ConfigVerificationResult;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.controller.VerifiableControllerService;
import org.apache.nifi.jms.cf.JMSConnectionFactoryHandlerDefinition;
import org.apache.nifi.jms.cf.JMSConnectionFactoryProviderDefinition;
import org.apache.nifi.logging.ComponentLog;

public abstract class AbstractJMSConnectionFactoryProvider
extends AbstractControllerService
implements JMSConnectionFactoryProviderDefinition,
VerifiableControllerService {
    private static final String ESTABLISH_CONNECTION = "Establish Connection";
    private static final String VERIFY_JMS_INTERACTION = "Verify JMS Interaction";
    protected volatile JMSConnectionFactoryHandlerDefinition delegate;

    protected abstract JMSConnectionFactoryHandlerDefinition createConnectionFactoryHandler(ConfigurationContext var1, ComponentLog var2);

    @OnEnabled
    public void onEnabled(ConfigurationContext context) {
        this.delegate = this.createConnectionFactoryHandler(context, this.getLogger());
    }

    @OnDisabled
    public void onDisabled() {
        this.delegate = null;
    }

    @Override
    public ConnectionFactory getConnectionFactory() {
        return this.delegate.getConnectionFactory();
    }

    @Override
    public void resetConnectionFactory(ConnectionFactory cachedFactory) {
        this.delegate.resetConnectionFactory(cachedFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ConfigVerificationResult> verify(ConfigurationContext context, ComponentLog verificationLogger, Map<String, String> variables) {
        ArrayList<ConfigVerificationResult> results = new ArrayList<ConfigVerificationResult>();
        JMSConnectionFactoryHandlerDefinition handler = this.createConnectionFactoryHandler(context, verificationLogger);
        AtomicReference failureReason = new AtomicReference();
        ExceptionListener listener = failureReason::set;
        Connection connection = this.createConnection(handler.getConnectionFactory(), results, listener, verificationLogger);
        if (connection != null) {
            try {
                this.createSession(connection, results, (Exception)failureReason.get(), verificationLogger);
            }
            finally {
                try {
                    connection.close();
                }
                catch (Exception exception) {}
            }
        }
        return results;
    }

    private Connection createConnection(ConnectionFactory connectionFactory, List<ConfigVerificationResult> results, ExceptionListener exceptionListener, ComponentLog logger) {
        try {
            Connection connection = connectionFactory.createConnection();
            connection.setExceptionListener(exceptionListener);
            results.add(new ConfigVerificationResult.Builder().verificationStepName(ESTABLISH_CONNECTION).outcome(ConfigVerificationResult.Outcome.SUCCESSFUL).explanation("Successfully established a JMS Connection").build());
            return connection;
        }
        catch (JMSSecurityException se) {
            logger.debug("Failed to establish a connection to the JMS Server in order to verify configuration because encountered JMS Security Exception", (Throwable)se);
            results.add(new ConfigVerificationResult.Builder().verificationStepName(ESTABLISH_CONNECTION).outcome(ConfigVerificationResult.Outcome.SKIPPED).explanation("Could not establish a Connection because doing so requires a valid username and password").build());
        }
        catch (Exception e) {
            logger.warn("Failed to establish a connection to the JMS Server in order to verify configuration", (Throwable)e);
            results.add(new ConfigVerificationResult.Builder().verificationStepName(ESTABLISH_CONNECTION).outcome(ConfigVerificationResult.Outcome.FAILED).explanation("Was not able to establish a connection to the JMS Server: " + e).build());
        }
        return null;
    }

    private void createSession(Connection connection, List<ConfigVerificationResult> results, Exception capturedException, ComponentLog logger) {
        try {
            Session session = connection.createSession(false, 2);
            session.close();
            results.add(new ConfigVerificationResult.Builder().verificationStepName(VERIFY_JMS_INTERACTION).outcome(ConfigVerificationResult.Outcome.SUCCESSFUL).explanation("Established a JMS Session with server and successfully terminated it").build());
        }
        catch (Exception e) {
            Exception failure;
            if (capturedException == null) {
                failure = e;
            } else {
                failure = capturedException;
                failure.addSuppressed(e);
            }
            logger.warn("Failed to create a JMS Session in order to verify configuration", (Throwable)failure);
            results.add(new ConfigVerificationResult.Builder().verificationStepName(VERIFY_JMS_INTERACTION).outcome(ConfigVerificationResult.Outcome.FAILED).explanation("Was not able to create a JMS Session: " + failure).build());
        }
    }
}

