/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.server.connector;

import java.util.Arrays;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.jetty.configuration.connector.ApplicationLayerProtocol;
import org.apache.nifi.jetty.configuration.connector.StandardServerConnectorFactory;
import org.apache.nifi.processor.DataUnit;
import org.apache.nifi.security.util.SslContextFactory;
import org.apache.nifi.security.util.StandardTlsConfiguration;
import org.apache.nifi.security.util.TlsConfiguration;
import org.apache.nifi.security.util.TlsException;
import org.apache.nifi.security.util.TlsPlatform;
import org.apache.nifi.util.FormatUtils;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.web.server.util.TrustStoreScanner;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.ssl.KeyStoreScanner;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public class FrameworkServerConnectorFactory
extends StandardServerConnectorFactory {
    private static final String DEFAULT_AUTO_REFRESH_INTERVAL = "30 s";
    private static final int IDLE_TIMEOUT_MULTIPLIER = 2;
    private static final String CIPHER_SUITE_SEPARATOR_PATTERN = ",\\s*";
    private final int headerSize;
    private final int idleTimeout;
    private final Integer storeScanInterval;
    private final String includeCipherSuites;
    private final String excludeCipherSuites;
    private TlsConfiguration tlsConfiguration;
    private SslContextFactory.Server sslContextFactory;

    public FrameworkServerConnectorFactory(Server server, NiFiProperties properties) {
        super(server, FrameworkServerConnectorFactory.getPort(properties));
        this.includeCipherSuites = properties.getProperty("nifi.web.https.ciphersuites.include");
        this.excludeCipherSuites = properties.getProperty("nifi.web.https.ciphersuites.exclude");
        this.headerSize = DataUnit.parseDataSize((String)properties.getWebMaxHeaderSize(), (DataUnit)DataUnit.B).intValue();
        this.idleTimeout = this.getIdleTimeout(properties);
        if (properties.isHTTPSConfigured()) {
            this.tlsConfiguration = StandardTlsConfiguration.fromNiFiProperties((NiFiProperties)properties);
            try {
                SSLContext sslContext = SslContextFactory.createSslContext((TlsConfiguration)this.tlsConfiguration);
                this.setSslContext(sslContext);
            }
            catch (TlsException e) {
                throw new IllegalStateException("Invalid nifi.web.https configuration in nifi.properties", e);
            }
            if (properties.isClientAuthRequiredForRestApi()) {
                this.setNeedClientAuth(true);
            } else {
                this.setWantClientAuth(true);
            }
            if (properties.isSecurityAutoReloadEnabled()) {
                String securityAutoReloadInterval = properties.getSecurityAutoReloadInterval();
                double reloadIntervalSeconds = FormatUtils.getPreciseTimeDuration((String)securityAutoReloadInterval, (TimeUnit)TimeUnit.SECONDS);
                this.storeScanInterval = (int)reloadIntervalSeconds;
            } else {
                this.storeScanInterval = null;
            }
            this.setApplicationLayerProtocols(properties);
            this.setIncludeSecurityProtocols(TlsPlatform.getPreferredProtocols().toArray(new String[0]));
        } else {
            this.storeScanInterval = null;
        }
    }

    protected HttpConfiguration getHttpConfiguration() {
        HttpConfiguration httpConfiguration = super.getHttpConfiguration();
        httpConfiguration.setRequestHeaderSize(this.headerSize);
        httpConfiguration.setResponseHeaderSize(this.headerSize);
        httpConfiguration.setIdleTimeout((long)this.idleTimeout);
        return httpConfiguration;
    }

    protected SslContextFactory.Server getSslContextFactory() {
        if (this.sslContextFactory == null) {
            String[] cipherSuites;
            this.sslContextFactory = super.getSslContextFactory();
            if (StringUtils.isNotBlank((CharSequence)this.includeCipherSuites)) {
                cipherSuites = this.getCipherSuites(this.includeCipherSuites);
                this.sslContextFactory.setIncludeCipherSuites(cipherSuites);
            }
            if (StringUtils.isNotBlank((CharSequence)this.excludeCipherSuites)) {
                cipherSuites = this.getCipherSuites(this.excludeCipherSuites);
                this.sslContextFactory.setExcludeCipherSuites(cipherSuites);
            }
            if (this.storeScanInterval != null) {
                this.sslContextFactory.setKeyStorePath(this.tlsConfiguration.getKeystorePath());
                KeyStoreScanner keyStoreScanner = new KeyStoreScanner((org.eclipse.jetty.util.ssl.SslContextFactory)this.sslContextFactory);
                keyStoreScanner.setScanInterval(this.storeScanInterval.intValue());
                this.getServer().addBean((Object)keyStoreScanner);
                this.sslContextFactory.setTrustStorePath(this.tlsConfiguration.getTruststorePath());
                TrustStoreScanner trustStoreScanner = new TrustStoreScanner((org.eclipse.jetty.util.ssl.SslContextFactory)this.sslContextFactory);
                trustStoreScanner.setScanInterval(this.storeScanInterval);
                this.getServer().addBean((Object)trustStoreScanner);
            }
        }
        return this.sslContextFactory;
    }

    private void setApplicationLayerProtocols(NiFiProperties properties) {
        Set protocols = properties.getWebHttpsApplicationProtocols();
        Set applicationLayerProtocols = Arrays.stream(ApplicationLayerProtocol.values()).filter(applicationLayerProtocol -> protocols.contains(applicationLayerProtocol.getProtocol())).collect(Collectors.toSet());
        this.setApplicationLayerProtocols(applicationLayerProtocols);
    }

    private int getIdleTimeout(NiFiProperties properties) {
        String autoRefreshInterval = (String)StringUtils.defaultIfBlank((CharSequence)properties.getAutoRefreshInterval(), (CharSequence)DEFAULT_AUTO_REFRESH_INTERVAL);
        double autoRefreshMilliseconds = FormatUtils.getPreciseTimeDuration((String)autoRefreshInterval, (TimeUnit)TimeUnit.MILLISECONDS);
        return Math.multiplyExact((int)autoRefreshMilliseconds, 2);
    }

    private String[] getCipherSuites(String cipherSuitesProperty) {
        return cipherSuitesProperty.split(CIPHER_SUITE_SEPARATOR_PATTERN);
    }

    private static int getPort(NiFiProperties properties) {
        Integer httpsPort = properties.getSslPort();
        Integer httpPort = properties.getPort();
        if (ObjectUtils.allNull((Object[])new Object[]{httpsPort, httpPort})) {
            throw new IllegalStateException("Invalid port configuration in nifi.properties: Neither nifi.web.https.port nor nifi.web.http.port specified");
        }
        if (ObjectUtils.allNotNull((Object[])new Object[]{httpsPort, httpPort})) {
            throw new IllegalStateException("Invalid port configuration in nifi.properties: Both nifi.web.https.port and nifi.web.http.port specified");
        }
        return (Integer)ObjectUtils.defaultIfNull((Object)httpsPort, (Object)httpPort);
    }
}

