/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.hl7.query.evaluator.message;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.nifi.hl7.model.HL7Message;
import org.apache.nifi.hl7.model.HL7Segment;
import org.apache.nifi.hl7.query.evaluator.Evaluator;
import org.apache.nifi.hl7.query.evaluator.StringEvaluator;

public class SegmentEvaluator
implements Evaluator<List> {
    private final StringEvaluator segmentTypeEvaluator;

    public SegmentEvaluator(StringEvaluator segmentTypeEvaluator) {
        this.segmentTypeEvaluator = segmentTypeEvaluator;
    }

    @Override
    public List<HL7Segment> evaluate(Map<String, Object> objectMap) {
        String segmentType = (String)this.segmentTypeEvaluator.evaluate(objectMap);
        if (segmentType == null) {
            return Collections.emptyList();
        }
        HL7Message message = (HL7Message)objectMap.get("message");
        List<HL7Segment> segments = message.getSegments(segmentType);
        return segments == null ? Collections.emptyList() : segments;
    }

    @Override
    public Class<? extends List> getType() {
        return List.class;
    }
}

