/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.hl7.query.evaluator.message;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.nifi.hl7.model.HL7Field;
import org.apache.nifi.hl7.model.HL7Segment;
import org.apache.nifi.hl7.query.evaluator.Evaluator;
import org.apache.nifi.hl7.query.evaluator.IntegerEvaluator;
import org.apache.nifi.hl7.query.evaluator.message.SegmentEvaluator;

public class FieldEvaluator
implements Evaluator<List> {
    private final SegmentEvaluator segmentEvaluator;
    private final IntegerEvaluator indexEvaluator;

    public FieldEvaluator(SegmentEvaluator segmentEvaluator, IntegerEvaluator indexEvaluator) {
        this.segmentEvaluator = segmentEvaluator;
        this.indexEvaluator = indexEvaluator;
    }

    @Override
    public List<HL7Field> evaluate(Map<String, Object> objectMap) {
        Object segments = this.segmentEvaluator.evaluate((Map)objectMap);
        if (segments == null) {
            return Collections.emptyList();
        }
        Integer index = (Integer)this.indexEvaluator.evaluate(objectMap);
        if (index == null) {
            return Collections.emptyList();
        }
        ArrayList<HL7Field> fields = new ArrayList<HL7Field>();
        Iterator iterator = segments.iterator();
        while (iterator.hasNext()) {
            HL7Segment segment = (HL7Segment)iterator.next();
            List<HL7Field> segmentFields = segment.getFields();
            if (segmentFields.size() <= index) continue;
            fields.add(segmentFields.get(index));
        }
        return fields;
    }

    @Override
    public Class<? extends List> getType() {
        return List.class;
    }
}

