/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.hive.metastore;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;

public class ScriptRunner {
    private static final String DEFAULT_DELIMITER = ";";
    private final Connection connection;

    public ScriptRunner(Connection connection) throws SQLException {
        this.connection = connection;
        if (!this.connection.getAutoCommit()) {
            this.connection.setAutoCommit(true);
        }
    }

    public void runScript(Reader reader) throws IOException, SQLException {
        try {
            String line;
            StringBuilder command = new StringBuilder();
            LineNumberReader lineReader = new LineNumberReader(reader);
            while ((line = lineReader.readLine()) != null) {
                String trimmedLine = line.trim();
                if (trimmedLine.isEmpty() || trimmedLine.startsWith("--") || trimmedLine.startsWith("//")) continue;
                if (trimmedLine.endsWith(this.getDelimiter())) {
                    command.append(line, 0, line.lastIndexOf(this.getDelimiter()));
                    command.append(" ");
                    Statement statement = this.connection.createStatement();
                    statement.execute(command.toString());
                    this.connection.commit();
                    command = new StringBuilder();
                    statement.close();
                    continue;
                }
                command.append(line);
                command.append(" ");
            }
        }
        catch (IOException | SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Error running metastore init script.", e);
        }
        finally {
            this.connection.rollback();
        }
    }

    private String getDelimiter() {
        return DEFAULT_DELIMITER;
    }
}

