/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.hive.metastore;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.derby.jdbc.EmbeddedDriver;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaStore;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.IHMSHandler;
import org.apache.hadoop.hive.metastore.RetryingHMSHandler;
import org.apache.hadoop.hive.metastore.TServerSocketKeepAlive;
import org.apache.hadoop.hive.metastore.TSetIpAddressProcessor;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.ThriftHiveMetastore;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.nifi.hive.metastore.ScriptRunner;
import org.apache.thrift.TException;
import org.apache.thrift.TProcessor;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.server.TServer;
import org.apache.thrift.server.TThreadPoolServer;
import org.apache.thrift.transport.TServerSocket;
import org.apache.thrift.transport.TServerTransport;
import org.apache.thrift.transport.TTransportException;
import org.apache.thrift.transport.TTransportFactory;

class MetastoreCore {
    private final String DATABASE_NAME = "test_metastore";
    private String thriftConnectionUri;
    private Configuration hiveConf;
    private HiveMetaStoreClient metaStoreClient;
    private File tempDir;
    private ExecutorService thriftServer;
    private TServer server;

    MetastoreCore() {
    }

    public void initialize(Map<String, String> configOverrides) throws IOException, TException, InvocationTargetException, NoSuchMethodException, IllegalAccessException, NoSuchFieldException, SQLException {
        this.thriftServer = Executors.newSingleThreadExecutor();
        this.tempDir = Files.createTempDirectory("metastore", new FileAttribute[0]).toFile();
        this.setDerbyLogPath();
        this.setupDB("jdbc:derby:" + this.getDerbyPath() + ";create=true");
        this.server = this.thriftServer(configOverrides);
        this.thriftServer.submit(() -> this.server.serve());
        this.metaStoreClient = new HiveMetaStoreClient(this.hiveConf);
        this.metaStoreClient.createDatabase(new Database("test_metastore", "description", this.getDBPath(), new HashMap()));
    }

    public void shutdown() {
        this.metaStoreClient.close();
        if (this.server != null) {
            this.server.stop();
        }
        this.thriftServer.shutdown();
        if (this.tempDir != null) {
            this.tempDir.delete();
        }
    }

    private HiveConf hiveConf(int port, Map<String, String> configOverrides) throws IOException {
        this.thriftConnectionUri = "thrift://localhost:" + port;
        HiveConf hiveConf = new HiveConf(new Configuration(), this.getClass());
        hiveConf.set(MetastoreConf.ConfVars.THRIFT_URIS.getVarname(), this.thriftConnectionUri);
        hiveConf.set(MetastoreConf.ConfVars.WAREHOUSE.getVarname(), "file:" + this.tempDir.getAbsolutePath());
        hiveConf.set(MetastoreConf.ConfVars.WAREHOUSE.getHiveName(), "file:" + this.tempDir.getAbsolutePath());
        hiveConf.set(MetastoreConf.ConfVars.CONNECTION_DRIVER.getVarname(), EmbeddedDriver.class.getName());
        hiveConf.set(MetastoreConf.ConfVars.CONNECT_URL_KEY.getVarname(), "jdbc:derby:" + this.getDerbyPath() + ";create=true");
        hiveConf.set(MetastoreConf.ConfVars.AUTO_CREATE_ALL.getVarname(), "false");
        hiveConf.set(MetastoreConf.ConfVars.SCHEMA_VERIFICATION.getVarname(), "false");
        hiveConf.set(MetastoreConf.ConfVars.HIVE_TXN_MANAGER.getVarname(), "org.apache.hadoop.hive.ql.lockmgr.DummyTxnManager");
        hiveConf.set(MetastoreConf.ConfVars.COMPACTOR_INITIATOR_ON.getVarname(), "true");
        hiveConf.set(MetastoreConf.ConfVars.COMPACTOR_WORKER_THREADS.getVarname(), "1");
        hiveConf.set(MetastoreConf.ConfVars.HIVE_SUPPORT_CONCURRENCY.getVarname(), "true");
        hiveConf.setBoolean("hcatalog.hive.client.cache.disabled", true);
        hiveConf.set(MetastoreConf.ConfVars.CONNECTION_POOLING_TYPE.getVarname(), "NONE");
        hiveConf.set(MetastoreConf.ConfVars.HMS_HANDLER_FORCE_RELOAD_CONF.getVarname(), "true");
        configOverrides.forEach((arg_0, arg_1) -> ((HiveConf)hiveConf).set(arg_0, arg_1));
        this.writeHiveConfFile(hiveConf);
        return hiveConf;
    }

    private void setDerbyLogPath() throws IOException {
        String derbyLog = Files.createTempFile(this.tempDir.toPath(), "derby", ".log", new FileAttribute[0]).toString();
        System.setProperty("derby.stream.error.file", derbyLog);
    }

    private String getDerbyPath() {
        return new File(this.tempDir, "metastore_db").getPath();
    }

    private TServer thriftServer(Map<String, String> configOverrides) throws TTransportException, MetaException, InvocationTargetException, NoSuchMethodException, IllegalAccessException, NoSuchFieldException, IOException {
        TServerSocketKeepAlive socket = new TServerSocketKeepAlive(new TServerSocket(0));
        this.hiveConf = this.hiveConf(socket.getServerSocket().getLocalPort(), configOverrides);
        HiveMetaStore.HMSHandler baseHandler = new HiveMetaStore.HMSHandler("new db based metaserver", this.hiveConf);
        IHMSHandler handler = RetryingHMSHandler.getProxy((Configuration)this.hiveConf, (IHMSHandler)baseHandler, (boolean)true);
        TTransportFactory transportFactory = new TTransportFactory();
        TSetIpAddressProcessor processor = new TSetIpAddressProcessor((ThriftHiveMetastore.Iface)handler);
        TThreadPoolServer.Args args = ((TThreadPoolServer.Args)((TThreadPoolServer.Args)((TThreadPoolServer.Args)new TThreadPoolServer.Args((TServerTransport)socket).processor((TProcessor)processor)).transportFactory(transportFactory)).protocolFactory((TProtocolFactory)new TBinaryProtocol.Factory())).minWorkerThreads(3).maxWorkerThreads(5);
        return new TThreadPoolServer(args);
    }

    private void setupDB(String dbURL) throws SQLException, IOException {
        Connection connection = DriverManager.getConnection(dbURL);
        ScriptRunner scriptRunner = new ScriptRunner(connection);
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("hive-schema-4.0.0-alpha-2.derby.sql");
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        scriptRunner.runScript(reader);
    }

    private String getDBPath() {
        return Paths.get(this.tempDir.getAbsolutePath(), "test_metastore.db").toAbsolutePath().toString();
    }

    private void writeHiveConfFile(HiveConf hiveConf) throws IOException {
        File file = new File(this.tempDir.toPath() + "/hive-site.xml");
        hiveConf.writeXml(Files.newOutputStream(file.toPath(), new OpenOption[0]));
    }

    public String getThriftConnectionUri() {
        return this.thriftConnectionUri;
    }

    public String getWarehouseLocation() {
        return this.tempDir.getAbsolutePath();
    }

    public HiveMetaStoreClient getMetaStoreClient() {
        return this.metaStoreClient;
    }

    public Configuration getConfiguration() {
        return this.hiveConf;
    }

    public String getConfigurationLocation() {
        return this.tempDir.toPath() + "/hive-site.xml";
    }
}

