/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.hadoop.util;

import jakarta.xml.bind.annotation.XmlTransient;
import jakarta.xml.bind.annotation.XmlType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.fs.Path;

@XmlType(name="listing")
public class HDFSListing {
    private Date latestTimestamp;
    private Collection<String> matchingPaths;

    public Date getLatestTimestamp() {
        return this.latestTimestamp;
    }

    public void setLatestTimestamp(Date latestTimestamp) {
        this.latestTimestamp = latestTimestamp;
    }

    @XmlTransient
    public Collection<String> getMatchingPaths() {
        return this.matchingPaths;
    }

    public Set<Path> toPaths() {
        HashSet<Path> paths = new HashSet<Path>(this.matchingPaths.size());
        for (String pathname : this.matchingPaths) {
            paths.add(new Path(pathname));
        }
        return paths;
    }

    public void setMatchingPaths(Collection<String> matchingPaths) {
        this.matchingPaths = matchingPaths;
    }

    public Map<String, String> toMap() {
        HashMap<String, String> map = new HashMap<String, String>(1 + this.matchingPaths.size());
        map.put("timestamp", String.valueOf(this.latestTimestamp.getTime()));
        int counter = 0;
        for (String path : this.matchingPaths) {
            map.put("path." + String.valueOf(counter++), path);
        }
        return map;
    }

    public static HDFSListing fromMap(Map<String, String> map) {
        if (map == null || map.isEmpty()) {
            return null;
        }
        String timestampValue = map.get("timestamp");
        long timestamp = Long.parseLong(timestampValue);
        ArrayList<String> matchingPaths = new ArrayList<String>(map.size() - 1);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (!entry.getKey().startsWith("path.")) continue;
            matchingPaths.add(entry.getValue());
        }
        HDFSListing listing = new HDFSListing();
        listing.setLatestTimestamp(new Date(timestamp));
        listing.setMatchingPaths(matchingPaths);
        return listing;
    }

    public static class StateKeys {
        public static final String TIMESTAMP = "timestamp";
        public static final String PATH_PREFIX = "path.";
    }
}

