/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.hadoop;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.Restricted;
import org.apache.nifi.annotation.behavior.Restriction;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.RequiredPermission;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.hadoop.AbstractHadoopProcessor;
import org.apache.nifi.processors.hadoop.ListHDFS;
import org.apache.nifi.processors.hadoop.PutHDFS;
import org.apache.nifi.processors.hadoop.util.GSSExceptionRollbackYieldSessionHandler;

@InputRequirement(value=InputRequirement.Requirement.INPUT_ALLOWED)
@Tags(value={"hadoop", "HCFS", "HDFS", "delete", "remove", "filesystem"})
@CapabilityDescription(value="Deletes one or more files or directories from HDFS. The path can be provided as an attribute from an incoming FlowFile, or a statically set path that is periodically removed. If this processor has an incoming connection, itwill ignore running on a periodic basis and instead rely on incoming FlowFiles to trigger a delete. Note that you may use a wildcard character to match multiple files or directories. If there are no incoming connections no flowfiles will be transfered to any output relationships.  If there is an incoming flowfile then provided there are no detected failures it will be transferred to success otherwise it will be sent to false. If knowledge of globbed files deleted is necessary use ListHDFS first to produce a specific list of files to delete. ")
@Restricted(restrictions={@Restriction(requiredPermission=RequiredPermission.WRITE_DISTRIBUTED_FILESYSTEM, explanation="Provides operator the ability to delete any file that NiFi has access to in HDFS or the local filesystem.")})
@WritesAttributes(value={@WritesAttribute(attribute="hdfs.filename", description="HDFS file to be deleted. If multiple files are deleted, then only the last filename is set."), @WritesAttribute(attribute="hdfs.path", description="HDFS Path specified in the delete request. If multiple paths are deleted, then only the last path is set."), @WritesAttribute(attribute="hadoop.file.url", description="The hadoop url for the file to be deleted."), @WritesAttribute(attribute="hdfs.error.message", description="HDFS error message related to the hdfs.error.code")})
@SeeAlso(value={ListHDFS.class, PutHDFS.class})
public class DeleteHDFS
extends AbstractHadoopProcessor {
    public static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("When an incoming flowfile is used then if there are no errors invoking delete the flowfile will route here.").build();
    public static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("When an incoming flowfile is used and there is a failure while deleting then the flowfile will route here.").build();
    public static final PropertyDescriptor FILE_OR_DIRECTORY = new PropertyDescriptor.Builder().name("file_or_directory").displayName("Path").description("The HDFS file or directory to delete. A wildcard expression may be used to only delete certain files").required(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
    public static final PropertyDescriptor RECURSIVE = new PropertyDescriptor.Builder().name("recursive").displayName("Recursive").description("Remove contents of a non-empty directory recursively").allowableValues(new String[]{"true", "false"}).required(true).defaultValue("true").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    protected final Pattern GLOB_PATTERN = Pattern.compile("\\[|\\]|\\*|\\?|\\^|\\{|\\}|\\\\c");
    protected final Matcher GLOB_MATCHER = this.GLOB_PATTERN.matcher("");
    private static final Set<Relationship> relationships;

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        ArrayList<PropertyDescriptor> props = new ArrayList<PropertyDescriptor>(this.properties);
        props.add(FILE_OR_DIRECTORY);
        props.add(RECURSIVE);
        return props;
    }

    public Set<Relationship> getRelationships() {
        return relationships;
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        FlowFile originalFlowFile = session.get();
        if (originalFlowFile == null && context.hasIncomingConnection()) {
            return;
        }
        FlowFile finalFlowFile = originalFlowFile != null ? originalFlowFile : session.create();
        String fileOrDirectoryName = this.getPath(context, session, finalFlowFile);
        FileSystem fileSystem = this.getFileSystem();
        UserGroupInformation ugi = this.getUserGroupInformation();
        ugi.doAs(() -> {
            FlowFile flowFile = finalFlowFile;
            try {
                ArrayList pathList = Lists.newArrayList();
                if (this.GLOB_MATCHER.reset(fileOrDirectoryName).find()) {
                    FileStatus[] fileStatuses = fileSystem.globStatus(new Path(fileOrDirectoryName));
                    if (fileStatuses != null) {
                        for (FileStatus fileStatus : fileStatuses) {
                            pathList.add(fileStatus.getPath());
                        }
                    }
                } else {
                    pathList.add(new Path(fileOrDirectoryName));
                }
                int failedPath = 0;
                for (Path path : pathList) {
                    if (!fileSystem.exists(path)) continue;
                    try {
                        HashMap attributes = Maps.newHashMapWithExpectedSize((int)2);
                        attributes.put(this.getAttributePrefix() + ".filename", path.getName());
                        attributes.put(this.getAttributePrefix() + ".path", path.getParent().toString());
                        flowFile = session.putAllAttributes(flowFile, (Map)attributes);
                        fileSystem.delete(path, this.isRecursive(context, session));
                        this.getLogger().debug("For flowfile {} Deleted file at path {} with name {}", new Object[]{originalFlowFile, path.getParent(), path.getName()});
                        Path qualifiedPath = path.makeQualified(fileSystem.getUri(), fileSystem.getWorkingDirectory());
                        flowFile = session.putAttribute(flowFile, "hadoop.file.url", qualifiedPath.toString());
                        session.getProvenanceReporter().invokeRemoteProcess(flowFile, qualifiedPath.toString());
                    }
                    catch (IOException ioe) {
                        if (this.handleAuthErrors(ioe, session, context, new GSSExceptionRollbackYieldSessionHandler())) {
                            return null;
                        }
                        this.getLogger().warn("Failed to delete file or directory", (Throwable)ioe);
                        HashMap attributes = Maps.newHashMapWithExpectedSize((int)1);
                        attributes.put(this.getAttributePrefix() + ".error.message", ioe.getMessage());
                        session.transfer(session.putAllAttributes(session.clone(flowFile), (Map)attributes), this.getFailureRelationship());
                        ++failedPath;
                    }
                }
                if (failedPath == 0) {
                    session.transfer(flowFile, this.getSuccessRelationship());
                } else {
                    session.remove(flowFile);
                }
            }
            catch (IOException e) {
                if (this.handleAuthErrors(e, session, context, new GSSExceptionRollbackYieldSessionHandler())) {
                    return null;
                }
                this.getLogger().error("Error processing delete for flowfile {} due to {}", new Object[]{flowFile, e.getMessage(), e});
                session.transfer(flowFile, this.getFailureRelationship());
            }
            return null;
        });
    }

    protected Relationship getSuccessRelationship() {
        return REL_SUCCESS;
    }

    protected Relationship getFailureRelationship() {
        return REL_FAILURE;
    }

    protected boolean isRecursive(ProcessContext context, ProcessSession session) {
        return context.getProperty(RECURSIVE).asBoolean();
    }

    protected String getPath(ProcessContext context, ProcessSession session, FlowFile finalFlowFile) {
        return this.getNormalizedPath(context, FILE_OR_DIRECTORY, finalFlowFile).toString();
    }

    protected String getAttributePrefix() {
        return "hdfs";
    }

    static {
        HashSet<Relationship> relationshipSet = new HashSet<Relationship>();
        relationshipSet.add(REL_SUCCESS);
        relationshipSet.add(REL_FAILURE);
        relationships = Collections.unmodifiableSet(relationshipSet);
    }
}

