/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.hadoop;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processors.hadoop.SequenceFileWriterImpl;
import org.apache.nifi.processors.hadoop.util.InputStreamWritable;
import org.slf4j.LoggerFactory;

public class ZipUnpackerSequenceFileWriter
extends SequenceFileWriterImpl {
    @Override
    protected void processInputStream(InputStream stream, FlowFile flowFile, SequenceFile.Writer writer) throws IOException {
        try (ZipInputStream zipIn = new ZipInputStream(new BufferedInputStream(stream));){
            ZipEntry zipEntry;
            while ((zipEntry = zipIn.getNextEntry()) != null) {
                if (zipEntry.isDirectory()) continue;
                File file = new File(zipEntry.getName());
                String key = file.getName();
                long fileSize = zipEntry.getSize();
                InputStreamWritable inStreamWritable = new InputStreamWritable(zipIn, (int)fileSize);
                writer.append((Writable)new Text(key), (Writable)inStreamWritable);
                logger.debug("Appending FlowFile {} to Sequence File", new Object[]{key});
            }
        }
    }

    static {
        logger = LoggerFactory.getLogger(ZipUnpackerSequenceFileWriter.class);
    }
}

