/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.hadoop.util;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ByteFilteringOutputStream
extends FilterOutputStream {
    private final List<Filter> multiByteFilters = new ArrayList<Filter>();
    private final List<Filter> singleByteFilters = new ArrayList<Filter>();
    private final OutputStream wrapped;

    public ByteFilteringOutputStream(OutputStream toWrap) throws IOException {
        super(toWrap);
        this.wrapped = toWrap;
    }

    @Override
    public synchronized void write(byte[] buffer, int offset, int length) throws IOException {
        for (Filter filter : this.multiByteFilters) {
            if (filter.matches(buffer, offset, length)) {
                this.wrapped.write(filter.replaceWith);
                continue;
            }
            this.wrapped.write(buffer, offset, length);
        }
    }

    @Override
    public synchronized void write(int data) throws IOException {
        for (Filter filter : this.singleByteFilters) {
            if (filter.matches((byte)data)) {
                this.wrapped.write(filter.replaceWith);
                continue;
            }
            this.wrapped.write(data);
        }
    }

    public void addFilter(byte[] toReplace, byte[] replaceWith) {
        this.addFilter(toReplace, replaceWith, -1);
    }

    public void addFilter(byte[] toReplace, byte[] replaceWith, int maxReplacements) {
        this.multiByteFilters.add(new Filter(toReplace, replaceWith, maxReplacements));
    }

    public void addFilter(byte toReplace, byte replaceWith) {
        this.addFilter(toReplace, replaceWith, -1);
    }

    public void addFilter(byte toReplace, byte replaceWith, int maxReplacements) {
        this.singleByteFilters.add(new Filter(new byte[]{toReplace}, new byte[]{replaceWith}, maxReplacements));
    }

    static class Filter {
        final byte[] toReplace;
        final byte[] replaceWith;
        final int maxMatches;
        int numMatches = 0;

        public Filter(byte[] toReplace, byte[] replaceWith, int maxReplacements) {
            this.toReplace = toReplace;
            this.replaceWith = replaceWith;
            this.maxMatches = maxReplacements;
        }

        public boolean matches(byte candidate) {
            return this.matches(new byte[]{candidate}, 0, 1);
        }

        public boolean matches(byte[] candidate, int offset, int length) {
            byte[] compare;
            boolean finishedReplacing;
            boolean bl = finishedReplacing = this.numMatches >= this.maxMatches && this.maxMatches > -1;
            if (finishedReplacing || length != this.toReplace.length) {
                return false;
            }
            if (length == candidate.length) {
                compare = candidate;
            } else {
                compare = new byte[length];
                System.arraycopy(candidate, offset, compare, 0, length);
            }
            boolean match = Arrays.equals(compare, this.toReplace);
            if (match) {
                ++this.numMatches;
            }
            return match;
        }
    }
}

