/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.hbase.util;

import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.ProcessContext;

public class VisibilityUtil {
    public static String pickVisibilityString(String columnFamily, String columnQualifier, FlowFile flowFile, ProcessContext context) {
        if (StringUtils.isBlank((CharSequence)columnFamily)) {
            return null;
        }
        String lookupKey = String.format("visibility.%s%s%s", columnFamily, !StringUtils.isBlank((CharSequence)columnQualifier) ? "." : "", columnQualifier);
        String fromAttribute = flowFile.getAttribute(lookupKey);
        if (fromAttribute == null && !StringUtils.isBlank((CharSequence)columnQualifier)) {
            String lookupKeyFam = String.format("visibility.%s", columnFamily);
            fromAttribute = flowFile.getAttribute(lookupKeyFam);
        }
        if (fromAttribute != null) {
            return fromAttribute;
        }
        PropertyValue descriptor = context.getProperty(lookupKey);
        if (descriptor == null || !descriptor.isSet()) {
            descriptor = context.getProperty(String.format("visibility.%s", columnFamily));
        }
        String retVal = descriptor != null ? descriptor.evaluateAttributeExpressions(flowFile).getValue() : null;
        return retVal;
    }
}

