/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.hbase.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import org.apache.nifi.distributed.cache.client.Deserializer;
import org.apache.nifi.distributed.cache.client.Serializer;
import org.apache.nifi.distributed.cache.client.exception.DeserializationException;
import org.apache.nifi.distributed.cache.client.exception.SerializationException;

public class ObjectSerDe
implements Serializer<Object>,
Deserializer<Object> {
    /*
     * Enabled aggressive exception aggregation
     */
    public Object deserialize(byte[] input) throws DeserializationException, IOException {
        if (input == null || input.length == 0) {
            return null;
        }
        try (ByteArrayInputStream in = new ByteArrayInputStream(input);){
            Object object;
            try (ObjectInputStream objIn = new ObjectInputStream(in);){
                object = objIn.readObject();
            }
            return object;
        }
        catch (ClassNotFoundException e) {
            throw new DeserializationException("Could not deserialize object due to ClassNotFoundException", (Throwable)e);
        }
    }

    public void serialize(Object value, OutputStream output) throws SerializationException, IOException {
        try (ByteArrayOutputStream bOut = new ByteArrayOutputStream();
             ObjectOutputStream objOut = new ObjectOutputStream(bOut);){
            objOut.writeObject(value);
            output.write(bOut.toByteArray());
        }
    }
}

