/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.hbase.util;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.apache.nifi.hbase.scan.ResultCell;

public class RowSerializerUtil {
    public static String getRowId(byte[] rowId, Charset charset, boolean base64encodeValues) {
        if (base64encodeValues) {
            ByteBuffer cellRowBuffer = ByteBuffer.wrap(rowId);
            ByteBuffer base64Buffer = Base64.getEncoder().encode(cellRowBuffer);
            return new String(base64Buffer.array(), StandardCharsets.UTF_8);
        }
        return new String(rowId, charset);
    }

    public static String getCellFamily(ResultCell cell, Charset charset, boolean base64encodeValues) {
        if (base64encodeValues) {
            ByteBuffer cellFamilyBuffer = ByteBuffer.wrap(cell.getFamilyArray(), cell.getFamilyOffset(), cell.getFamilyLength());
            ByteBuffer base64Buffer = Base64.getEncoder().encode(cellFamilyBuffer);
            return new String(base64Buffer.array(), StandardCharsets.UTF_8);
        }
        return new String(cell.getFamilyArray(), cell.getFamilyOffset(), (int)cell.getFamilyLength(), charset);
    }

    public static String getCellQualifier(ResultCell cell, Charset charset, boolean base64encodeValues) {
        if (base64encodeValues) {
            ByteBuffer cellQualifierBuffer = ByteBuffer.wrap(cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength());
            ByteBuffer base64Buffer = Base64.getEncoder().encode(cellQualifierBuffer);
            return new String(base64Buffer.array(), StandardCharsets.UTF_8);
        }
        return new String(cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength(), charset);
    }

    public static String getCellValue(ResultCell cell, Charset charset, boolean base64encodeValues) {
        if (base64encodeValues) {
            ByteBuffer cellValueBuffer = ByteBuffer.wrap(cell.getValueArray(), cell.getValueOffset(), cell.getValueLength());
            ByteBuffer base64Buffer = Base64.getEncoder().encode(cellValueBuffer);
            return new String(base64Buffer.array(), StandardCharsets.UTF_8);
        }
        return new String(cell.getValueArray(), cell.getValueOffset(), cell.getValueLength(), charset);
    }
}

