/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.hbase;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.nifi.annotation.behavior.EventDriven;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.ReadsAttribute;
import org.apache.nifi.annotation.behavior.SupportsBatching;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.Validator;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.hbase.AbstractPutHBase;
import org.apache.nifi.hbase.put.PutColumn;
import org.apache.nifi.hbase.put.PutFlowFile;
import org.apache.nifi.hbase.util.VisibilityUtil;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.record.path.FieldValue;
import org.apache.nifi.record.path.RecordPath;
import org.apache.nifi.record.path.RecordPathResult;
import org.apache.nifi.record.path.util.RecordPathCache;
import org.apache.nifi.serialization.RecordReader;
import org.apache.nifi.serialization.RecordReaderFactory;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.RecordField;
import org.apache.nifi.serialization.record.RecordFieldType;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.nifi.serialization.record.util.IllegalTypeConversionException;
import org.apache.nifi.util.StringUtils;

@EventDriven
@SupportsBatching
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@Tags(value={"hadoop", "hbase", "put", "record"})
@CapabilityDescription(value="Adds rows to HBase based on the contents of a flowfile using a configured record reader.")
@ReadsAttribute(attribute="restart.index", description="Reads restart.index when it needs to replay part of a record set that did not get into HBase.")
@WritesAttribute(attribute="restart.index", description="Writes restart.index when a batch fails to be insert into HBase")
public class PutHBaseRecord
extends AbstractPutHBase {
    protected static final PropertyDescriptor ROW_FIELD_NAME = new PropertyDescriptor.Builder().name("Row Identifier Field Name").description("Specifies the name of a record field whose value should be used as the row id for the given record.").required(true).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    protected static final PropertyDescriptor TIMESTAMP_FIELD_NAME = new PropertyDescriptor.Builder().name("timestamp-field-name").displayName("Timestamp Field Name").description("Specifies the name of a record field whose value should be used as the timestamp for the cells in HBase. The value of this field must be a number, string, or date that can be converted to a long. If this field is left blank, HBase will use the current time.").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    protected static final PropertyDescriptor DEFAULT_VISIBILITY_STRING = new PropertyDescriptor.Builder().name("hbase-default-vis-string").displayName("Default Visibility String").description("When using visibility labels, any value set in this field will be applied to all cells that are written unless an attribute with the convention \"visibility.COLUMN_FAMILY.COLUMN_QUALIFIER\" is present on the flowfile. If this field is left blank, it will be assumed that no visibility is to be set unless visibility-related attributes are set. NOTE: this configuration will have no effect on your data if you have not enabled visibility labels in the HBase cluster.").required(false).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(Validator.VALID).build();
    protected static final String FAIL_VALUE = "Fail";
    protected static final String WARN_VALUE = "Warn";
    protected static final String IGNORE_VALUE = "Ignore";
    protected static final String TEXT_VALUE = "Text";
    protected static final AllowableValue COMPLEX_FIELD_FAIL = new AllowableValue("Fail", "Fail", "Route entire FlowFile to failure if any elements contain complex values.");
    protected static final AllowableValue COMPLEX_FIELD_WARN = new AllowableValue("Warn", "Warn", "Provide a warning and do not include field in row sent to HBase.");
    protected static final AllowableValue COMPLEX_FIELD_IGNORE = new AllowableValue("Ignore", "Ignore", "Silently ignore and do not include in row sent to HBase.");
    protected static final AllowableValue COMPLEX_FIELD_TEXT = new AllowableValue("Text", "Text", "Use the string representation of the complex field as the value of the given column.");
    static final PropertyDescriptor RECORD_READER_FACTORY = new PropertyDescriptor.Builder().name("record-reader").displayName("Record Reader").description("Specifies the Controller Service to use for parsing incoming data and determining the data's schema").identifiesControllerService(RecordReaderFactory.class).required(true).build();
    protected static final PropertyDescriptor COMPLEX_FIELD_STRATEGY = new PropertyDescriptor.Builder().name("Complex Field Strategy").description("Indicates how to handle complex fields, i.e. fields that do not have a single text value.").expressionLanguageSupported(ExpressionLanguageScope.NONE).required(true).allowableValues(new AllowableValue[]{COMPLEX_FIELD_FAIL, COMPLEX_FIELD_WARN, COMPLEX_FIELD_IGNORE, COMPLEX_FIELD_TEXT}).defaultValue(COMPLEX_FIELD_TEXT.getValue()).build();
    protected static final AllowableValue FIELD_ENCODING_STRING = new AllowableValue("String", "String", "Stores the value of each field as a UTF-8 String.");
    protected static final AllowableValue FIELD_ENCODING_BYTES = new AllowableValue("Bytes", "Bytes", "Stores the value of each field as the byte representation of the type derived from the record.");
    protected static final PropertyDescriptor FIELD_ENCODING_STRATEGY = new PropertyDescriptor.Builder().name("Field Encoding Strategy").description("Indicates how to store the value of each field in HBase. The default behavior is to convert each value from the record to a String, and store the UTF-8 bytes. Choosing Bytes will interpret the type of each field from the record, and convert the value to the byte representation of that type, meaning an integer will be stored as the byte representation of that integer.").required(true).allowableValues(new AllowableValue[]{FIELD_ENCODING_STRING, FIELD_ENCODING_BYTES}).defaultValue(FIELD_ENCODING_STRING.getValue()).build();
    protected static final PropertyDescriptor BATCH_SIZE = new PropertyDescriptor.Builder().name("Batch Size").description("The maximum number of records to be sent to HBase at any one time from the record set.").required(true).addValidator(StandardValidators.POSITIVE_INTEGER_VALIDATOR).defaultValue("1000").build();
    protected static final AllowableValue NULL_FIELD_EMPTY = new AllowableValue("empty-bytes", "Empty Bytes", "Use empty bytes. This can be used to overwrite existing fields or to put an empty placeholder value if you want every field to be present even if it has a null value.");
    protected static final AllowableValue NULL_FIELD_SKIP = new AllowableValue("skip-field", "Skip Field", "Skip the field (don't process it at all).");
    protected static final PropertyDescriptor NULL_FIELD_STRATEGY = new PropertyDescriptor.Builder().name("hbase-record-null-field-strategy").displayName("Null Field Strategy").required(true).defaultValue("skip-field").description("Handle null field values as either an empty string or skip them altogether.").allowableValues(new AllowableValue[]{NULL_FIELD_EMPTY, NULL_FIELD_SKIP}).build();
    protected static final PropertyDescriptor VISIBILITY_RECORD_PATH = new PropertyDescriptor.Builder().name("put-hb-rec-visibility-record-path").displayName("Visibility String Record Path Root").description("A record path that points to part of the record which contains a path to a mapping of visibility strings to record paths").required(false).addValidator(Validator.VALID).build();
    protected RecordPathCache recordPathCache;
    static final byte[] EMPTY = "".getBytes();

    public final List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>();
        properties.add(RECORD_READER_FACTORY);
        properties.add(HBASE_CLIENT_SERVICE);
        properties.add(TABLE_NAME);
        properties.add(ROW_FIELD_NAME);
        properties.add(ROW_ID_ENCODING_STRATEGY);
        properties.add(NULL_FIELD_STRATEGY);
        properties.add(COLUMN_FAMILY);
        properties.add(DEFAULT_VISIBILITY_STRING);
        properties.add(VISIBILITY_RECORD_PATH);
        properties.add(TIMESTAMP_FIELD_NAME);
        properties.add(BATCH_SIZE);
        properties.add(COMPLEX_FIELD_STRATEGY);
        properties.add(FIELD_ENCODING_STRATEGY);
        return properties;
    }

    public Set<Relationship> getRelationships() {
        HashSet<Relationship> rels = new HashSet<Relationship>();
        rels.add(REL_SUCCESS);
        rels.add(REL_FAILURE);
        return rels;
    }

    private int addBatch(String tableName, List<PutFlowFile> flowFiles) throws IOException {
        int columns = 0;
        this.clientService.put(tableName, flowFiles);
        for (PutFlowFile put : flowFiles) {
            columns += put.getColumns().size();
        }
        return columns;
    }

    @Override
    @OnScheduled
    public void onScheduled(ProcessContext context) {
        this.recordPathCache = new RecordPathCache(4);
        super.onScheduled(context);
    }

    @Override
    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        int batchSize = context.getProperty(BATCH_SIZE).asInteger();
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        RecordReaderFactory recordParserFactory = (RecordReaderFactory)context.getProperty(RECORD_READER_FACTORY).asControllerService(RecordReaderFactory.class);
        ArrayList<Object> flowFiles = new ArrayList<PutFlowFile>();
        String tableName = context.getProperty(TABLE_NAME).evaluateAttributeExpressions(flowFile).getValue();
        String rowFieldName = context.getProperty(ROW_FIELD_NAME).evaluateAttributeExpressions(flowFile).getValue();
        String columnFamily = context.getProperty(COLUMN_FAMILY).evaluateAttributeExpressions(flowFile).getValue();
        String timestampFieldName = context.getProperty(TIMESTAMP_FIELD_NAME).evaluateAttributeExpressions(flowFile).getValue();
        String fieldEncodingStrategy = context.getProperty(FIELD_ENCODING_STRATEGY).getValue();
        String complexFieldStrategy = context.getProperty(COMPLEX_FIELD_STRATEGY).getValue();
        String rowEncodingStrategy = context.getProperty(ROW_ID_ENCODING_STRATEGY).getValue();
        String recordPathText = context.getProperty(VISIBILITY_RECORD_PATH).getValue();
        RecordPath recordPath = null;
        if (this.recordPathCache != null && !StringUtils.isEmpty((String)recordPathText)) {
            recordPath = this.recordPathCache.getCompiled(recordPathText);
        }
        long start = System.nanoTime();
        int index = 0;
        int columns = 0;
        boolean failed = false;
        String startIndexStr = flowFile.getAttribute("restart.index");
        int startIndex = -1;
        if (startIndexStr != null) {
            startIndex = Integer.parseInt(startIndexStr);
        }
        PutFlowFile last = null;
        try (InputStream in = session.read(flowFile);
             RecordReader reader = recordParserFactory.createRecordReader(flowFile, in, this.getLogger());){
            Record record;
            if (startIndex >= 0) {
                while (index++ < startIndex && reader.nextRecord() != null) {
                }
            }
            while ((record = reader.nextRecord()) != null) {
                PutFlowFile putFlowFile = this.createPut(context, record, reader.getSchema(), recordPath, flowFile, rowFieldName, columnFamily, timestampFieldName, fieldEncodingStrategy, rowEncodingStrategy, complexFieldStrategy);
                if (putFlowFile.getColumns().size() == 0) continue;
                flowFiles.add(putFlowFile);
                ++index;
                if (flowFiles.size() != batchSize) continue;
                columns += this.addBatch(tableName, flowFiles);
                last = (PutFlowFile)flowFiles.get(flowFiles.size() - 1);
                flowFiles = new ArrayList();
            }
            if (flowFiles.size() > 0) {
                columns += this.addBatch(tableName, flowFiles);
                last = (PutFlowFile)flowFiles.get(flowFiles.size() - 1);
            }
        }
        catch (Exception ex) {
            this.getLogger().error("Failed to put records to HBase.", (Throwable)ex);
            failed = true;
        }
        if (!failed) {
            if (columns > 0) {
                this.sendProvenance(session, flowFile, columns, System.nanoTime() - start, last);
            }
            flowFile = session.removeAttribute(flowFile, "restart.index");
            session.transfer(flowFile, REL_SUCCESS);
        } else {
            String restartIndex = Integer.toString(index - flowFiles.size());
            flowFile = session.putAttribute(flowFile, "restart.index", restartIndex);
            if (columns > 0) {
                this.sendProvenance(session, flowFile, columns, System.nanoTime() - start, last);
            }
            flowFile = session.penalize(flowFile);
            session.transfer(flowFile, REL_FAILURE);
        }
    }

    private void sendProvenance(ProcessSession session, FlowFile flowFile, int columns, long time, PutFlowFile pff) {
        String details = String.format("Put %d cells to HBase.", columns);
        session.getProvenanceReporter().send(flowFile, this.getTransitUri(pff), details, time);
    }

    @Override
    protected PutFlowFile createPut(ProcessSession session, ProcessContext context, FlowFile flowFile) {
        return null;
    }

    protected byte[] asBytes(String field, RecordFieldType fieldType, Record record, boolean asString, String complexFieldStrategy) throws PutCreationFailedInvokedException {
        byte[] retVal;
        if (asString) {
            switch (fieldType) {
                case RECORD: 
                case CHOICE: 
                case ARRAY: 
                case MAP: {
                    retVal = this.handleComplexField(record, field, complexFieldStrategy);
                    break;
                }
                default: {
                    String value = record.getAsString(field);
                    retVal = this.clientService.toBytes(value);
                    break;
                }
            }
        } else {
            switch (fieldType) {
                case RECORD: 
                case CHOICE: 
                case ARRAY: 
                case MAP: {
                    retVal = this.handleComplexField(record, field, complexFieldStrategy);
                    break;
                }
                case BOOLEAN: {
                    retVal = this.clientService.toBytes(record.getAsBoolean(field).booleanValue());
                    break;
                }
                case DOUBLE: {
                    retVal = this.clientService.toBytes(record.getAsDouble(field).doubleValue());
                    break;
                }
                case FLOAT: {
                    retVal = this.clientService.toBytes(record.getAsFloat(field).floatValue());
                    break;
                }
                case INT: {
                    retVal = this.clientService.toBytes(record.getAsInt(field).intValue());
                    break;
                }
                case LONG: {
                    retVal = this.clientService.toBytes(record.getAsLong(field).longValue());
                    break;
                }
                default: {
                    String value = record.getAsString(field);
                    retVal = this.clientService.toBytes(value);
                }
            }
        }
        return retVal;
    }

    private byte[] handleComplexField(Record record, String field, String complexFieldStrategy) throws PutCreationFailedInvokedException {
        switch (complexFieldStrategy) {
            case "Fail": {
                this.getLogger().error("Complex value found for {}; routing to failure", new Object[]{field});
                throw new PutCreationFailedInvokedException(String.format("Complex value found for %s; routing to failure", field));
            }
            case "Warn": {
                this.getLogger().warn("Complex value found for {}; skipping", new Object[]{field});
                return null;
            }
            case "Text": {
                String value = record.getAsString(field);
                return this.clientService.toBytes(value);
            }
            case "Ignore": {
                return null;
            }
        }
        return null;
    }

    protected PutFlowFile createPut(ProcessContext context, Record record, RecordSchema schema, RecordPath recordPath, FlowFile flowFile, String rowFieldName, String columnFamily, String timestampFieldName, String fieldEncodingStrategy, String rowEncodingStrategy, String complexFieldStrategy) throws PutCreationFailedInvokedException {
        PutFlowFile retVal = null;
        String tableName = context.getProperty(TABLE_NAME).evaluateAttributeExpressions(flowFile).getValue();
        String nullStrategy = context.getProperty(NULL_FIELD_STRATEGY).getValue();
        String defaultVisibility = context.getProperty(DEFAULT_VISIBILITY_STRING).evaluateAttributeExpressions(flowFile).getValue();
        boolean asString = "String".equals(fieldEncodingStrategy);
        byte[] fam = this.clientService.toBytes(columnFamily);
        if (record != null) {
            Long timestamp;
            if (!StringUtils.isBlank((String)timestampFieldName)) {
                try {
                    timestamp = record.getAsLong(timestampFieldName);
                }
                catch (IllegalTypeConversionException e) {
                    throw new PutCreationFailedInvokedException("Could not convert " + timestampFieldName + " to a long", (Exception)((Object)e));
                }
                if (timestamp == null) {
                    this.getLogger().warn("The value of timestamp field " + timestampFieldName + " was null, record will be inserted with latest timestamp");
                }
            } else {
                timestamp = null;
            }
            RecordField visField = null;
            Map visSettings = null;
            if (recordPath != null) {
                RecordPathResult result = recordPath.evaluate(record);
                FieldValue fv = (FieldValue)result.getSelectedFields().findFirst().get();
                visField = fv.getField();
                visSettings = (Map)fv.getValue();
            }
            ArrayList<PutColumn> columns = new ArrayList<PutColumn>();
            for (String name : schema.getFieldNames()) {
                String visString;
                byte[] fieldValueBytes;
                Object val;
                if (name.equals(rowFieldName) || name.equals(timestampFieldName) || visField != null && name.equals(visField.getFieldName()) || (val = record.getValue(name)) == null && nullStrategy.equals(NULL_FIELD_SKIP.getValue()) || (fieldValueBytes = val == null && nullStrategy.equals(NULL_FIELD_EMPTY.getValue()) ? EMPTY : this.asBytes(name, ((RecordField)schema.getField(name).get()).getDataType().getFieldType(), record, asString, complexFieldStrategy)) == null) continue;
                String string = visString = visField != null && visSettings != null && visSettings.containsKey(name) ? (String)visSettings.get(name) : defaultVisibility;
                if (StringUtils.isBlank((String)visString)) {
                    visString = VisibilityUtil.pickVisibilityString(columnFamily, name, flowFile, context);
                }
                PutColumn column = !StringUtils.isEmpty((String)visString) ? new PutColumn(fam, this.clientService.toBytes(name), fieldValueBytes, timestamp, visString) : new PutColumn(fam, this.clientService.toBytes(name), fieldValueBytes, timestamp);
                columns.add(column);
            }
            String rowIdValue = record.getAsString(rowFieldName);
            if (rowIdValue == null) {
                throw new PutCreationFailedInvokedException(String.format("Row ID was null for flowfile with ID %s", flowFile.getAttribute("uuid")));
            }
            byte[] rowId = this.getRow(rowIdValue, rowEncodingStrategy);
            retVal = new PutFlowFile(tableName, rowId, columns, flowFile);
        }
        return retVal;
    }

    static class PutCreationFailedInvokedException
    extends Exception {
        PutCreationFailedInvokedException(String msg) {
            super(msg);
        }

        PutCreationFailedInvokedException(String msg, Exception e) {
            super(msg, e);
        }
    }
}

