/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.hazelcast.services.cacheclient;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnDisabled;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.distributed.cache.client.AtomicCacheEntry;
import org.apache.nifi.distributed.cache.client.AtomicDistributedMapCacheClient;
import org.apache.nifi.distributed.cache.client.Deserializer;
import org.apache.nifi.distributed.cache.client.Serializer;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.hazelcast.services.cache.HazelcastCache;
import org.apache.nifi.hazelcast.services.cachemanager.HazelcastCacheManager;
import org.apache.nifi.processor.util.StandardValidators;

@Tags(value={"hazelcast", "cache", "map"})
@CapabilityDescription(value="An implementation of DistributedMapCacheClient that uses Hazelcast as the backing cache. This service relies on an other controller service, manages the actual Hazelcast calls, set in Hazelcast Cache Manager.")
public class HazelcastMapCacheClient
extends AbstractControllerService
implements AtomicDistributedMapCacheClient<Long> {
    public static final PropertyDescriptor HAZELCAST_CACHE_MANAGER = new PropertyDescriptor.Builder().name("hazelcast-cache-manager").displayName("Hazelcast Cache Manager").description("A Hazelcast Cache Manager which manages connections to Hazelcast and provides cache instances.").identifiesControllerService(HazelcastCacheManager.class).required(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor HAZELCAST_CACHE_NAME = new PropertyDescriptor.Builder().name("hazelcast-cache-name").displayName("Hazelcast Cache Name").description("The name of a given cache. A Hazelcast cluster may handle multiple independent caches, each identified by a name. Clients using caches with the same name are working on the same data structure within Hazelcast.").required(true).addValidator(StandardValidators.NON_BLANK_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();
    public static final PropertyDescriptor HAZELCAST_ENTRY_TTL = new PropertyDescriptor.Builder().name("hazelcast-entry-ttl").displayName("Hazelcast Entry Lifetime").description("Indicates how long the written entries should exist in Hazelcast. Setting it to '0 secs' means that the datawill exists until its deletion or until the Hazelcast server is shut down.").required(true).addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).defaultValue("0 secs").build();
    private static final long STARTING_REVISION = 1L;
    private static final List<PropertyDescriptor> PROPERTY_DESCRIPTORS;
    private volatile HazelcastCache cache = null;

    @OnEnabled
    public void onEnabled(ConfigurationContext context) {
        HazelcastCacheManager hazelcastCacheManager = (HazelcastCacheManager)context.getProperty(HAZELCAST_CACHE_MANAGER).asControllerService(HazelcastCacheManager.class);
        this.cache = hazelcastCacheManager.getCache(context.getProperty(HAZELCAST_CACHE_NAME).evaluateAttributeExpressions().getValue(), context.getProperty(HAZELCAST_ENTRY_TTL).asTimePeriod(TimeUnit.MILLISECONDS).longValue());
        this.getLogger().debug("Enable Hazelcast cache client for cache " + this.cache.name());
    }

    @OnDisabled
    public void onDisabled() {
        if (this.cache != null) {
            this.getLogger().debug("Disable Hazelcast cache client for cache " + this.cache.name());
            this.cache = null;
        }
    }

    public <K, V> AtomicCacheEntry<K, V, Long> fetch(K key, Serializer<K> keySerializer, Deserializer<V> valueDeserializer) throws IOException {
        byte[] result = this.cache.get(this.getCacheEntryKey(key, keySerializer));
        return result == null ? null : new AtomicCacheEntry(key, HazelcastMapCacheClient.parsePayload(valueDeserializer, result), (Object)HazelcastMapCacheClient.parseRevision(result));
    }

    public <K, V> boolean replace(AtomicCacheEntry<K, V, Long> entry, Serializer<K> keySerializer, Serializer<V> valueSerializer) throws IOException {
        if (entry.getKey() == null) {
            return false;
        }
        String key = this.getCacheEntryKey(entry.getKey(), keySerializer);
        try (HazelcastCache.HazelcastCacheEntryLock lock = this.cache.acquireLock(key);){
            byte[] oldValue = this.cache.get(key);
            if (!(oldValue != null || entry.getRevision().isPresent() && (Long)entry.getRevision().get() >= 1L)) {
                this.cache.put(key, this.serialize(entry.getValue(), valueSerializer, 1L));
                this.getLogger().debug("Entry with key " + key + " was added during replace");
                boolean bl = true;
                return bl;
            }
            if (oldValue != null && Objects.equals(entry.getRevision().get(), HazelcastMapCacheClient.parseRevision(oldValue))) {
                this.cache.put(key, this.serialize(entry.getValue(), valueSerializer, (Long)entry.getRevision().get() + 1L));
                this.getLogger().debug("Entry with key " + key + " was updated during replace, with revision " + entry.getRevision().get() + "1");
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    public <K, V> boolean putIfAbsent(K key, V value, Serializer<K> keySerializer, Serializer<V> valueSerializer) throws IOException {
        return this.cache.putIfAbsent(this.getCacheEntryKey(key, keySerializer), this.serialize(value, valueSerializer, 1L)) == null;
    }

    public <K, V> V getAndPutIfAbsent(K key, V value, Serializer<K> keySerializer, Serializer<V> valueSerializer, Deserializer<V> valueDeserializer) throws IOException {
        byte[] result = this.cache.putIfAbsent(this.getCacheEntryKey(key, keySerializer), this.serialize(value, valueSerializer, 1L));
        return result == null ? null : (V)HazelcastMapCacheClient.parsePayload(valueDeserializer, result);
    }

    public <K> boolean containsKey(K key, Serializer<K> keySerializer) throws IOException {
        return this.cache.contains(this.getCacheEntryKey(key, keySerializer));
    }

    public <K, V> void put(K key, V value, Serializer<K> keySerializer, Serializer<V> valueSerializer) throws IOException {
        this.cache.put(this.getCacheEntryKey(key, keySerializer), this.serialize(value, valueSerializer, 1L));
    }

    public <K, V> V get(K key, Serializer<K> keySerializer, Deserializer<V> valueDeserializer) throws IOException {
        byte[] result = this.cache.get(this.getCacheEntryKey(key, keySerializer));
        return result == null ? null : (V)HazelcastMapCacheClient.parsePayload(valueDeserializer, result);
    }

    public <K> boolean remove(K key, Serializer<K> keySerializer) throws IOException {
        return this.cache.remove(this.getCacheEntryKey(key, keySerializer));
    }

    public long removeByPattern(String regex) throws IOException {
        return this.cache.removeAll((Predicate)new RegexPredicate(regex));
    }

    public void close() {
        this.getLogger().debug("Closing {}", new Object[]{((Object)((Object)this)).getClass().getSimpleName()});
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    private static long parseRevision(byte[] value) {
        return ByteBuffer.wrap(Arrays.copyOfRange(value, 0, 8)).getLong();
    }

    private static <V> V parsePayload(Deserializer<V> deserializer, byte[] value) throws IOException {
        return (V)deserializer.deserialize(Arrays.copyOfRange(value, 8, value.length));
    }

    private <S> String getCacheEntryKey(S key, Serializer<S> serializer) throws IOException {
        String result;
        if (key instanceof String) {
            result = (String)key;
        } else {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            serializer.serialize(key, (OutputStream)stream);
            result = stream.toString("UTF-8");
        }
        if (result.isEmpty()) {
            throw new IOException("Cache record key cannot be empty!");
        }
        return result;
    }

    private <S> byte[] serialize(S value, Serializer<S> serializer, long version) throws IOException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        stream.write(this.getVersionByteArray(version));
        serializer.serialize(value, (OutputStream)stream);
        return stream.toByteArray();
    }

    private byte[] getVersionByteArray(long version) {
        return ByteBuffer.allocate(8).putLong(version).array();
    }

    static {
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>();
        properties.add(HAZELCAST_CACHE_MANAGER);
        properties.add(HAZELCAST_CACHE_NAME);
        properties.add(HAZELCAST_ENTRY_TTL);
        PROPERTY_DESCRIPTORS = Collections.unmodifiableList(properties);
    }

    private static class RegexPredicate
    implements Predicate<String>,
    Serializable {
        private final Pattern pattern;

        private RegexPredicate(String regex) {
            this.pattern = Pattern.compile(regex);
        }

        @Override
        public boolean test(String string) {
            return this.pattern.matcher(string).matches();
        }
    }
}

