/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.hadoop;

import java.net.UnknownHostException;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashSet;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.hadoop.security.authentication.util.KerberosUtil;
import org.apache.http.auth.Credentials;
import org.apache.http.impl.auth.SPNegoScheme;
import org.apache.nifi.hadoop.KerberosConfiguration;
import org.apache.nifi.hadoop.KerberosKeytabCredentials;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public class KerberosKeytabSPNegoScheme
extends SPNegoScheme {
    public KerberosKeytabSPNegoScheme() {
        super(true, false);
    }

    public byte[] generateToken(final byte[] input, final String authServer, Credentials credentials) {
        HashSet<Principal> principals = new HashSet<Principal>();
        principals.add(credentials.getUserPrincipal());
        Subject subject = new Subject(false, principals, new HashSet(), new HashSet());
        try {
            LoginContext loginContext = new LoginContext("", subject, null, new KerberosConfiguration(credentials.getUserPrincipal().getName(), ((KerberosKeytabCredentials)credentials).getKeytab()));
            loginContext.login();
            Subject loggedInSubject = loginContext.getSubject();
            return Subject.doAs(loggedInSubject, new PrivilegedExceptionAction<byte[]>(){

                @Override
                public byte[] run() throws UnknownHostException, ClassNotFoundException, GSSException, IllegalAccessException, NoSuchFieldException {
                    GSSManager gssManager = GSSManager.getInstance();
                    String servicePrincipal = KerberosUtil.getServicePrincipal((String)"HTTP", (String)authServer);
                    Oid serviceOid = KerberosUtil.getOidInstance((String)"NT_GSS_KRB5_PRINCIPAL");
                    GSSName serviceName = gssManager.createName(servicePrincipal, serviceOid);
                    Oid mechOid = KerberosUtil.getOidInstance((String)"GSS_KRB5_MECH_OID");
                    GSSContext gssContext = gssManager.createContext(serviceName, mechOid, null, 0);
                    gssContext.requestCredDeleg(true);
                    gssContext.requestMutualAuth(true);
                    return gssContext.initSecContext(input, 0, input.length);
                }
            });
        }
        catch (PrivilegedActionException | LoginException e) {
            throw new RuntimeException(e);
        }
    }
}

