/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.properties;

import java.io.IOException;
import java.io.UncheckedIOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.authentication.util.SsoConfigurationUtil;
import org.apache.nifi.util.hpe.HpeProperties;

public class HadoopConfiguration
implements HpeProperties {
    private final Configuration configuration = new Configuration();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(String name) {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            String string = this.configuration.get(name);
            return string;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    public char[] getPassword(String name) {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            char[] cArray = this.configuration.getPassword(name);
            return cArray;
        }
        catch (IOException e) {
            throw new UncheckedIOException(String.format("Failed to get property '%s'", name), e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResource(String parent, String child) {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            this.configuration.addResource(new Path(parent, child));
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    public String getOidcDiscoveryUrl() {
        Object clientIssuer = SsoConfigurationUtil.getInstance().getClientIssuer();
        if (!((String)clientIssuer).isBlank()) {
            clientIssuer = (String)clientIssuer + "/.well-known/openid-configuration";
        }
        return clientIssuer;
    }

    public String getOidcClientId() {
        return SsoConfigurationUtil.getInstance().getClientId();
    }

    public String getOidcClientSecret() {
        return SsoConfigurationUtil.getInstance().getClientSecret();
    }

    public String getUserClaim() {
        return SsoConfigurationUtil.getInstance().getUserAttrName();
    }
}

