/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.org.h2.store.fs;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.NonWritableChannelException;
import org.apache.nifi.org.h2.store.fs.FakeFileChannel;
import org.apache.nifi.org.h2.store.fs.FileBase;
import org.apache.nifi.org.h2.store.fs.FileMemData;

class FileMem
extends FileBase {
    FileMemData data;
    private final boolean readOnly;
    private long pos;

    FileMem(FileMemData fileMemData, boolean bl) {
        this.data = fileMemData;
        this.readOnly = bl;
    }

    @Override
    public long size() {
        return this.data.length();
    }

    @Override
    public FileChannel truncate(long l) throws IOException {
        if (this.readOnly) {
            throw new NonWritableChannelException();
        }
        if (this.data == null) {
            throw new ClosedChannelException();
        }
        if (l < this.size()) {
            this.data.touch(this.readOnly);
            this.pos = Math.min(this.pos, l);
            this.data.truncate(l);
        }
        return this;
    }

    @Override
    public FileChannel position(long l) {
        this.pos = l;
        return this;
    }

    @Override
    public int write(ByteBuffer byteBuffer, long l) throws IOException {
        if (this.data == null) {
            throw new ClosedChannelException();
        }
        int n = byteBuffer.remaining();
        if (n == 0) {
            return 0;
        }
        this.data.touch(this.readOnly);
        this.data.readWrite(l, byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), n, true);
        byteBuffer.position(byteBuffer.position() + n);
        return n;
    }

    @Override
    public int write(ByteBuffer byteBuffer) throws IOException {
        if (this.data == null) {
            throw new ClosedChannelException();
        }
        int n = byteBuffer.remaining();
        if (n == 0) {
            return 0;
        }
        this.data.touch(this.readOnly);
        this.pos = this.data.readWrite(this.pos, byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), n, true);
        byteBuffer.position(byteBuffer.position() + n);
        return n;
    }

    @Override
    public int read(ByteBuffer byteBuffer, long l) throws IOException {
        if (this.data == null) {
            throw new ClosedChannelException();
        }
        int n = byteBuffer.remaining();
        if (n == 0) {
            return 0;
        }
        long l2 = this.data.readWrite(l, byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), n, false);
        n = (int)(l2 - l);
        if (n <= 0) {
            return -1;
        }
        byteBuffer.position(byteBuffer.position() + n);
        return n;
    }

    @Override
    public int read(ByteBuffer byteBuffer) throws IOException {
        if (this.data == null) {
            throw new ClosedChannelException();
        }
        int n = byteBuffer.remaining();
        if (n == 0) {
            return 0;
        }
        long l = this.data.readWrite(this.pos, byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), n, false);
        n = (int)(l - this.pos);
        if (n <= 0) {
            return -1;
        }
        byteBuffer.position(byteBuffer.position() + n);
        this.pos = l;
        return n;
    }

    @Override
    public long position() {
        return this.pos;
    }

    @Override
    public void implCloseChannel() throws IOException {
        this.pos = 0L;
        this.data = null;
    }

    @Override
    public void force(boolean bl) throws IOException {
    }

    @Override
    public synchronized FileLock tryLock(long l, long l2, boolean bl) throws IOException {
        if (this.data == null) {
            throw new ClosedChannelException();
        }
        if (bl ? !this.data.lockShared() : !this.data.lockExclusive()) {
            return null;
        }
        return new FileLock(FakeFileChannel.INSTANCE, l, l2, bl){

            @Override
            public boolean isValid() {
                return true;
            }

            @Override
            public void release() throws IOException {
                FileMem.this.data.unlock();
            }
        };
    }

    public String toString() {
        return this.data == null ? "<closed>" : this.data.getName();
    }
}

