/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.org.h2.util;

import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.org.h2.message.DbException;

public abstract class LazyFuture<T>
implements Future<T> {
    private static final int S_READY = 0;
    private static final int S_DONE = 1;
    private static final int S_ERROR = 2;
    private static final int S_CANCELED = 3;
    private int state = 0;
    private T result;
    private Exception error;

    public boolean reset() {
        if (this.state == 0) {
            return false;
        }
        this.state = 0;
        this.result = null;
        this.error = null;
        return true;
    }

    protected abstract T run() throws Exception;

    @Override
    public boolean cancel(boolean bl) {
        if (this.state != 0) {
            return false;
        }
        this.state = 3;
        return true;
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        switch (this.state) {
            case 0: {
                try {
                    this.result = this.run();
                    this.state = 1;
                }
                catch (Exception exception) {
                    this.error = exception;
                    if (exception instanceof InterruptedException) {
                        throw (InterruptedException)exception;
                    }
                    throw new ExecutionException(exception);
                }
                finally {
                    if (this.state != 1) {
                        this.state = 2;
                    }
                }
                return this.result;
            }
            case 1: {
                return this.result;
            }
            case 2: {
                throw new ExecutionException(this.error);
            }
            case 3: {
                throw new CancellationException();
            }
        }
        throw DbException.throwInternalError(Integer.toString(this.state));
    }

    @Override
    public T get(long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException {
        return this.get();
    }

    @Override
    public boolean isCancelled() {
        return this.state == 3;
    }

    @Override
    public boolean isDone() {
        return this.state != 0;
    }
}

