/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.org.h2.expression.analysis;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.nifi.org.h2.command.dml.Select;
import org.apache.nifi.org.h2.command.dml.SelectGroups;
import org.apache.nifi.org.h2.engine.Session;
import org.apache.nifi.org.h2.expression.Expression;
import org.apache.nifi.org.h2.expression.analysis.DataAnalysisOperation;
import org.apache.nifi.org.h2.expression.analysis.WindowFrame;
import org.apache.nifi.org.h2.expression.analysis.WindowFunctionType;
import org.apache.nifi.org.h2.message.DbException;
import org.apache.nifi.org.h2.table.ColumnResolver;
import org.apache.nifi.org.h2.table.TableFilter;
import org.apache.nifi.org.h2.value.TypeInfo;
import org.apache.nifi.org.h2.value.Value;
import org.apache.nifi.org.h2.value.ValueDouble;
import org.apache.nifi.org.h2.value.ValueLong;
import org.apache.nifi.org.h2.value.ValueNull;

public class WindowFunction
extends DataAnalysisOperation {
    private final WindowFunctionType type;
    private final Expression[] args;
    private boolean fromLast;
    private boolean ignoreNulls;

    public static int getMinArgumentCount(WindowFunctionType windowFunctionType) {
        switch (windowFunctionType) {
            case NTILE: 
            case LEAD: 
            case LAG: 
            case FIRST_VALUE: 
            case LAST_VALUE: 
            case RATIO_TO_REPORT: {
                return 1;
            }
            case NTH_VALUE: {
                return 2;
            }
        }
        return 0;
    }

    public static int getMaxArgumentCount(WindowFunctionType windowFunctionType) {
        switch (windowFunctionType) {
            case NTILE: 
            case FIRST_VALUE: 
            case LAST_VALUE: 
            case RATIO_TO_REPORT: {
                return 1;
            }
            case LEAD: 
            case LAG: {
                return 3;
            }
            case NTH_VALUE: {
                return 2;
            }
        }
        return 0;
    }

    private static Value getNthValue(Iterator<Value[]> iterator, int n, boolean bl) {
        Value value = ValueNull.INSTANCE;
        int n2 = 0;
        while (iterator.hasNext()) {
            Value value2 = iterator.next()[0];
            if (bl && value2 == ValueNull.INSTANCE || n2++ != n) continue;
            value = value2;
            break;
        }
        return value;
    }

    public WindowFunction(WindowFunctionType windowFunctionType, Select select, Expression[] expressionArray) {
        super(select);
        this.type = windowFunctionType;
        this.args = expressionArray;
    }

    public WindowFunctionType getFunctionType() {
        return this.type;
    }

    public void setFromLast(boolean bl) {
        this.fromLast = bl;
    }

    public void setIgnoreNulls(boolean bl) {
        this.ignoreNulls = bl;
    }

    @Override
    public boolean isAggregate() {
        return false;
    }

    @Override
    protected void updateAggregate(Session session, SelectGroups selectGroups, int n) {
        this.updateOrderedAggregate(session, selectGroups, n, this.over.getOrderBy());
    }

    @Override
    protected void updateGroupAggregates(Session session, int n) {
        super.updateGroupAggregates(session, n);
        if (this.args != null) {
            for (Expression expression : this.args) {
                expression.updateAggregate(session, n);
            }
        }
    }

    @Override
    protected int getNumExpressions() {
        return this.args != null ? this.args.length : 0;
    }

    @Override
    protected void rememberExpressions(Session session, Value[] valueArray) {
        if (this.args != null) {
            int n = this.args.length;
            for (int i = 0; i < n; ++i) {
                valueArray[i] = this.args[i].getValue(session);
            }
        }
    }

    @Override
    protected Object createAggregateData() {
        throw DbException.getUnsupportedException("Window function");
    }

    @Override
    protected void getOrderedResultLoop(Session session, HashMap<Integer, Value> hashMap, ArrayList<Value[]> arrayList, int n) {
        switch (this.type) {
            case ROW_NUMBER: {
                int n2 = 0;
                int n3 = arrayList.size();
                while (n2 < n3) {
                    hashMap.put(arrayList.get(n2)[n].getInt(), ValueLong.get(++n2));
                }
                break;
            }
            case RANK: 
            case DENSE_RANK: 
            case PERCENT_RANK: {
                this.getRank(hashMap, arrayList, n);
                break;
            }
            case CUME_DIST: {
                this.getCumeDist(hashMap, arrayList, n);
                break;
            }
            case NTILE: {
                WindowFunction.getNtile(hashMap, arrayList, n);
                break;
            }
            case LEAD: 
            case LAG: {
                this.getLeadLag(hashMap, arrayList, n);
                break;
            }
            case FIRST_VALUE: 
            case LAST_VALUE: 
            case NTH_VALUE: {
                this.getNth(session, hashMap, arrayList, n);
                break;
            }
            case RATIO_TO_REPORT: {
                WindowFunction.getRatioToReport(hashMap, arrayList, n);
                break;
            }
            default: {
                throw DbException.throwInternalError("type=" + (Object)((Object)this.type));
            }
        }
    }

    private void getRank(HashMap<Integer, Value> hashMap, ArrayList<Value[]> arrayList, int n) {
        int n2 = arrayList.size();
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            int n4;
            Value[] valueArray = arrayList.get(i);
            if (i == 0) {
                n3 = 1;
            } else if (this.getOverOrderBySort().compare(arrayList.get(i - 1), valueArray) != 0) {
                n3 = this.type == WindowFunctionType.DENSE_RANK ? ++n3 : i + 1;
            }
            Value value = this.type == WindowFunctionType.PERCENT_RANK ? ((n4 = n3 - 1) == 0 ? ValueDouble.ZERO : ValueDouble.get((double)n4 / (double)(n2 - 1))) : ValueLong.get(n3);
            hashMap.put(valueArray[n].getInt(), value);
        }
    }

    private void getCumeDist(HashMap<Integer, Value> hashMap, ArrayList<Value[]> arrayList, int n) {
        int n2 = arrayList.size();
        int n3 = 0;
        while (n3 < n2) {
            int n4;
            Value[] valueArray = arrayList.get(n3);
            for (n4 = n3 + 1; n4 < n2 && this.overOrderBySort.compare(valueArray, arrayList.get(n4)) == 0; ++n4) {
            }
            ValueDouble valueDouble = ValueDouble.get((double)n4 / (double)n2);
            for (int i = n3; i < n4; ++i) {
                int n5 = arrayList.get(i)[n].getInt();
                hashMap.put(n5, valueDouble);
            }
            n3 = n4;
        }
    }

    private static void getNtile(HashMap<Integer, Value> hashMap, ArrayList<Value[]> arrayList, int n) {
        int n2 = arrayList.size();
        for (int i = 0; i < n2; ++i) {
            Value[] valueArray = arrayList.get(i);
            long l = valueArray[0].getLong();
            if (l <= 0L) {
                throw DbException.getInvalidValueException("number of tiles", l);
            }
            long l2 = (long)n2 / l;
            long l3 = (long)n2 - l2 * l;
            long l4 = l3 * (l2 + 1L);
            long l5 = (long)i >= l4 ? ((long)i - l4) / l2 + l3 + 1L : (long)i / (l2 + 1L) + 1L;
            hashMap.put(arrayList.get(i)[n].getInt(), ValueLong.get(l5));
        }
    }

    private void getLeadLag(HashMap<Integer, Value> hashMap, ArrayList<Value[]> arrayList, int n) {
        int n2 = arrayList.size();
        int n3 = this.getNumExpressions();
        int n4 = this.args[0].getType().getValueType();
        for (int i = 0; i < n2; ++i) {
            int n5;
            int n6;
            Value[] valueArray = arrayList.get(i);
            int n7 = valueArray[n].getInt();
            if (n3 >= 2) {
                n6 = valueArray[1].getInt();
                if (n6 < 0) {
                    throw DbException.getInvalidValueException("nth row", n6);
                }
            } else {
                n6 = 1;
            }
            Value value = null;
            if (n6 == 0) {
                value = arrayList.get(i)[0];
            } else if (this.type == WindowFunctionType.LEAD) {
                if (this.ignoreNulls) {
                    for (n5 = i + 1; n6 > 0 && n5 < n2; ++n5) {
                        value = arrayList.get(n5)[0];
                        if (value == ValueNull.INSTANCE) continue;
                        --n6;
                    }
                    if (n6 > 0) {
                        value = null;
                    }
                } else if (n6 <= n2 - i - 1) {
                    value = arrayList.get(i + n6)[0];
                }
            } else if (this.ignoreNulls) {
                for (n5 = i - 1; n6 > 0 && n5 >= 0; --n5) {
                    value = arrayList.get(n5)[0];
                    if (value == ValueNull.INSTANCE) continue;
                    --n6;
                }
                if (n6 > 0) {
                    value = null;
                }
            } else if (n6 <= i) {
                value = arrayList.get(i - n6)[0];
            }
            if (value == null) {
                value = n3 >= 3 ? valueArray[2].convertTo(n4) : ValueNull.INSTANCE;
            }
            hashMap.put(n7, value);
        }
    }

    private void getNth(Session session, HashMap<Integer, Value> hashMap, ArrayList<Value[]> arrayList, int n) {
        int n2 = arrayList.size();
        for (int i = 0; i < n2; ++i) {
            Value value;
            Value[] valueArray = arrayList.get(i);
            int n3 = valueArray[n].getInt();
            switch (this.type) {
                case FIRST_VALUE: {
                    value = WindowFunction.getNthValue(WindowFrame.iterator(this.over, session, arrayList, this.getOverOrderBySort(), i, false), 0, this.ignoreNulls);
                    break;
                }
                case LAST_VALUE: {
                    value = WindowFunction.getNthValue(WindowFrame.iterator(this.over, session, arrayList, this.getOverOrderBySort(), i, true), 0, this.ignoreNulls);
                    break;
                }
                case NTH_VALUE: {
                    int n4 = valueArray[1].getInt();
                    if (n4 <= 0) {
                        throw DbException.getInvalidValueException("nth row", n4);
                    }
                    Iterator<Value[]> iterator = WindowFrame.iterator(this.over, session, arrayList, this.getOverOrderBySort(), i, this.fromLast);
                    value = WindowFunction.getNthValue(iterator, --n4, this.ignoreNulls);
                    break;
                }
                default: {
                    throw DbException.throwInternalError("type=" + (Object)((Object)this.type));
                }
            }
            hashMap.put(n3, value);
        }
    }

    private static void getRatioToReport(HashMap<Integer, Value> hashMap, ArrayList<Value[]> arrayList, int n) {
        Value[] valueArray;
        int n2;
        int n3 = arrayList.size();
        Value value = null;
        for (n2 = 0; n2 < n3; ++n2) {
            valueArray = arrayList.get(n2)[0];
            if (valueArray == ValueNull.INSTANCE) continue;
            value = value == null ? valueArray.convertTo(7) : value.add(valueArray.convertTo(7));
        }
        if (value != null && value.getSignum() == 0) {
            value = null;
        }
        for (n2 = 0; n2 < n3; ++n2) {
            Value value2;
            valueArray = arrayList.get(n2);
            if (value == null) {
                value2 = ValueNull.INSTANCE;
            } else {
                value2 = valueArray[0];
                if (value2 != ValueNull.INSTANCE) {
                    value2 = value2.convertTo(7).divide(value);
                }
            }
            hashMap.put(valueArray[n].getInt(), value2);
        }
    }

    @Override
    protected Value getAggregatedValue(Session session, Object object) {
        throw DbException.getUnsupportedException("Window function");
    }

    @Override
    public void mapColumnsAnalysis(ColumnResolver columnResolver, int n, int n2) {
        if (this.args != null) {
            for (Expression expression : this.args) {
                expression.mapColumns(columnResolver, n, n2);
            }
        }
        super.mapColumnsAnalysis(columnResolver, n, n2);
    }

    @Override
    public Expression optimize(Session session) {
        if (this.over.getWindowFrame() != null) {
            switch (this.type) {
                case FIRST_VALUE: 
                case LAST_VALUE: 
                case NTH_VALUE: {
                    break;
                }
                default: {
                    String string = this.getSQL(false);
                    throw DbException.getSyntaxError(string, string.length() - 1);
                }
            }
        }
        if (this.over.getOrderBy() == null) {
            switch (this.type) {
                case NTILE: 
                case LEAD: 
                case LAG: 
                case RANK: 
                case DENSE_RANK: {
                    String string = this.getSQL(false);
                    throw DbException.getSyntaxError(string, string.length() - 1, "ORDER BY");
                }
            }
        } else if (this.type == WindowFunctionType.RATIO_TO_REPORT) {
            String string = this.getSQL(false);
            throw DbException.getSyntaxError(string, string.length() - 1);
        }
        super.optimize(session);
        if (this.args != null) {
            for (int i = 0; i < this.args.length; ++i) {
                this.args[i] = this.args[i].optimize(session);
            }
        }
        return this;
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean bl) {
        if (this.args != null) {
            for (Expression expression : this.args) {
                expression.setEvaluatable(tableFilter, bl);
            }
        }
        super.setEvaluatable(tableFilter, bl);
    }

    @Override
    public TypeInfo getType() {
        switch (this.type) {
            case NTILE: 
            case ROW_NUMBER: 
            case RANK: 
            case DENSE_RANK: {
                return TypeInfo.TYPE_LONG;
            }
            case RATIO_TO_REPORT: 
            case PERCENT_RANK: 
            case CUME_DIST: {
                return TypeInfo.TYPE_DOUBLE;
            }
            case LEAD: 
            case LAG: 
            case FIRST_VALUE: 
            case LAST_VALUE: 
            case NTH_VALUE: {
                return this.args[0].getType();
            }
        }
        throw DbException.throwInternalError("type=" + (Object)((Object)this.type));
    }

    @Override
    public StringBuilder getSQL(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append(this.type.getSQL()).append('(');
        if (this.args != null) {
            WindowFunction.writeExpressions(stringBuilder, this.args, bl);
        }
        stringBuilder.append(')');
        if (this.fromLast && this.type == WindowFunctionType.NTH_VALUE) {
            stringBuilder.append(" FROM LAST");
        }
        if (this.ignoreNulls) {
            switch (this.type) {
                case LEAD: 
                case LAG: 
                case FIRST_VALUE: 
                case LAST_VALUE: 
                case NTH_VALUE: {
                    stringBuilder.append(" IGNORE NULLS");
                }
            }
        }
        return this.appendTailConditions(stringBuilder, bl);
    }

    @Override
    public int getCost() {
        int n = 1;
        if (this.args != null) {
            for (Expression expression : this.args) {
                n += expression.getCost();
            }
        }
        return n;
    }
}

