/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.org.h2.value;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.apache.nifi.org.h2.engine.CastDataProvider;
import org.apache.nifi.org.h2.message.DbException;
import org.apache.nifi.org.h2.util.MathUtils;
import org.apache.nifi.org.h2.value.CompareMode;
import org.apache.nifi.org.h2.value.TypeInfo;
import org.apache.nifi.org.h2.value.Value;

public class ValueDecimal
extends Value {
    public static final Object ZERO = new ValueDecimal(BigDecimal.ZERO);
    public static final Object ONE = new ValueDecimal(BigDecimal.ONE);
    static final int DEFAULT_PRECISION = 65535;
    static final int DEFAULT_SCALE = Short.MAX_VALUE;
    static final int DEFAULT_DISPLAY_SIZE = 65535;
    private static final int DIVIDE_SCALE_ADD = 25;
    private static final int BIG_DECIMAL_SCALE_MAX = 100000;
    private final BigDecimal value;
    private TypeInfo type;

    private ValueDecimal(BigDecimal bigDecimal) {
        if (bigDecimal == null) {
            throw new IllegalArgumentException("null");
        }
        if (bigDecimal.getClass() != BigDecimal.class) {
            throw DbException.get(90125, BigDecimal.class.getName(), bigDecimal.getClass().getName());
        }
        this.value = bigDecimal;
    }

    @Override
    public Value add(Value value) {
        ValueDecimal valueDecimal = (ValueDecimal)value;
        return ValueDecimal.get(this.value.add(valueDecimal.value));
    }

    @Override
    public Value subtract(Value value) {
        ValueDecimal valueDecimal = (ValueDecimal)value;
        return ValueDecimal.get(this.value.subtract(valueDecimal.value));
    }

    @Override
    public Value negate() {
        return ValueDecimal.get(this.value.negate());
    }

    @Override
    public Value multiply(Value value) {
        ValueDecimal valueDecimal = (ValueDecimal)value;
        return ValueDecimal.get(this.value.multiply(valueDecimal.value));
    }

    @Override
    public Value divide(Value value) {
        ValueDecimal valueDecimal = (ValueDecimal)value;
        if (valueDecimal.value.signum() == 0) {
            throw DbException.get(22012, this.getSQL());
        }
        BigDecimal bigDecimal = this.value.divide(valueDecimal.value, this.value.scale() + 25, RoundingMode.HALF_DOWN);
        if (bigDecimal.signum() == 0) {
            bigDecimal = BigDecimal.ZERO;
        } else if (bigDecimal.scale() > 0 && !bigDecimal.unscaledValue().testBit(0)) {
            bigDecimal = bigDecimal.stripTrailingZeros();
        }
        return ValueDecimal.get(bigDecimal);
    }

    @Override
    public ValueDecimal modulus(Value value) {
        ValueDecimal valueDecimal = (ValueDecimal)value;
        if (valueDecimal.value.signum() == 0) {
            throw DbException.get(22012, this.getSQL());
        }
        BigDecimal bigDecimal = this.value.remainder(valueDecimal.value);
        return ValueDecimal.get(bigDecimal);
    }

    @Override
    public StringBuilder getSQL(StringBuilder stringBuilder) {
        return stringBuilder.append(this.getString());
    }

    @Override
    public TypeInfo getType() {
        TypeInfo typeInfo = this.type;
        if (typeInfo == null) {
            long l = this.value.precision();
            this.type = typeInfo = new TypeInfo(6, l, this.value.scale(), MathUtils.convertLongToInt(l + 2L), null);
        }
        return typeInfo;
    }

    @Override
    public int getValueType() {
        return 6;
    }

    @Override
    public int compareTypeSafe(Value value, CompareMode compareMode, CastDataProvider castDataProvider) {
        return this.value.compareTo(((ValueDecimal)value).value);
    }

    @Override
    public int getSignum() {
        return this.value.signum();
    }

    @Override
    public BigDecimal getBigDecimal() {
        return this.value;
    }

    @Override
    public String getString() {
        return this.value.toString();
    }

    @Override
    public boolean checkPrecision(long l) {
        if (l == 65535L) {
            return true;
        }
        return (long)this.value.precision() <= l;
    }

    @Override
    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public Object getObject() {
        return this.value;
    }

    @Override
    public void set(PreparedStatement preparedStatement, int n) throws SQLException {
        preparedStatement.setBigDecimal(n, this.value);
    }

    @Override
    public Value convertScale(boolean bl, int n) {
        if (this.value.scale() == n) {
            return this;
        }
        if ((bl || n >= Short.MAX_VALUE) && this.value.scale() < n) {
            return this;
        }
        BigDecimal bigDecimal = ValueDecimal.setScale(this.value, n);
        return ValueDecimal.get(bigDecimal);
    }

    @Override
    public Value convertPrecision(long l) {
        int n = MathUtils.convertLongToInt(l);
        if (this.value.precision() <= n) {
            return this;
        }
        if (n > 0) {
            return ValueDecimal.get(this.value.round(new MathContext(n)));
        }
        throw DbException.get(22003, this.getString());
    }

    public static ValueDecimal get(BigDecimal bigDecimal) {
        if (BigDecimal.ZERO.equals(bigDecimal)) {
            return (ValueDecimal)ZERO;
        }
        if (BigDecimal.ONE.equals(bigDecimal)) {
            return (ValueDecimal)ONE;
        }
        return (ValueDecimal)Value.cache(new ValueDecimal(bigDecimal));
    }

    public static ValueDecimal get(BigInteger bigInteger) {
        if (bigInteger.signum() == 0) {
            return (ValueDecimal)ZERO;
        }
        if (BigInteger.ONE.equals(bigInteger)) {
            return (ValueDecimal)ONE;
        }
        return (ValueDecimal)Value.cache(new ValueDecimal(new BigDecimal(bigInteger)));
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof ValueDecimal && this.value.equals(((ValueDecimal)object).value);
    }

    @Override
    public int getMemory() {
        return this.value.precision() + 120;
    }

    public static BigDecimal setScale(BigDecimal bigDecimal, int n) {
        if (n > 100000 || n < -100000) {
            throw DbException.getInvalidValueException("scale", n);
        }
        return bigDecimal.setScale(n, RoundingMode.HALF_UP);
    }
}

