/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.org.h2.result;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.apache.nifi.org.h2.command.dml.SelectOrderBy;
import org.apache.nifi.org.h2.engine.Database;
import org.apache.nifi.org.h2.engine.SysProperties;
import org.apache.nifi.org.h2.expression.Expression;
import org.apache.nifi.org.h2.expression.ExpressionColumn;
import org.apache.nifi.org.h2.table.Column;
import org.apache.nifi.org.h2.table.TableFilter;
import org.apache.nifi.org.h2.util.Utils;
import org.apache.nifi.org.h2.value.Value;
import org.apache.nifi.org.h2.value.ValueNull;
import org.apache.nifi.org.h2.value.ValueRow;

public class SortOrder
implements Comparator<Value[]> {
    public static final int ASCENDING = 0;
    public static final int DESCENDING = 1;
    public static final int NULLS_FIRST = 2;
    public static final int NULLS_LAST = 4;
    private static final int DEFAULT_NULL_SORT;
    private static final int DEFAULT_ASC_NULLS;
    private static final int DEFAULT_DESC_NULLS;
    private final Database database;
    private final int[] queryColumnIndexes;
    private final int[] sortTypes;
    private final ArrayList<SelectOrderBy> orderList;

    public SortOrder(Database database, int[] nArray, int[] nArray2, ArrayList<SelectOrderBy> arrayList) {
        this.database = database;
        this.queryColumnIndexes = nArray;
        this.sortTypes = nArray2;
        this.orderList = arrayList;
    }

    public String getSQL(Expression[] expressionArray, int n, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        for (int n3 : this.queryColumnIndexes) {
            if (n2 > 0) {
                stringBuilder.append(", ");
            }
            if (n3 < n) {
                stringBuilder.append(n3 + 1);
            } else {
                stringBuilder.append('=');
                expressionArray[n3].getUnenclosedSQL(stringBuilder, bl);
            }
            SortOrder.typeToString(stringBuilder, this.sortTypes[n2++]);
        }
        return stringBuilder.toString();
    }

    public static void typeToString(StringBuilder stringBuilder, int n) {
        if ((n & 1) != 0) {
            stringBuilder.append(" DESC");
        }
        if ((n & 2) != 0) {
            stringBuilder.append(" NULLS FIRST");
        } else if ((n & 4) != 0) {
            stringBuilder.append(" NULLS LAST");
        }
    }

    public static int compareNull(boolean bl, int n) {
        if ((n & 2) != 0) {
            return bl ? -1 : 1;
        }
        if ((n & 4) != 0) {
            return bl ? 1 : -1;
        }
        int n2 = bl ? DEFAULT_NULL_SORT : -DEFAULT_NULL_SORT;
        return (n & 1) == 0 ? n2 : -n2;
    }

    @Override
    public int compare(Value[] valueArray, Value[] valueArray2) {
        int n = this.queryColumnIndexes.length;
        for (int i = 0; i < n; ++i) {
            boolean bl;
            int n2 = this.queryColumnIndexes[i];
            int n3 = this.sortTypes[i];
            Value value = valueArray[n2];
            Value value2 = valueArray2[n2];
            boolean bl2 = value == ValueNull.INSTANCE;
            boolean bl3 = bl = value2 == ValueNull.INSTANCE;
            if (bl2 || bl) {
                if (bl2 == bl) continue;
                return SortOrder.compareNull(bl2, n3);
            }
            int n4 = this.database.compare(value, value2);
            if (n4 == 0) continue;
            return (n3 & 1) == 0 ? n4 : -n4;
        }
        return 0;
    }

    public void sort(ArrayList<Value[]> arrayList) {
        Collections.sort(arrayList, this);
    }

    public void sort(ArrayList<Value[]> arrayList, int n, int n2) {
        int n3 = arrayList.size();
        if (n3 == 0 || n >= n3 || n2 == 0) {
            return;
        }
        if (n < 0) {
            n = 0;
        }
        if ((n2 = Math.min(n2, n3 - n)) == 1 && n == 0) {
            arrayList.set(0, Collections.min(arrayList, this));
            return;
        }
        Value[][] valueArray = (Value[][])arrayList.toArray((T[])new Value[0][]);
        Utils.sortTopN(valueArray, n, n2, this);
        int n4 = Math.min(n + n2, n3);
        for (int i = 0; i < n4; ++i) {
            arrayList.set(i, valueArray[i]);
        }
    }

    public int[] getQueryColumnIndexes() {
        return this.queryColumnIndexes;
    }

    public Column getColumn(int n, TableFilter tableFilter) {
        if (this.orderList == null) {
            return null;
        }
        SelectOrderBy selectOrderBy = this.orderList.get(n);
        Expression expression = selectOrderBy.expression;
        if (expression == null) {
            return null;
        }
        if ((expression = expression.getNonAliasExpression()).isConstant()) {
            return null;
        }
        if (!(expression instanceof ExpressionColumn)) {
            return null;
        }
        ExpressionColumn expressionColumn = (ExpressionColumn)expression;
        if (expressionColumn.getTableFilter() != tableFilter) {
            return null;
        }
        return expressionColumn.getColumn();
    }

    public int[] getSortTypes() {
        return this.sortTypes;
    }

    public int[] getSortTypesWithNullPosition() {
        int[] nArray = (int[])this.sortTypes.clone();
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            nArray[i] = SortOrder.addExplicitNullPosition(nArray[i]);
        }
        return nArray;
    }

    public Comparator<Value> getRowValueComparator() {
        return new Comparator<Value>(){

            @Override
            public int compare(Value value, Value value2) {
                return SortOrder.this.compare(((ValueRow)value).getList(), ((ValueRow)value2).getList());
            }
        };
    }

    public static int addExplicitNullPosition(int n) {
        if ((n & 6) == 0) {
            return n | ((n & 1) == 0 ? DEFAULT_ASC_NULLS : DEFAULT_DESC_NULLS);
        }
        return n;
    }

    static {
        if (SysProperties.SORT_NULLS_HIGH) {
            DEFAULT_NULL_SORT = 1;
            DEFAULT_ASC_NULLS = 4;
            DEFAULT_DESC_NULLS = 2;
        } else {
            DEFAULT_NULL_SORT = -1;
            DEFAULT_ASC_NULLS = 2;
            DEFAULT_DESC_NULLS = 4;
        }
    }
}

