/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.org.h2.engine;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.nifi.org.h2.Driver;
import org.apache.nifi.org.h2.command.Parser;
import org.apache.nifi.org.h2.engine.Session;
import org.apache.nifi.org.h2.expression.Expression;
import org.apache.nifi.org.h2.message.DbException;
import org.apache.nifi.org.h2.schema.Schema;
import org.apache.nifi.org.h2.schema.SchemaObjectBase;
import org.apache.nifi.org.h2.table.Table;
import org.apache.nifi.org.h2.util.JdbcUtils;
import org.apache.nifi.org.h2.util.SourceCompiler;
import org.apache.nifi.org.h2.util.StringUtils;
import org.apache.nifi.org.h2.value.DataType;
import org.apache.nifi.org.h2.value.Value;
import org.apache.nifi.org.h2.value.ValueArray;
import org.apache.nifi.org.h2.value.ValueNull;

public class FunctionAlias
extends SchemaObjectBase {
    private String className;
    private String methodName;
    private String source;
    private JavaMethod[] javaMethods;
    private boolean deterministic;

    private FunctionAlias(Schema schema, int n, String string) {
        super(schema, n, string, 3);
    }

    public static FunctionAlias newInstance(Schema schema, int n, String string, String string2, boolean bl) {
        FunctionAlias functionAlias = new FunctionAlias(schema, n, string);
        int n2 = string2.indexOf(40);
        int n3 = string2.lastIndexOf(46, n2 < 0 ? string2.length() : n2);
        if (n3 < 0) {
            throw DbException.get(42000, string2);
        }
        functionAlias.className = string2.substring(0, n3);
        functionAlias.methodName = string2.substring(n3 + 1);
        functionAlias.init(bl);
        return functionAlias;
    }

    public static FunctionAlias newInstanceFromSource(Schema schema, int n, String string, String string2, boolean bl) {
        FunctionAlias functionAlias = new FunctionAlias(schema, n, string);
        functionAlias.source = string2;
        functionAlias.init(bl);
        return functionAlias;
    }

    private void init(boolean bl) {
        block2: {
            try {
                this.load();
            }
            catch (DbException dbException) {
                if (bl) break block2;
                throw dbException;
            }
        }
    }

    private synchronized void load() {
        if (this.javaMethods != null) {
            return;
        }
        if (this.source != null) {
            this.loadFromSource();
        } else {
            this.loadClass();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFromSource() {
        SourceCompiler sourceCompiler;
        SourceCompiler sourceCompiler2 = sourceCompiler = this.database.getCompiler();
        synchronized (sourceCompiler2) {
            String string = "org.apache.nifi.org.h2.dynamic." + this.getName();
            sourceCompiler.setSource(string, this.source);
            try {
                Method method = sourceCompiler.getMethod(string);
                JavaMethod javaMethod = new JavaMethod(method, 0);
                this.javaMethods = new JavaMethod[]{javaMethod};
            }
            catch (DbException dbException) {
                throw dbException;
            }
            catch (Exception exception) {
                throw DbException.get(42000, exception, this.source);
            }
        }
    }

    private void loadClass() {
        Class clazz = JdbcUtils.loadUserClass(this.className);
        Method[] methodArray = clazz.getMethods();
        ArrayList<JavaMethod> arrayList = new ArrayList<JavaMethod>(1);
        int n = methodArray.length;
        for (int i = 0; i < n; ++i) {
            Method method = methodArray[i];
            if (!Modifier.isStatic(method.getModifiers()) || !method.getName().equals(this.methodName) && !FunctionAlias.getMethodSignature(method).equals(this.methodName)) continue;
            JavaMethod javaMethod = new JavaMethod(method, i);
            for (JavaMethod javaMethod2 : arrayList) {
                if (javaMethod2.getParameterCount() != javaMethod.getParameterCount()) continue;
                throw DbException.get(90073, javaMethod2.toString(), javaMethod.toString());
            }
            arrayList.add(javaMethod);
        }
        if (arrayList.isEmpty()) {
            throw DbException.get(90139, this.methodName + " (" + this.className + ")");
        }
        this.javaMethods = arrayList.toArray(new JavaMethod[0]);
        Arrays.sort(this.javaMethods);
    }

    private static String getMethodSignature(Method method) {
        StringBuilder stringBuilder = new StringBuilder(method.getName());
        stringBuilder.append('(');
        Class<?>[] classArray = method.getParameterTypes();
        int n = classArray.length;
        for (int i = 0; i < n; ++i) {
            Class<?> clazz;
            if (i > 0) {
                stringBuilder.append(',');
            }
            if ((clazz = classArray[i]).isArray()) {
                stringBuilder.append(clazz.getComponentType().getName()).append("[]");
                continue;
            }
            stringBuilder.append(clazz.getName());
        }
        return stringBuilder.append(')').toString();
    }

    @Override
    public String getCreateSQLForCopy(Table table, String string) {
        throw DbException.throwInternalError(this.toString());
    }

    @Override
    public String getDropSQL() {
        return "DROP ALIAS IF EXISTS " + this.getSQL(true);
    }

    @Override
    public StringBuilder getSQL(StringBuilder stringBuilder, boolean bl) {
        if (this.database.getSettings().functionsInSchema || this.getSchema().getId() != 0) {
            return super.getSQL(stringBuilder, bl);
        }
        return Parser.quoteIdentifier(stringBuilder, this.getName(), bl);
    }

    @Override
    public String getCreateSQL() {
        StringBuilder stringBuilder = new StringBuilder("CREATE FORCE ALIAS ");
        stringBuilder.append(this.getSQL(true));
        if (this.deterministic) {
            stringBuilder.append(" DETERMINISTIC");
        }
        if (this.source != null) {
            stringBuilder.append(" AS ");
            StringUtils.quoteStringSQL(stringBuilder, this.source);
        } else {
            stringBuilder.append(" FOR ");
            Parser.quoteIdentifier(stringBuilder, this.className + "." + this.methodName, true);
        }
        return stringBuilder.toString();
    }

    @Override
    public int getType() {
        return 9;
    }

    @Override
    public synchronized void removeChildrenAndResources(Session session) {
        this.database.removeMeta(session, this.getId());
        this.className = null;
        this.methodName = null;
        this.javaMethods = null;
        this.invalidate();
    }

    @Override
    public void checkRename() {
        throw DbException.getUnsupportedException("RENAME");
    }

    public JavaMethod findJavaMethod(Expression[] expressionArray) {
        this.load();
        int n = expressionArray.length;
        for (JavaMethod javaMethod : this.javaMethods) {
            int n2 = javaMethod.getParameterCount();
            if (n2 != n && (!javaMethod.isVarArgs() || n2 > n + 1)) continue;
            return javaMethod;
        }
        throw DbException.get(90087, this.getName() + " (" + this.className + ", parameter count: " + n + ")");
    }

    public String getJavaClassName() {
        return this.className;
    }

    public String getJavaMethodName() {
        return this.methodName;
    }

    public JavaMethod[] getJavaMethods() {
        this.load();
        return this.javaMethods;
    }

    public void setDeterministic(boolean bl) {
        this.deterministic = bl;
    }

    public boolean isDeterministic() {
        return this.deterministic;
    }

    public String getSource() {
        return this.source;
    }

    public static class JavaMethod
    implements Comparable<JavaMethod> {
        private final int id;
        private final Method method;
        private final int dataType;
        private boolean hasConnectionParam;
        private boolean varArgs;
        private Class<?> varArgClass;
        private int paramCount;

        JavaMethod(Method method, int n) {
            Class<?> clazz;
            this.method = method;
            this.id = n;
            Class<?>[] classArray = method.getParameterTypes();
            this.paramCount = classArray.length;
            if (this.paramCount > 0 && Connection.class.isAssignableFrom(clazz = classArray[0])) {
                this.hasConnectionParam = true;
                --this.paramCount;
            }
            if (this.paramCount > 0 && (clazz = classArray[classArray.length - 1]).isArray() && method.isVarArgs()) {
                this.varArgs = true;
                this.varArgClass = clazz.getComponentType();
            }
            clazz = method.getReturnType();
            this.dataType = DataType.getTypeFromClass(clazz);
        }

        public String toString() {
            return this.method.toString();
        }

        public boolean hasConnectionParam() {
            return this.hasConnectionParam;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Value getValue(Session session, Expression[] expressionArray, boolean bl) {
            Object object;
            Class<?> clazz;
            boolean bl2;
            boolean bl3;
            Class<?>[] classArray = this.method.getParameterTypes();
            Object[] objectArray = new Object[classArray.length];
            int n = 0;
            if (this.hasConnectionParam && objectArray.length > 0) {
                objectArray[n++] = session.createConnection(bl);
            }
            Object object2 = null;
            if (this.varArgs) {
                bl3 = expressionArray.length - objectArray.length + 1 + (this.hasConnectionParam ? 1 : 0);
                objectArray[objectArray.length - 1] = object2 = Array.newInstance(this.varArgClass, bl3 ? 1 : 0);
            }
            bl3 = false;
            boolean bl4 = expressionArray.length;
            while (bl3 < bl4) {
                Object[] objectArray2;
                bl2 = this.varArgs && n >= classArray.length - 1;
                clazz = bl2 ? this.varArgClass : classArray[n];
                int n2 = DataType.getTypeFromClass(clazz);
                object = expressionArray[bl3].getValue(session);
                if (Value.class.isAssignableFrom(clazz)) {
                    objectArray2 = object;
                } else if (((Value)object).getValueType() == 17 && clazz.isArray() && clazz.getComponentType() != Object.class) {
                    Value[] valueArray = ((ValueArray)object).getList();
                    Object[] objectArray3 = (Object[])Array.newInstance(clazz.getComponentType(), valueArray.length);
                    int n3 = DataType.getTypeFromClass(clazz.getComponentType());
                    for (int i = 0; i < objectArray3.length; ++i) {
                        objectArray3[i] = valueArray[i].convertTo(n3, session, false).getObject();
                    }
                    objectArray2 = objectArray3;
                } else {
                    object = ((Value)object).convertTo(n2, session, false);
                    objectArray2 = ((Value)object).getObject();
                }
                if (objectArray2 == null) {
                    if (clazz.isPrimitive()) {
                        if (!bl) return ValueNull.INSTANCE;
                        objectArray2 = DataType.getDefaultForPrimitiveType(clazz);
                    }
                } else if (!clazz.isAssignableFrom(objectArray2.getClass()) && !clazz.isPrimitive()) {
                    objectArray2 = DataType.convertTo(session.createConnection(false), (Value)object, clazz);
                }
                if (bl2) {
                    Array.set(object2, n - objectArray.length + 1, objectArray2);
                } else {
                    objectArray[n] = objectArray2;
                }
                bl3 += 1;
                ++n;
            }
            bl3 = session.getAutoCommit();
            Value value = session.getLastScopeIdentity();
            bl2 = session.getDatabase().getSettings().defaultConnection;
            try {
                session.setAutoCommit(false);
                try {
                    if (bl2) {
                        Driver.setDefaultConnection(session.createConnection(bl));
                    }
                    if ((clazz = this.method.invoke(null, objectArray)) == null) {
                        ValueNull valueNull = ValueNull.INSTANCE;
                        return valueNull;
                    }
                }
                catch (InvocationTargetException invocationTargetException) {
                    object = new StringBuilder(this.method.getName()).append('(');
                    int n4 = objectArray.length;
                    for (int i = 0; i < n4; ++i) {
                        if (i > 0) {
                            ((StringBuilder)object).append(", ");
                        }
                        ((StringBuilder)object).append(objectArray[i]);
                    }
                    ((StringBuilder)object).append(')');
                    throw DbException.convertInvocation(invocationTargetException, ((StringBuilder)object).toString());
                }
                catch (Exception exception) {
                    throw DbException.convert(exception);
                }
                if (Value.class.isAssignableFrom(this.method.getReturnType())) {
                    Value value2 = (Value)((Object)clazz);
                    return value2;
                }
                Value value3 = DataType.convertToValue(session, clazz, this.dataType);
                object = value3.convertTo(this.dataType, session, false);
                return object;
            }
            finally {
                session.setLastScopeIdentity(value);
                session.setAutoCommit(bl3);
                if (bl2) {
                    Driver.setDefaultConnection(null);
                }
            }
        }

        public Class<?>[] getColumnClasses() {
            return this.method.getParameterTypes();
        }

        public int getDataType() {
            return this.dataType;
        }

        public int getParameterCount() {
            return this.paramCount;
        }

        public boolean isVarArgs() {
            return this.varArgs;
        }

        @Override
        public int compareTo(JavaMethod javaMethod) {
            if (this.varArgs != javaMethod.varArgs) {
                return this.varArgs ? 1 : -1;
            }
            if (this.paramCount != javaMethod.paramCount) {
                return this.paramCount - javaMethod.paramCount;
            }
            if (this.hasConnectionParam != javaMethod.hasConnectionParam) {
                return this.hasConnectionParam ? 1 : -1;
            }
            return this.id - javaMethod.id;
        }
    }
}

