/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.org.h2.expression;

import org.apache.nifi.org.h2.command.Prepared;
import org.apache.nifi.org.h2.engine.Session;
import org.apache.nifi.org.h2.expression.Expression;
import org.apache.nifi.org.h2.expression.ExpressionVisitor;
import org.apache.nifi.org.h2.message.DbException;
import org.apache.nifi.org.h2.table.ColumnResolver;
import org.apache.nifi.org.h2.table.TableFilter;
import org.apache.nifi.org.h2.value.TypeInfo;
import org.apache.nifi.org.h2.value.Value;
import org.apache.nifi.org.h2.value.ValueLong;

public class Rownum
extends Expression {
    private final Prepared prepared;

    public Rownum(Prepared prepared) {
        if (prepared == null) {
            throw DbException.throwInternalError();
        }
        this.prepared = prepared;
    }

    @Override
    public Value getValue(Session session) {
        return ValueLong.get(this.prepared.getCurrentRowNumber());
    }

    @Override
    public TypeInfo getType() {
        return TypeInfo.TYPE_LONG;
    }

    @Override
    public void mapColumns(ColumnResolver columnResolver, int n, int n2) {
    }

    @Override
    public Expression optimize(Session session) {
        return this;
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean bl) {
    }

    @Override
    public String getSQL(boolean bl) {
        return "ROWNUM()";
    }

    @Override
    public StringBuilder getSQL(StringBuilder stringBuilder, boolean bl) {
        return stringBuilder.append("ROWNUM()");
    }

    @Override
    public void updateAggregate(Session session, int n) {
    }

    @Override
    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        switch (expressionVisitor.getType()) {
            case 0: 
            case 1: 
            case 2: 
            case 8: {
                return false;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                return true;
            }
        }
        throw DbException.throwInternalError("type=" + expressionVisitor.getType());
    }

    @Override
    public int getCost() {
        return 0;
    }
}

