/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.gcp.pubsub.publish;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.rpc.UnavailableException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processors.gcp.pubsub.PublishGCPubSub;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowFileResult {
    private static final Logger logger = LoggerFactory.getLogger(FlowFileResult.class);
    private final FlowFile flowFile;
    private final Map<String, String> attributes;
    private final List<ApiFuture<String>> futures;
    private final List<String> successes;
    private final List<Throwable> failures;

    public FlowFileResult(FlowFile flowFile, List<ApiFuture<String>> futures, List<String> successes, List<Throwable> failures) {
        this.flowFile = flowFile;
        this.attributes = new LinkedHashMap<String, String>();
        this.futures = futures;
        this.successes = successes;
        this.failures = failures;
    }

    public Relationship reconcile() {
        while (this.futures.size() > this.successes.size() + this.failures.size()) {
            try {
                ApiFutures.allAsList(this.futures).get();
            }
            catch (InterruptedException | ExecutionException e) {
                logger.error("Failed to reconcile PubSub send operation status", (Throwable)e);
            }
        }
        if (this.futures.size() == this.successes.size()) {
            if (this.futures.size() == 1) {
                this.attributes.put("gcp.pubsub.messageId", this.successes.iterator().next());
            } else {
                this.attributes.put("gcp.pubsub.count.records", Integer.toString(this.futures.size()));
            }
        }
        return RelationshipMapper.toRelationship(this.failures);
    }

    public FlowFile getFlowFile() {
        return this.flowFile;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    private static class RelationshipMapper {
        private static final Collection<Class<? extends Throwable>> RETRY_EXCEPTIONS = Collections.singleton(UnavailableException.class);

        private RelationshipMapper() {
        }

        private static Relationship toRelationship(List<Throwable> failures) {
            Relationship relationship = PublishGCPubSub.REL_SUCCESS;
            boolean isRetry = false;
            boolean isFailure = false;
            for (Throwable failure : failures) {
                if (RelationshipMapper.isRetryException(failure)) {
                    isRetry = true;
                    continue;
                }
                isFailure = true;
                break;
            }
            if (isFailure) {
                relationship = PublishGCPubSub.REL_FAILURE;
            } else if (isRetry) {
                relationship = PublishGCPubSub.REL_RETRY;
            }
            return relationship;
        }

        private static boolean isRetryException(Throwable t) {
            if (t == null) {
                return false;
            }
            if (RETRY_EXCEPTIONS.contains(t.getClass())) {
                return true;
            }
            Throwable cause = t.getCause();
            if (t.equals(cause)) {
                return false;
            }
            return RelationshipMapper.isRetryException(cause);
        }
    }
}

