/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.gcp.drive;

import com.google.api.client.http.HttpTransport;
import com.google.api.client.util.DateTime;
import com.google.api.services.drive.Drive;
import com.google.api.services.drive.model.File;
import com.google.api.services.drive.model.FileList;
import java.io.IOException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.PrimaryNodeOnly;
import org.apache.nifi.annotation.behavior.Stateful;
import org.apache.nifi.annotation.behavior.TriggerSerially;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.configuration.DefaultSchedule;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.state.Scope;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processor.util.list.AbstractListProcessor;
import org.apache.nifi.processor.util.list.ListedEntityTracker;
import org.apache.nifi.processors.gcp.ProxyAwareTransportFactory;
import org.apache.nifi.processors.gcp.drive.FetchGoogleDrive;
import org.apache.nifi.processors.gcp.drive.GoogleDriveFileInfo;
import org.apache.nifi.processors.gcp.drive.GoogleDriveFlowFileAttribute;
import org.apache.nifi.processors.gcp.drive.GoogleDriveTrait;
import org.apache.nifi.processors.gcp.drive.PutGoogleDrive;
import org.apache.nifi.processors.gcp.util.GoogleUtils;
import org.apache.nifi.proxy.ProxyConfiguration;
import org.apache.nifi.proxy.ProxySpec;
import org.apache.nifi.scheduling.SchedulingStrategy;
import org.apache.nifi.serialization.record.RecordSchema;

@PrimaryNodeOnly
@TriggerSerially
@Tags(value={"google", "drive", "storage"})
@CapabilityDescription(value="Performs a listing of concrete files (shortcuts are ignored) in a Google Drive folder. If the 'Record Writer' property is set, a single Output FlowFile is created, and each file in the listing is written as a single record to the output file. Otherwise, for each file in the listing, an individual FlowFile is created, the metadata being written as FlowFile attributes. This Processor is designed to run on Primary Node only in a cluster. If the primary node changes, the new Primary Node will pick up where the previous node left off without duplicating all of the data. Please see Additional Details to set up access to Google Drive.")
@SeeAlso(value={FetchGoogleDrive.class, PutGoogleDrive.class})
@InputRequirement(value=InputRequirement.Requirement.INPUT_FORBIDDEN)
@WritesAttributes(value={@WritesAttribute(attribute="drive.id", description="The id of the file"), @WritesAttribute(attribute="filename", description="The name of the file"), @WritesAttribute(attribute="mime.type", description="The MIME type of the file"), @WritesAttribute(attribute="drive.size", description="The size of the file"), @WritesAttribute(attribute="drive.timestamp", description="The last modified time or created time (whichever is greater) of the file. The reason for this is that the original modified date of a file is preserved when uploaded to Google Drive. 'Created time' takes the time when the upload occurs. However uploaded files can still be modified later.")})
@Stateful(scopes={Scope.CLUSTER}, description="The processor stores necessary data to be able to keep track what files have been listed already. What exactly needs to be stored depends on the 'Listing Strategy'. State is stored across the cluster so that this Processor can be run on Primary Node only and if a new Primary Node is selected, the new node can pick up where the previous node left off, without duplicating the data.")
@DefaultSchedule(strategy=SchedulingStrategy.TIMER_DRIVEN, period="1 min")
public class ListGoogleDrive
extends AbstractListProcessor<GoogleDriveFileInfo>
implements GoogleDriveTrait {
    public static final PropertyDescriptor FOLDER_ID = new PropertyDescriptor.Builder().name("folder-id").displayName("Folder ID").description("The ID of the folder from which to pull list of files. Please see Additional Details to set up access to Google Drive and obtain Folder ID. WARNING: Unauthorized access to the folder is treated as if the folder was empty. This results in the processor not creating outgoing FlowFiles. No additional error message is provided.").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).required(true).build();
    public static final PropertyDescriptor RECURSIVE_SEARCH = new PropertyDescriptor.Builder().name("recursive-search").displayName("Search Recursively").description("When 'true', will include list of files from concrete sub-folders (ignores shortcuts). Otherwise, will return only files that have the defined 'Folder ID' as their parent directly. WARNING: The listing may fail if there are too many sub-folders (500+).").required(true).defaultValue("true").allowableValues(new String[]{"true", "false"}).build();
    public static final PropertyDescriptor MIN_AGE = new PropertyDescriptor.Builder().name("min-age").displayName("Minimum File Age").description("The minimum age a file must be in order to be considered; any files younger than this will be ignored.").required(true).addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).defaultValue("0 sec").build();
    public static final PropertyDescriptor LISTING_STRATEGY = new PropertyDescriptor.Builder().fromPropertyDescriptor(AbstractListProcessor.LISTING_STRATEGY).allowableValues(new AllowableValue[]{BY_TIMESTAMPS, BY_ENTITIES, BY_TIME_WINDOW, NO_TRACKING}).build();
    public static final PropertyDescriptor TRACKING_STATE_CACHE = new PropertyDescriptor.Builder().fromPropertyDescriptor(ListedEntityTracker.TRACKING_STATE_CACHE).dependsOn(LISTING_STRATEGY, new AllowableValue[]{BY_ENTITIES}).build();
    public static final PropertyDescriptor TRACKING_TIME_WINDOW = new PropertyDescriptor.Builder().fromPropertyDescriptor(ListedEntityTracker.TRACKING_TIME_WINDOW).dependsOn(LISTING_STRATEGY, new AllowableValue[]{BY_ENTITIES}).build();
    public static final PropertyDescriptor INITIAL_LISTING_TARGET = new PropertyDescriptor.Builder().fromPropertyDescriptor(ListedEntityTracker.INITIAL_LISTING_TARGET).dependsOn(LISTING_STRATEGY, new AllowableValue[]{BY_ENTITIES}).build();
    private static final List<PropertyDescriptor> PROPERTIES = Collections.unmodifiableList(Arrays.asList(GoogleUtils.GCP_CREDENTIALS_PROVIDER_SERVICE, FOLDER_ID, RECURSIVE_SEARCH, MIN_AGE, LISTING_STRATEGY, TRACKING_STATE_CACHE, TRACKING_TIME_WINDOW, INITIAL_LISTING_TARGET, RECORD_WRITER, ProxyConfiguration.createProxyConfigPropertyDescriptor((boolean)false, (ProxySpec[])ProxyAwareTransportFactory.PROXY_SPECS)));
    private volatile Drive driveService;

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTIES;
    }

    protected void customValidate(ValidationContext validationContext, Collection<ValidationResult> results) {
    }

    protected Map<String, String> createAttributes(GoogleDriveFileInfo entity, ProcessContext context) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        for (GoogleDriveFlowFileAttribute attribute : GoogleDriveFlowFileAttribute.values()) {
            Optional.ofNullable(attribute.getValue(entity)).ifPresent(value -> attributes.put(attribute.getName(), (String)value));
        }
        return attributes;
    }

    @OnScheduled
    public void onScheduled(ProcessContext context) throws IOException {
        ProxyConfiguration proxyConfiguration = ProxyConfiguration.getConfiguration((PropertyContext)context);
        HttpTransport httpTransport = new ProxyAwareTransportFactory(proxyConfiguration).create();
        this.driveService = this.createDriveService(context, httpTransport, new String[]{"https://www.googleapis.com/auth/drive.metadata.readonly"});
    }

    protected String getListingContainerName(ProcessContext context) {
        return String.format("Google Drive Folder [%s]", this.getPath(context));
    }

    protected String getPath(ProcessContext context) {
        return context.getProperty(FOLDER_ID).evaluateAttributeExpressions().getValue();
    }

    protected boolean isListingResetNecessary(PropertyDescriptor property) {
        return LISTING_STRATEGY.equals((Object)property) || FOLDER_ID.equals((Object)property) || RECURSIVE_SEARCH.equals((Object)property);
    }

    protected Scope getStateScope(PropertyContext context) {
        return Scope.CLUSTER;
    }

    protected RecordSchema getRecordSchema() {
        return GoogleDriveFileInfo.getRecordSchema();
    }

    protected String getDefaultTimePrecision() {
        return PRECISION_SECONDS.getValue();
    }

    protected List<GoogleDriveFileInfo> performListing(ProcessContext context, Long minTimestamp, AbstractListProcessor.ListingMode listingMode) throws IOException {
        FileList result;
        ArrayList<GoogleDriveFileInfo> listing = new ArrayList<GoogleDriveFileInfo>();
        String folderId = context.getProperty(FOLDER_ID).evaluateAttributeExpressions().getValue();
        Boolean recursive = context.getProperty(RECURSIVE_SEARCH).asBoolean();
        Long minAge = context.getProperty(MIN_AGE).asTimePeriod(TimeUnit.MILLISECONDS);
        StringBuilder queryBuilder = new StringBuilder();
        queryBuilder.append(ListGoogleDrive.buildQueryForDirs(this.driveService, folderId, recursive));
        queryBuilder.append(" and (mimeType != 'application/vnd.google-apps.folder')");
        queryBuilder.append(" and (mimeType != 'application/vnd.google-apps.shortcut')");
        queryBuilder.append(" and trashed = false");
        if (minTimestamp != null && minTimestamp > 0L) {
            String formattedMinTimestamp = DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(OffsetDateTime.ofInstant(Instant.ofEpochMilli(minTimestamp), ZoneOffset.UTC));
            queryBuilder.append(" and (");
            queryBuilder.append("modifiedTime >= '" + formattedMinTimestamp + "'");
            queryBuilder.append(" or createdTime >= '" + formattedMinTimestamp + "'");
            queryBuilder.append(")");
        }
        if (minAge != null && minAge > 0L) {
            long maxTimestamp = System.currentTimeMillis() - minAge;
            String formattedMaxTimestamp = DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(OffsetDateTime.ofInstant(Instant.ofEpochMilli(maxTimestamp), ZoneOffset.UTC));
            queryBuilder.append(" and modifiedTime < '" + formattedMaxTimestamp + "'");
            queryBuilder.append(" and createdTime < '" + formattedMaxTimestamp + "'");
        }
        String pageToken = null;
        do {
            result = (FileList)this.driveService.files().list().setSupportsAllDrives(Boolean.valueOf(true)).setIncludeItemsFromAllDrives(Boolean.valueOf(true)).setQ(queryBuilder.toString()).setPageToken(pageToken).setFields("nextPageToken, files(id, name, size, createdTime, modifiedTime, mimeType)").execute();
            for (File file : result.getFiles()) {
                GoogleDriveFileInfo.Builder builder = new GoogleDriveFileInfo.Builder().id(file.getId()).fileName(file.getName()).size(file.getSize()).createdTime(Optional.ofNullable(file.getCreatedTime()).map(DateTime::getValue).orElse(0L)).modifiedTime(Optional.ofNullable(file.getModifiedTime()).map(DateTime::getValue).orElse(0L)).mimeType(file.getMimeType());
                listing.add(builder.build());
            }
        } while ((pageToken = result.getNextPageToken()) != null);
        return listing;
    }

    protected Integer countUnfilteredListing(ProcessContext context) throws IOException {
        return this.performListing(context, null, AbstractListProcessor.ListingMode.CONFIGURATION_VERIFICATION).size();
    }

    private static String buildQueryForDirs(Drive service, String folderId, boolean recursive) throws IOException {
        StringBuilder queryBuilder = new StringBuilder("('").append(folderId).append("' in parents");
        if (recursive) {
            LinkedList<File> subDirectoryList = new LinkedList<File>();
            ListGoogleDrive.collectSubDirectories(service, folderId, subDirectoryList);
            for (File subDirectory : subDirectoryList) {
                queryBuilder.append(" or '").append(subDirectory.getId()).append("' in parents");
            }
        }
        queryBuilder.append(")");
        return queryBuilder.toString();
    }

    private static void collectSubDirectories(Drive service, String folderId, List<File> dirList) throws IOException {
        FileList directoryList;
        String pageToken = null;
        do {
            directoryList = (FileList)service.files().list().setSupportsAllDrives(Boolean.valueOf(true)).setIncludeItemsFromAllDrives(Boolean.valueOf(true)).setQ("'" + folderId + "' in parents and mimeType = 'application/vnd.google-apps.folder'").setPageToken(pageToken).execute();
            for (File directory : directoryList.getFiles()) {
                dirList.add(directory);
                ListGoogleDrive.collectSubDirectories(service, directory.getId(), dirList);
            }
        } while ((pageToken = directoryList.getNextPageToken()) != null);
    }
}

