/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.gcp.drive;

import com.google.api.client.googleapis.json.GoogleJsonResponseException;
import com.google.api.services.drive.Drive;
import com.google.api.services.drive.model.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.ReadsAttribute;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.gcp.ProxyAwareTransportFactory;
import org.apache.nifi.processors.gcp.drive.GoogleDriveTrait;
import org.apache.nifi.processors.gcp.drive.ListGoogleDrive;
import org.apache.nifi.processors.gcp.drive.PutGoogleDrive;
import org.apache.nifi.processors.gcp.util.GoogleUtils;
import org.apache.nifi.proxy.ProxyConfiguration;
import org.apache.nifi.proxy.ProxySpec;

@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@Tags(value={"google", "drive", "storage", "fetch"})
@CapabilityDescription(value="Fetches files from a Google Drive Folder. Designed to be used in tandem with ListGoogleDrive. Please see Additional Details to set up access to Google Drive.")
@SeeAlso(value={ListGoogleDrive.class, PutGoogleDrive.class})
@ReadsAttribute(attribute="drive.id", description="The id of the file")
@WritesAttributes(value={@WritesAttribute(attribute="drive.id", description="The id of the file"), @WritesAttribute(attribute="filename", description="The name of the file"), @WritesAttribute(attribute="mime.type", description="The MIME type of the file"), @WritesAttribute(attribute="drive.size", description="The size of the file"), @WritesAttribute(attribute="drive.timestamp", description="The last modified time or created time (whichever is greater) of the file. The reason for this is that the original modified date of a file is preserved when uploaded to Google Drive. 'Created time' takes the time when the upload occurs. However uploaded files can still be modified later."), @WritesAttribute(attribute="error.code", description="The error code returned by Google Drive"), @WritesAttribute(attribute="error.message", description="The error message returned by Google Drive")})
public class FetchGoogleDrive
extends AbstractProcessor
implements GoogleDriveTrait {
    private static final AllowableValue EXPORT_MS_WORD = new AllowableValue("application/vnd.openxmlformats-officedocument.wordprocessingml.document", "Microsoft Word");
    private static final AllowableValue EXPORT_OPEN_DOCUMENT = new AllowableValue("application/vnd.oasis.opendocument.text", "OpenDocument");
    private static final AllowableValue EXPORT_PDF = new AllowableValue("application/pdf", "PDF");
    private static final AllowableValue EXPORT_RICH_TEXT = new AllowableValue("application/rtf", "Rich Text");
    private static final AllowableValue EXPORT_EPUB = new AllowableValue("application/epub+zip", "EPUB");
    private static final AllowableValue EXPORT_HTML_DOC = new AllowableValue("application/zip", "Web Page (HTML)");
    private static final AllowableValue EXPORT_PLAIN_TEXT = new AllowableValue("text/plain", "Plain Text");
    private static final AllowableValue EXPORT_MS_EXCEL = new AllowableValue("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "Microsoft Excel");
    private static final AllowableValue EXPORT_OPEN_SPREADSHEET = new AllowableValue("application/x-vnd.oasis.opendocument.spreadsheet", "OpenDocument Spreadsheet");
    private static final AllowableValue EXPORT_PDF_SPREADSHEET = new AllowableValue("application/pdf", "PDF");
    private static final AllowableValue EXPORT_CSV = new AllowableValue("text/csv", "CSV (first sheet only)", "Comma-separated values. Only the first sheet will be exported.");
    private static final AllowableValue EXPORT_TSV = new AllowableValue("text/tab-separated-values", "TSV (first sheet only)", "Tab-separate values. Only the first sheet will be exported.");
    private static final AllowableValue EXPORT_HTML_SPREADSHEET = new AllowableValue("text/html", "Web Page (HTML)");
    private static final AllowableValue EXPORT_MS_POWERPOINT = new AllowableValue("application/vnd.openxmlformats-officedocument.presentationml.presentation", "Microsoft PowerPoint");
    private static final AllowableValue EXPORT_OPEN_PRESENTATION = new AllowableValue("application/vnd.oasis.opendocument.presentation", "OpenDocument Presentation");
    private static final AllowableValue EXPORT_PNG = new AllowableValue("image/png", "PNG (first slide only)");
    private static final AllowableValue EXPORT_JPEG = new AllowableValue("image/jpeg", "JPEG (first slide only)");
    private static final AllowableValue EXPORT_SVG = new AllowableValue("image/svg+xml", "SVG (first slide only)", "Scalable Vector Graphics. Only the first slide will be exported.");
    private static final AllowableValue EXPORT_PNG_DRAWING = new AllowableValue("image/png", "PNG");
    private static final AllowableValue EXPORT_JPEG_DRAWING = new AllowableValue("image/jpeg", "JPEG");
    private static final AllowableValue EXPORT_SVG_DRAWING = new AllowableValue("image/svg+xml", "SVG");
    private static final Map<String, String> fileExtensions = new HashMap<String, String>();
    public static final PropertyDescriptor FILE_ID;
    public static final PropertyDescriptor GOOGLE_DOC_EXPORT_TYPE;
    public static final PropertyDescriptor GOOGLE_SPREADSHEET_EXPORT_TYPE;
    public static final PropertyDescriptor GOOGLE_PRESENTATION_EXPORT_TYPE;
    public static final PropertyDescriptor GOOGLE_DRAWING_EXPORT_TYPE;
    public static final Relationship REL_SUCCESS;
    public static final Relationship REL_FAILURE;
    private static final List<PropertyDescriptor> PROPERTIES;
    public static final Set<Relationship> RELATIONSHIPS;
    private volatile Drive driveService;

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTIES;
    }

    public Set<Relationship> getRelationships() {
        return RELATIONSHIPS;
    }

    @OnScheduled
    public void onScheduled(ProcessContext context) throws IOException {
        ProxyConfiguration proxyConfiguration = ProxyConfiguration.getConfiguration((PropertyContext)context);
        this.driveService = this.createDriveService(context, new ProxyAwareTransportFactory(proxyConfiguration).create(), new String[]{"https://www.googleapis.com/auth/drive", "https://www.googleapis.com/auth/drive.file"});
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        String fileId = context.getProperty(FILE_ID).evaluateAttributeExpressions(flowFile).getValue();
        long startNanos = System.nanoTime();
        try {
            File fileMetadata = this.fetchFileMetadata(fileId);
            Map attributeMap = this.createAttributeMap(fileMetadata);
            flowFile = this.fetchFile(fileId, session, context, flowFile, attributeMap);
            flowFile = session.putAllAttributes(flowFile, attributeMap);
            String url = "https://drive.google.com/open?id=" + fileMetadata.getId();
            long transferMillis = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNanos);
            session.getProvenanceReporter().fetch(flowFile, url, transferMillis);
            session.transfer(flowFile, REL_SUCCESS);
        }
        catch (GoogleJsonResponseException e) {
            this.handleErrorResponse(session, fileId, flowFile, e);
        }
        catch (Exception e) {
            this.handleUnexpectedError(session, flowFile, fileId, e);
        }
    }

    private String getExportType(String mimeType, ProcessContext context) {
        if (mimeType == null) {
            return null;
        }
        switch (mimeType) {
            case "application/vnd.google-apps.document": {
                return context.getProperty(GOOGLE_DOC_EXPORT_TYPE).getValue();
            }
            case "application/vnd.google-apps.spreadsheet": {
                return context.getProperty(GOOGLE_SPREADSHEET_EXPORT_TYPE).getValue();
            }
            case "application/vnd.google-apps.presentation": {
                return context.getProperty(GOOGLE_PRESENTATION_EXPORT_TYPE).getValue();
            }
            case "application/vnd.google-apps.drawing": {
                return context.getProperty(GOOGLE_DRAWING_EXPORT_TYPE).getValue();
            }
            case "application/vnd.google-apps.script": {
                return "application/vnd.google-apps.script+json";
            }
        }
        return null;
    }

    private FlowFile fetchFile(String fileId, ProcessSession session, ProcessContext context, FlowFile flowFile, Map<String, String> attributeMap) throws IOException {
        String mimeType = flowFile.getAttribute(CoreAttributes.MIME_TYPE.key());
        String exportType = this.getExportType(mimeType, context);
        if (exportType == null) {
            return this.downloadFile(fileId, session, flowFile);
        }
        return this.exportFile(fileId, exportType, session, flowFile, attributeMap);
    }

    private FlowFile downloadFile(String fileId, ProcessSession session, FlowFile flowFile) throws IOException {
        try (InputStream driveFileInputStream = this.driveService.files().get(fileId).setSupportsAllDrives(Boolean.valueOf(true)).executeMediaAsInputStream();){
            FlowFile flowFile2 = session.importFrom(driveFileInputStream, flowFile);
            return flowFile2;
        }
    }

    private FlowFile exportFile(String fileId, String exportMimeType, ProcessSession session, FlowFile flowFile, Map<String, String> attributeMap) throws IOException {
        attributeMap.put(CoreAttributes.MIME_TYPE.key(), exportMimeType);
        String fileExtension = fileExtensions.get(exportMimeType);
        if (fileExtension != null) {
            attributeMap.put(CoreAttributes.FILENAME.key(), flowFile.getAttribute(CoreAttributes.FILENAME.key()) + fileExtension);
        }
        try (InputStream driveFileInputStream = this.driveService.files().export(fileId, exportMimeType).executeMediaAsInputStream();){
            FlowFile flowFile2 = session.importFrom(driveFileInputStream, flowFile);
            return flowFile2;
        }
    }

    private File fetchFileMetadata(String fileId) throws IOException {
        return (File)this.driveService.files().get(fileId).setSupportsAllDrives(Boolean.valueOf(true)).setFields("id, name, createdTime, mimeType, size").execute();
    }

    private void handleErrorResponse(ProcessSession session, String fileId, FlowFile flowFile, GoogleJsonResponseException e) {
        this.getLogger().error("Fetching File [{}] failed", new Object[]{fileId, e});
        flowFile = session.putAttribute(flowFile, "error.code", String.valueOf(e.getStatusCode()));
        flowFile = session.putAttribute(flowFile, "error.message", e.getMessage());
        flowFile = session.penalize(flowFile);
        session.transfer(flowFile, REL_FAILURE);
    }

    private void handleUnexpectedError(ProcessSession session, FlowFile flowFile, String fileId, Exception e) {
        this.getLogger().error("Fetching File [{}] failed", new Object[]{fileId, e});
        flowFile = session.putAttribute(flowFile, "error.message", e.getMessage());
        flowFile = session.penalize(flowFile);
        session.transfer(flowFile, REL_FAILURE);
    }

    static {
        fileExtensions.put(EXPORT_MS_WORD.getValue(), ".docx");
        fileExtensions.put(EXPORT_OPEN_DOCUMENT.getValue(), ".odt");
        fileExtensions.put(EXPORT_PDF.getValue(), ".pdf");
        fileExtensions.put(EXPORT_RICH_TEXT.getValue(), ".rtf");
        fileExtensions.put(EXPORT_EPUB.getValue(), ".epub");
        fileExtensions.put(EXPORT_HTML_DOC.getValue(), ".zip");
        fileExtensions.put(EXPORT_PLAIN_TEXT.getValue(), ".txt");
        fileExtensions.put(EXPORT_MS_EXCEL.getValue(), ".xlsx");
        fileExtensions.put(EXPORT_OPEN_SPREADSHEET.getValue(), ".ods");
        fileExtensions.put(EXPORT_CSV.getValue(), ".csv");
        fileExtensions.put(EXPORT_TSV.getValue(), ".tsv");
        fileExtensions.put(EXPORT_MS_POWERPOINT.getValue(), ".pptx");
        fileExtensions.put(EXPORT_OPEN_PRESENTATION.getValue(), ".odp");
        fileExtensions.put(EXPORT_PNG.getValue(), ".png");
        fileExtensions.put(EXPORT_JPEG.getValue(), ".jpg");
        fileExtensions.put(EXPORT_SVG.getValue(), ".svg");
        fileExtensions.put("application/vnd.google-apps.script+json", ".json");
        FILE_ID = new PropertyDescriptor.Builder().name("drive-file-id").displayName("File ID").description("The Drive ID of the File to fetch. Please see Additional Details for information on how to obtain the Drive ID.").required(true).defaultValue("${drive.id}").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
        GOOGLE_DOC_EXPORT_TYPE = new PropertyDescriptor.Builder().name("Google Doc Export Type").description("Google Documents cannot be downloaded directly from Google Drive but instead must be exported to a specified MIME Type. In the event that the incoming FlowFile's MIME Type indicates that the file is a Google Document, this property specifies the MIME Type to export the document to.").required(true).allowableValues(new AllowableValue[]{EXPORT_PDF, EXPORT_PLAIN_TEXT, EXPORT_MS_WORD, EXPORT_OPEN_DOCUMENT, EXPORT_RICH_TEXT, EXPORT_HTML_DOC, EXPORT_EPUB}).defaultValue(EXPORT_PDF.getValue()).build();
        GOOGLE_SPREADSHEET_EXPORT_TYPE = new PropertyDescriptor.Builder().name("Google Spreadsheet Export Type").description("Google Spreadsheets cannot be downloaded directly from Google Drive but instead must be exported to a specified MIME Type. In the event that the incoming FlowFile's MIME Type indicates that the file is a Google Spreadsheet, this property specifies the MIME Type to export the spreadsheet to.").required(true).allowableValues(new AllowableValue[]{EXPORT_CSV, EXPORT_MS_EXCEL, EXPORT_PDF_SPREADSHEET, EXPORT_TSV, EXPORT_HTML_SPREADSHEET, EXPORT_OPEN_SPREADSHEET}).defaultValue(EXPORT_CSV.getValue()).build();
        GOOGLE_PRESENTATION_EXPORT_TYPE = new PropertyDescriptor.Builder().name("Google Presentation Export Type").description("Google Presentations cannot be downloaded directly from Google Drive but instead must be exported to a specified MIME Type. In the event that the incoming FlowFile's MIME Type indicates that the file is a Google Presentation, this property specifies the MIME Type to export the presentation to.").required(true).allowableValues(new AllowableValue[]{EXPORT_PDF, EXPORT_MS_POWERPOINT, EXPORT_PLAIN_TEXT, EXPORT_OPEN_PRESENTATION, EXPORT_PNG, EXPORT_JPEG, EXPORT_SVG}).defaultValue(EXPORT_PDF.getValue()).build();
        GOOGLE_DRAWING_EXPORT_TYPE = new PropertyDescriptor.Builder().name("Google Drawing Export Type").description("Google Drawings cannot be downloaded directly from Google Drive but instead must be exported to a specified MIME Type. In the event that the incoming FlowFile's MIME Type indicates that the file is a Google Drawing, this property specifies the MIME Type to export the drawing to.").required(true).allowableValues(new AllowableValue[]{EXPORT_PDF, EXPORT_PNG_DRAWING, EXPORT_JPEG_DRAWING, EXPORT_SVG_DRAWING}).defaultValue(EXPORT_PDF.getValue()).build();
        REL_SUCCESS = new Relationship.Builder().name("success").description("A FlowFile will be routed here for each successfully fetched File.").build();
        REL_FAILURE = new Relationship.Builder().name("failure").description("A FlowFile will be routed here for each File for which fetch was attempted but failed.").build();
        PROPERTIES = Collections.unmodifiableList(Arrays.asList(GoogleUtils.GCP_CREDENTIALS_PROVIDER_SERVICE, FILE_ID, ProxyConfiguration.createProxyConfigPropertyDescriptor((boolean)false, (ProxySpec[])ProxyAwareTransportFactory.PROXY_SPECS), GOOGLE_DOC_EXPORT_TYPE, GOOGLE_SPREADSHEET_EXPORT_TYPE, GOOGLE_PRESENTATION_EXPORT_TYPE, GOOGLE_DRAWING_EXPORT_TYPE));
        RELATIONSHIPS = Collections.unmodifiableSet(new HashSet<Relationship>(Arrays.asList(REL_SUCCESS, REL_FAILURE)));
    }
}

