/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.gcp.bigquery;

import com.google.api.gax.retrying.RetrySettings;
import com.google.auth.Credentials;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.BaseServiceException;
import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.BigQueryOptions;
import com.google.cloud.bigquery.TableId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.nifi.components.ConfigVerificationResult;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.VerifiableProcessor;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.gcp.AbstractGCPProcessor;
import org.apache.nifi.processors.gcp.ProxyAwareTransportFactory;
import org.apache.nifi.proxy.ProxyConfiguration;
import org.apache.nifi.proxy.ProxySpec;
import org.apache.nifi.util.StringUtils;

public abstract class AbstractBigQueryProcessor
extends AbstractGCPProcessor<BigQuery, BigQueryOptions>
implements VerifiableProcessor {
    static final int BUFFER_SIZE = 65536;
    private static final List<String> REQUIRED_PERMISSIONS = Collections.singletonList("bigquery.tables.updateData");
    public static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("FlowFiles are routed to this relationship after a successful Google BigQuery operation.").build();
    public static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("FlowFiles are routed to this relationship if the Google BigQuery operation fails.").build();
    public static final Set<Relationship> relationships = Collections.unmodifiableSet(new HashSet<Relationship>(Arrays.asList(REL_SUCCESS, REL_FAILURE)));
    public static final PropertyDescriptor DATASET = new PropertyDescriptor.Builder().name("bq.dataset").displayName("Dataset").description("BigQuery dataset name (Note - The dataset must exist in GCP)").required(true).defaultValue("${bq.dataset}").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_EL_VALIDATOR).build();
    public static final PropertyDescriptor TABLE_NAME = new PropertyDescriptor.Builder().name("bq.table.name").displayName("Table Name").description("BigQuery table name").required(true).defaultValue("${bq.table.name}").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_EL_VALIDATOR).build();
    public static final PropertyDescriptor IGNORE_UNKNOWN = new PropertyDescriptor.Builder().name("bq.load.ignore_unknown").displayName("Ignore Unknown Values").description("Sets whether BigQuery should allow extra values that are not represented in the table schema. If true, the extra values are ignored. If false, records with extra columns are treated as bad records, and if there are too many bad records, an invalid error is returned in the job result. By default unknown values are not allowed.").required(true).addValidator(StandardValidators.BOOLEAN_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).defaultValue("false").build();

    public Set<Relationship> getRelationships() {
        return relationships;
    }

    @Override
    public List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        ArrayList<PropertyDescriptor> descriptors = new ArrayList<PropertyDescriptor>();
        descriptors.addAll(super.getSupportedPropertyDescriptors());
        descriptors.add(DATASET);
        descriptors.add(TABLE_NAME);
        descriptors.add(IGNORE_UNKNOWN);
        return Collections.unmodifiableList(descriptors);
    }

    @Override
    protected BigQueryOptions getServiceOptions(ProcessContext context, GoogleCredentials credentials) {
        String projectId = context.getProperty(PROJECT_ID).evaluateAttributeExpressions().getValue();
        Integer retryCount = Integer.valueOf(context.getProperty(RETRY_COUNT).getValue());
        BigQueryOptions.Builder builder = BigQueryOptions.newBuilder();
        if (!StringUtils.isBlank((String)projectId)) {
            builder.setProjectId(projectId);
        }
        return ((BigQueryOptions.Builder)((BigQueryOptions.Builder)builder.setCredentials((Credentials)credentials)).setRetrySettings(RetrySettings.newBuilder().setMaxAttempts(retryCount.intValue()).build())).setTransportOptions(this.getTransportOptions(context)).build();
    }

    public List<ConfigVerificationResult> verify(ProcessContext context, ComponentLog verificationLogger, Map<String, String> attributes) {
        ArrayList<ConfigVerificationResult> results = new ArrayList<ConfigVerificationResult>(this.verifyCloudService(context, verificationLogger, attributes));
        BigQuery bigQuery = (BigQuery)this.getCloudService(context);
        if (bigQuery != null) {
            try {
                TableId tableId = this.getTableId(context, attributes);
                if (bigQuery.testIamPermissions(tableId, REQUIRED_PERMISSIONS, new BigQuery.IAMOption[0]).size() >= REQUIRED_PERMISSIONS.size()) {
                    results.add(new ConfigVerificationResult.Builder().verificationStepName("Test IAM Permissions").outcome(ConfigVerificationResult.Outcome.SUCCESSFUL).explanation(String.format("Verified BigQuery Table [%s] exists and the configured user has the correct permissions.", tableId)).build());
                } else {
                    results.add(new ConfigVerificationResult.Builder().verificationStepName("Test IAM Permissions").outcome(ConfigVerificationResult.Outcome.FAILED).explanation(String.format("The configured user does not have the correct permissions on BigQuery Table [%s].", tableId)).build());
                }
            }
            catch (BaseServiceException e) {
                verificationLogger.error("The configured user appears to have the correct permissions, but the following error was encountered", (Throwable)e);
                results.add(new ConfigVerificationResult.Builder().verificationStepName("Test IAM Permissions").outcome(ConfigVerificationResult.Outcome.FAILED).explanation(String.format("The configured user appears to have the correct permissions, but the following error was encountered: " + e.getMessage(), new Object[0])).build());
            }
        }
        return results;
    }

    protected final Collection<ValidationResult> customValidate(ValidationContext validationContext) {
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>(super.customValidate(validationContext));
        ProxyConfiguration.validateProxySpec((ValidationContext)validationContext, results, (ProxySpec[])ProxyAwareTransportFactory.PROXY_SPECS);
        boolean projectId = validationContext.getProperty(PROJECT_ID).isSet();
        if (!projectId) {
            results.add(new ValidationResult.Builder().subject(PROJECT_ID.getName()).valid(false).explanation("The Project ID must be set for this processor.").build());
        }
        this.customValidate(validationContext, results);
        return results;
    }

    protected void customValidate(ValidationContext validationContext, Collection<ValidationResult> results) {
    }

    protected TableId getTableId(ProcessContext context, Map<String, String> attributes) {
        String projectId = context.getProperty(PROJECT_ID).evaluateAttributeExpressions().getValue();
        String dataset = context.getProperty(DATASET).evaluateAttributeExpressions(attributes).getValue();
        String tableName = context.getProperty(TABLE_NAME).evaluateAttributeExpressions(attributes).getValue();
        TableId tableId = StringUtils.isEmpty((String)projectId) ? TableId.of((String)dataset, (String)tableName) : TableId.of((String)projectId, (String)dataset, (String)tableName);
        return tableId;
    }
}

