/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.gcp.pubsub;

import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.pubsub.v1.TopicAdminSettings;
import io.grpc.HttpConnectProxiedSocketAddress;
import io.grpc.ProxiedSocketAddress;
import io.grpc.ProxyDetector;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.SocketAddress;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processors.gcp.ProxyAwareTransportFactory;
import org.apache.nifi.processors.gcp.pubsub.AbstractGCPubSubProcessor;
import org.apache.nifi.proxy.ProxyConfiguration;
import org.apache.nifi.proxy.ProxySpec;

public abstract class AbstractGCPubSubWithProxyProcessor
extends AbstractGCPubSubProcessor {
    @Override
    public List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return Collections.unmodifiableList(Arrays.asList(PROJECT_ID, ProxyConfiguration.createProxyConfigPropertyDescriptor((boolean)true, (ProxySpec[])ProxyAwareTransportFactory.PROXY_SPECS), GCP_CREDENTIALS_PROVIDER_SERVICE));
    }

    protected TransportChannelProvider getTransportChannelProvider(ProcessContext context) {
        final ProxyConfiguration proxyConfiguration = ProxyConfiguration.getConfiguration((PropertyContext)context, () -> {
            String proxyHost = context.getProperty(PROXY_HOST).evaluateAttributeExpressions().getValue();
            Integer proxyPort = context.getProperty(PROXY_PORT).evaluateAttributeExpressions().asInteger();
            if (proxyHost != null && proxyPort != null && proxyPort > 0) {
                ProxyConfiguration componentProxyConfig = new ProxyConfiguration();
                String proxyUser = context.getProperty(HTTP_PROXY_USERNAME).evaluateAttributeExpressions().getValue();
                String proxyPassword = context.getProperty(HTTP_PROXY_PASSWORD).evaluateAttributeExpressions().getValue();
                componentProxyConfig.setProxyType(Proxy.Type.HTTP);
                componentProxyConfig.setProxyServerHost(proxyHost);
                componentProxyConfig.setProxyServerPort(proxyPort);
                componentProxyConfig.setProxyUserName(proxyUser);
                componentProxyConfig.setProxyUserPassword(proxyPassword);
                return componentProxyConfig;
            }
            return ProxyConfiguration.DIRECT_CONFIGURATION;
        });
        return TopicAdminSettings.defaultGrpcTransportProviderBuilder().setChannelConfigurator(managedChannelBuilder -> managedChannelBuilder.proxyDetector(new ProxyDetector(){

            @Nullable
            public ProxiedSocketAddress proxyFor(SocketAddress socketAddress) {
                if (Proxy.Type.HTTP.equals((Object)proxyConfiguration.getProxyType())) {
                    return HttpConnectProxiedSocketAddress.newBuilder().setUsername(proxyConfiguration.getProxyUserName()).setPassword(proxyConfiguration.getProxyUserPassword()).setProxyAddress((SocketAddress)new InetSocketAddress(proxyConfiguration.getProxyServerHost(), (int)proxyConfiguration.getProxyServerPort())).setTargetAddress((InetSocketAddress)socketAddress).build();
                }
                return null;
            }
        })).build();
    }
}

