/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.gcp.drive;

import java.util.ArrayList;
import java.util.HashMap;
import org.apache.nifi.processor.util.list.ListableEntity;
import org.apache.nifi.serialization.SimpleRecordSchema;
import org.apache.nifi.serialization.record.MapRecord;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.RecordField;
import org.apache.nifi.serialization.record.RecordFieldType;
import org.apache.nifi.serialization.record.RecordSchema;

public class GoogleDriveFileInfo
implements ListableEntity {
    public static final String ID = "drive.id";
    public static final String FILENAME = "filename";
    public static final String SIZE = "drive.size";
    public static final String TIMESTAMP = "drive.timestamp";
    public static final String MIME_TYPE = "mime.type";
    private static final RecordSchema SCHEMA;
    private final String id;
    private final String fileName;
    private final long size;
    private final long createdTime;
    private final long modifiedTime;
    private final String mimeType;

    public String getId() {
        return this.id;
    }

    public String getFileName() {
        return this.fileName;
    }

    public long getCreatedTime() {
        return this.createdTime;
    }

    public long getModifiedTime() {
        return this.modifiedTime;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public Record toRecord() {
        HashMap<String, Object> values = new HashMap<String, Object>();
        values.put(ID, this.getId());
        values.put(FILENAME, this.getName());
        values.put(SIZE, this.getSize());
        values.put(TIMESTAMP, this.getTimestamp());
        values.put(MIME_TYPE, this.getMimeType());
        return new MapRecord(SCHEMA, values);
    }

    public static RecordSchema getRecordSchema() {
        return SCHEMA;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GoogleDriveFileInfo other = (GoogleDriveFileInfo)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    private GoogleDriveFileInfo(Builder builder) {
        this.id = builder.id;
        this.fileName = builder.fileName;
        this.size = builder.size;
        this.createdTime = builder.createdTime;
        this.modifiedTime = builder.modifiedTime;
        this.mimeType = builder.mimeType;
    }

    public String getName() {
        return this.getFileName();
    }

    public String getIdentifier() {
        return this.getId();
    }

    public long getTimestamp() {
        long timestamp = Math.max(this.getCreatedTime(), this.getModifiedTime());
        return timestamp;
    }

    public long getSize() {
        return this.size;
    }

    static {
        ArrayList<RecordField> recordFields = new ArrayList<RecordField>();
        recordFields.add(new RecordField(ID, RecordFieldType.STRING.getDataType(), false));
        recordFields.add(new RecordField(FILENAME, RecordFieldType.STRING.getDataType(), false));
        recordFields.add(new RecordField(SIZE, RecordFieldType.LONG.getDataType(), false));
        recordFields.add(new RecordField(TIMESTAMP, RecordFieldType.LONG.getDataType(), false));
        recordFields.add(new RecordField(MIME_TYPE, RecordFieldType.STRING.getDataType()));
        SCHEMA = new SimpleRecordSchema(recordFields);
    }

    public static final class Builder {
        private String id;
        private String fileName;
        private long size;
        private long createdTime;
        private long modifiedTime;
        private String mimeType;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder fileName(String fileName) {
            this.fileName = fileName;
            return this;
        }

        public Builder size(long size) {
            this.size = size;
            return this;
        }

        public Builder createdTime(long createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public Builder modifiedTime(long modifiedTime) {
            this.modifiedTime = modifiedTime;
            return this;
        }

        public Builder mimeType(String mimeType) {
            this.mimeType = mimeType;
            return this;
        }

        public GoogleDriveFileInfo build() {
            return new GoogleDriveFileInfo(this);
        }
    }
}

