/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.gcp.credentials.factory;

import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.Validator;
import org.apache.nifi.components.resource.ResourceCardinality;
import org.apache.nifi.components.resource.ResourceType;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.processor.util.JsonValidator;
import org.apache.nifi.processor.util.StandardValidators;

public final class CredentialPropertyDescriptors {
    public static final PropertyDescriptor USE_APPLICATION_DEFAULT_CREDENTIALS = new PropertyDescriptor.Builder().name("application-default-credentials").displayName("Use Application Default Credentials").expressionLanguageSupported(ExpressionLanguageScope.NONE).required(false).addValidator(StandardValidators.BOOLEAN_VALIDATOR).sensitive(false).allowableValues(new String[]{"true", "false"}).defaultValue("false").description("If true, uses Google Application Default Credentials, which checks the GOOGLE_APPLICATION_CREDENTIALS environment variable for a filepath to a service account JSON key, the config generated by the gcloud sdk, the App Engine service account, and the Compute Engine service account.").build();
    public static final PropertyDescriptor USE_COMPUTE_ENGINE_CREDENTIALS = new PropertyDescriptor.Builder().name("compute-engine-credentials").displayName("Use Compute Engine Credentials").expressionLanguageSupported(ExpressionLanguageScope.NONE).required(false).addValidator(StandardValidators.BOOLEAN_VALIDATOR).sensitive(false).allowableValues(new String[]{"true", "false"}).defaultValue("false").description("If true, uses Google Compute Engine Credentials of the Compute Engine VM Instance which NiFi is running on.").build();
    public static final PropertyDescriptor SERVICE_ACCOUNT_JSON_FILE = new PropertyDescriptor.Builder().name("service-account-json-file").displayName("Service Account JSON File").expressionLanguageSupported(ExpressionLanguageScope.NONE).required(false).identifiesExternalResource(ResourceCardinality.SINGLE, ResourceType.FILE, new ResourceType[0]).description("Path to a file containing a Service Account key file in JSON format.").build();
    public static final PropertyDescriptor SERVICE_ACCOUNT_JSON = new PropertyDescriptor.Builder().name("service-account-json").displayName("Service Account JSON").expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).required(false).addValidator((Validator)JsonValidator.INSTANCE).description("The raw JSON containing a Service Account keyfile.").sensitive(true).build();

    private CredentialPropertyDescriptors() {
    }
}

