/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.nar;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.nifi.bundle.Bundle;
import org.apache.nifi.bundle.BundleCoordinate;
import org.apache.nifi.bundle.BundleDetails;
import org.apache.nifi.documentation.DocGenerator;
import org.apache.nifi.nar.ExtensionDiscoveringManager;
import org.apache.nifi.nar.ExtensionManager;
import org.apache.nifi.nar.ExtensionMapping;
import org.apache.nifi.nar.ExtensionUiLoader;
import org.apache.nifi.nar.NarClassLoaders;
import org.apache.nifi.nar.NarLoadResult;
import org.apache.nifi.nar.NarLoader;
import org.apache.nifi.nar.NarManifestEntry;
import org.apache.nifi.nar.NarUnpackMode;
import org.apache.nifi.nar.NarUnpacker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardNarLoader
implements NarLoader {
    private static Logger LOGGER = LoggerFactory.getLogger(StandardNarLoader.class);
    private final File extensionsWorkingDir;
    private final File docsWorkingDir;
    private final NarClassLoaders narClassLoaders;
    private final ExtensionDiscoveringManager extensionManager;
    private final ExtensionMapping extensionMapping;
    private final ExtensionUiLoader extensionUiLoader;
    private final NarUnpackMode narUnpackMode;
    private Set<BundleDetails> previouslySkippedBundles;

    public StandardNarLoader(File extensionsWorkingDir, File docsWorkingDir, NarClassLoaders narClassLoaders, ExtensionDiscoveringManager extensionManager, ExtensionMapping extensionMapping, ExtensionUiLoader extensionUiLoader, NarUnpackMode narUnpackMode) {
        this.extensionsWorkingDir = extensionsWorkingDir;
        this.docsWorkingDir = docsWorkingDir;
        this.narClassLoaders = narClassLoaders;
        this.extensionManager = extensionManager;
        this.extensionMapping = extensionMapping;
        this.extensionUiLoader = extensionUiLoader;
        this.narUnpackMode = narUnpackMode;
    }

    @Override
    public synchronized NarLoadResult load(Collection<File> narFiles) {
        LOGGER.info("Starting load process for {} NARs...", new Object[]{narFiles.size()});
        ArrayList<File> unpackedNars = new ArrayList<File>();
        for (File narFile : narFiles) {
            LOGGER.debug("Unpacking {}...", new Object[]{narFile.getName()});
            File unpackedNar = this.unpack(narFile);
            if (unpackedNar == null) continue;
            LOGGER.debug("Completed unpacking {}", new Object[]{narFile.getName()});
            unpackedNars.add(unpackedNar);
        }
        if (this.previouslySkippedBundles != null && !this.previouslySkippedBundles.isEmpty()) {
            LOGGER.info("Including {} previously skipped bundle(s)", new Object[]{this.previouslySkippedBundles.size()});
            this.previouslySkippedBundles.forEach(b -> unpackedNars.add(b.getWorkingDirectory()));
        }
        if (unpackedNars.isEmpty()) {
            LOGGER.info("No NARs were unpacked, nothing to do");
            return new NarLoadResult(Collections.emptySet(), Collections.emptySet());
        }
        LOGGER.info("Creating class loaders for {} NARs...", new Object[]{unpackedNars.size()});
        NarLoadResult narLoadResult = this.narClassLoaders.loadAdditionalNars(unpackedNars);
        Set loadedBundles = narLoadResult.getLoadedBundles();
        Set skippedBundles = narLoadResult.getSkippedBundles();
        LOGGER.info("Successfully created class loaders for {} NARs, {} were skipped", new Object[]{loadedBundles.size(), skippedBundles.size()});
        this.previouslySkippedBundles = new HashSet<BundleDetails>(skippedBundles);
        if (!loadedBundles.isEmpty()) {
            LOGGER.debug("Discovering extensions...");
            this.extensionManager.discoverExtensions(loadedBundles);
            for (Bundle bundle : loadedBundles) {
                BundleCoordinate bundleCoordinate = bundle.getBundleDetails().getCoordinate();
                Set extensionDefinitions = this.extensionManager.getTypes(bundleCoordinate);
                if (extensionDefinitions.isEmpty()) {
                    LOGGER.debug("No documentation to generate for {} because no extensions were found", new Object[]{bundleCoordinate.getCoordinate()});
                    continue;
                }
                LOGGER.debug("Generating documentation for {} extensions in {}", new Object[]{extensionDefinitions.size(), bundleCoordinate.getCoordinate()});
                DocGenerator.documentConfigurableComponent((Set)extensionDefinitions, (File)this.docsWorkingDir, (ExtensionManager)this.extensionManager);
            }
            LOGGER.debug("Loading custom UIs for extensions...");
            if (this.extensionUiLoader != null) {
                this.extensionUiLoader.loadExtensionUis(loadedBundles);
            }
        }
        LOGGER.info("Finished NAR loading process!");
        return narLoadResult;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private File unpack(File narFile) {
        try (JarFile nar = new JarFile(narFile);){
            Manifest manifest = nar.getManifest();
            Attributes attributes = manifest.getMainAttributes();
            String groupId = attributes.getValue(NarManifestEntry.NAR_GROUP.getManifestName());
            String narId = attributes.getValue(NarManifestEntry.NAR_ID.getManifestName());
            String version = attributes.getValue(NarManifestEntry.NAR_VERSION.getManifestName());
            if ("nifi-framework-nar".equals(narId)) {
                LOGGER.error("Found a framework NAR, will not auto-load {}", new Object[]{narFile.getAbsolutePath()});
                File file = null;
                return file;
            }
            if ("nifi-jetty-bundle".equals(narId)) {
                LOGGER.error("Found a Jetty NAR, will not auto-load {}", new Object[]{narFile.getAbsolutePath()});
                File file = null;
                return file;
            }
            BundleCoordinate coordinate = new BundleCoordinate(groupId, narId, version);
            Bundle bundle = this.extensionManager.getBundle(coordinate);
            if (bundle != null) {
                LOGGER.warn("Found existing bundle with coordinate {}, will not load {}", new Object[]{coordinate, narFile.getAbsolutePath()});
                File file = null;
                return file;
            }
            File unpackedExtension = NarUnpacker.unpackNar((File)narFile, (File)this.extensionsWorkingDir, (boolean)true, (NarUnpackMode)this.narUnpackMode);
            NarUnpacker.mapExtension((File)unpackedExtension, (BundleCoordinate)coordinate, (File)this.docsWorkingDir, (ExtensionMapping)this.extensionMapping);
            File file = unpackedExtension;
            return file;
        }
        catch (Exception e) {
            LOGGER.error("Error unpacking " + narFile.getAbsolutePath(), (Throwable)e);
            return null;
        }
    }
}

