/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.groups;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.nifi.connectable.Port;
import org.apache.nifi.groups.FlowFileGate;

public class SingleConcurrencyFlowFileGate
implements FlowFileGate {
    private final AtomicBoolean claimed = new AtomicBoolean(false);

    public boolean tryClaim(Port port) {
        boolean empty;
        boolean alreadyClaimed = this.claimed.getAndSet(true);
        if (alreadyClaimed) {
            return false;
        }
        boolean bl = empty = !port.getProcessGroup().isDataQueued();
        if (empty) {
            return true;
        }
        this.claimed.set(false);
        return false;
    }

    public void releaseClaim(Port port) {
        this.claimed.set(false);
    }
}

