/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.flow;

import java.util.Objects;
import org.apache.nifi.flow.VersionedProcessGroup;
import org.apache.nifi.registry.flow.VersionControlInformation;
import org.apache.nifi.registry.flow.VersionedFlowState;
import org.apache.nifi.registry.flow.VersionedFlowStatus;
import org.apache.nifi.web.api.dto.VersionControlInformationDTO;

public class StandardVersionControlInformation
implements VersionControlInformation {
    private final String registryIdentifier;
    private volatile String registryName;
    private final String bucketIdentifier;
    private volatile String bucketName;
    private final String flowIdentifier;
    private volatile String flowName;
    private volatile String flowDescription;
    private volatile String storageLocation;
    private final int version;
    private volatile VersionedProcessGroup flowSnapshot;
    private final VersionedFlowStatus status;

    public StandardVersionControlInformation(String registryId, String registryName, String bucketId, String flowId, int version, VersionedProcessGroup snapshot, VersionedFlowStatus status) {
        this.registryIdentifier = registryId;
        this.registryName = registryName;
        this.bucketIdentifier = bucketId;
        this.flowIdentifier = flowId;
        this.version = version;
        this.flowSnapshot = snapshot;
        this.status = status;
    }

    public String getRegistryIdentifier() {
        return this.registryIdentifier;
    }

    public String getRegistryName() {
        return this.registryName;
    }

    public void setRegistryName(String registryName) {
        this.registryName = registryName;
    }

    public String getBucketIdentifier() {
        return this.bucketIdentifier;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public String getFlowIdentifier() {
        return this.flowIdentifier;
    }

    public void setFlowName(String flowName) {
        this.flowName = flowName;
    }

    public String getFlowName() {
        return this.flowName;
    }

    public void setFlowDescription(String flowDescription) {
        this.flowDescription = flowDescription;
    }

    public String getFlowDescription() {
        return this.flowDescription;
    }

    public String getStorageLocation() {
        return this.storageLocation;
    }

    public void setStorageLocation(String storageLocation) {
        this.storageLocation = storageLocation;
    }

    public int getVersion() {
        return this.version;
    }

    public VersionedProcessGroup getFlowSnapshot() {
        return this.flowSnapshot;
    }

    public void setFlowSnapshot(VersionedProcessGroup flowSnapshot) {
        this.flowSnapshot = flowSnapshot;
    }

    public VersionedFlowStatus getStatus() {
        return this.status;
    }

    public static class Builder {
        private String registryIdentifier;
        private String registryName;
        private String bucketIdentifier;
        private String bucketName;
        private String flowIdentifier;
        private String flowName;
        private String flowDescription;
        private String storageLocation;
        private int version;
        private VersionedProcessGroup flowSnapshot;
        private VersionedFlowStatus status;

        public Builder registryId(String registryId) {
            this.registryIdentifier = registryId;
            return this;
        }

        public Builder registryName(String registryName) {
            this.registryName = registryName;
            return this;
        }

        public Builder bucketId(String bucketId) {
            this.bucketIdentifier = bucketId;
            return this;
        }

        public Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public Builder flowId(String flowId) {
            this.flowIdentifier = flowId;
            return this;
        }

        public Builder flowName(String flowName) {
            this.flowName = flowName;
            return this;
        }

        public Builder flowDescription(String flowDescription) {
            this.flowDescription = flowDescription;
            return this;
        }

        public Builder storageLocation(String storageLocation) {
            this.storageLocation = storageLocation;
            return this;
        }

        public Builder version(int version) {
            this.version = version;
            return this;
        }

        public Builder flowSnapshot(VersionedProcessGroup snapshot) {
            this.flowSnapshot = snapshot;
            return this;
        }

        public Builder status(VersionedFlowStatus status) {
            this.status = status;
            return this;
        }

        public static Builder fromDto(final VersionControlInformationDTO dto) {
            Builder builder = new Builder();
            builder.registryId(dto.getRegistryId()).registryName(dto.getRegistryName()).bucketId(dto.getBucketId()).bucketName(dto.getBucketName()).flowId(dto.getFlowId()).flowName(dto.getFlowName()).flowDescription(dto.getFlowDescription()).status(new VersionedFlowStatus(){

                public VersionedFlowState getState() {
                    return VersionedFlowState.valueOf((String)dto.getState());
                }

                public String getStateExplanation() {
                    return dto.getStateExplanation();
                }
            }).storageLocation(dto.getStorageLocation()).version(dto.getVersion());
            return builder;
        }

        public StandardVersionControlInformation build() {
            Objects.requireNonNull(this.registryIdentifier, "Registry ID must be specified");
            Objects.requireNonNull(this.bucketIdentifier, "Bucket ID must be specified");
            Objects.requireNonNull(this.flowIdentifier, "Flow ID must be specified");
            Objects.requireNonNull(Integer.valueOf(this.version), "Version must be specified");
            StandardVersionControlInformation svci = new StandardVersionControlInformation(this.registryIdentifier, this.registryName, this.bucketIdentifier, this.flowIdentifier, this.version, this.flowSnapshot, this.status);
            svci.setBucketName(this.bucketName);
            svci.setFlowName(this.flowName);
            svci.setFlowDescription(this.flowDescription);
            svci.setStorageLocation(this.storageLocation);
            return svci;
        }
    }
}

