/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.logging;

import org.apache.nifi.connectable.Connectable;
import org.apache.nifi.controller.ProcessorNode;
import org.apache.nifi.events.BulletinFactory;
import org.apache.nifi.logging.LogLevel;
import org.apache.nifi.logging.LogMessage;
import org.apache.nifi.logging.LogObserver;
import org.apache.nifi.reporting.BulletinRepository;
import org.apache.nifi.reporting.Severity;

public class ProcessorLogObserver
implements LogObserver {
    private static final String CATEGORY = "Log Message";
    private final BulletinRepository bulletinRepository;
    private final ProcessorNode processorNode;

    public ProcessorLogObserver(BulletinRepository bulletinRepository, ProcessorNode processorNode) {
        this.bulletinRepository = bulletinRepository;
        this.processorNode = processorNode;
    }

    public void onLogMessage(LogMessage message) {
        String bulletinLevel = message.getLogLevel() == LogLevel.WARN ? Severity.WARNING.name() : message.getLogLevel().toString();
        this.bulletinRepository.addBulletin(BulletinFactory.createBulletin((Connectable)this.processorNode, (String)CATEGORY, (String)bulletinLevel, (String)message.getMessage(), (String)message.getFlowFileUuid()));
    }

    public String getComponentDescription() {
        return this.processorNode.toString();
    }
}

