/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.coordination.http.endpoints;

import java.net.URI;
import java.util.HashMap;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.nifi.cluster.coordination.http.EndpointResponseMerger;
import org.apache.nifi.cluster.manager.ControllerServiceEntityMerger;
import org.apache.nifi.cluster.manager.NodeResponse;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.web.api.entity.ControllerServiceReferencingComponentEntity;
import org.apache.nifi.web.api.entity.ControllerServiceReferencingComponentsEntity;
import org.apache.nifi.web.api.entity.Entity;

public class ControllerServiceReferenceEndpointMerger
implements EndpointResponseMerger {
    public static final Pattern CONTROLLER_SERVICE_REFERENCES_URI_PATTERN = Pattern.compile("/nifi-api/controller-services/node/[a-f0-9\\-]{36}/references");

    @Override
    public boolean canHandle(URI uri, String method) {
        return ("GET".equalsIgnoreCase(method) || "PUT".equalsIgnoreCase(method)) && CONTROLLER_SERVICE_REFERENCES_URI_PATTERN.matcher(uri.getPath()).matches();
    }

    @Override
    public NodeResponse merge(URI uri, String method, Set<NodeResponse> successfulResponses, Set<NodeResponse> problematicResponses, NodeResponse clientResponse) {
        if (!this.canHandle(uri, method)) {
            throw new IllegalArgumentException("Cannot use Endpoint Mapper of type " + this.getClass().getSimpleName() + " to map responses for URI " + uri + ", HTTP Method " + method);
        }
        ControllerServiceReferencingComponentsEntity responseEntity = (ControllerServiceReferencingComponentsEntity)clientResponse.getClientResponse().readEntity(ControllerServiceReferencingComponentsEntity.class);
        Set referencingComponents = responseEntity.getControllerServiceReferencingComponents();
        HashMap<NodeIdentifier, Set<ControllerServiceReferencingComponentEntity>> resultsMap = new HashMap<NodeIdentifier, Set<ControllerServiceReferencingComponentEntity>>();
        for (NodeResponse nodeResponse : successfulResponses) {
            ControllerServiceReferencingComponentsEntity nodeResponseEntity = nodeResponse == clientResponse ? responseEntity : (ControllerServiceReferencingComponentsEntity)nodeResponse.getClientResponse().readEntity(ControllerServiceReferencingComponentsEntity.class);
            Set nodeReferencingComponents = nodeResponseEntity.getControllerServiceReferencingComponents();
            resultsMap.put(nodeResponse.getNodeId(), nodeReferencingComponents);
        }
        ControllerServiceEntityMerger.mergeControllerServiceReferences(referencingComponents, resultsMap);
        return new NodeResponse(clientResponse, (Entity)responseEntity);
    }
}

