/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.coordination.http.endpoints;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.parameter.ParameterSensitivity;
import org.apache.nifi.web.api.entity.ParameterGroupConfigurationEntity;
import org.apache.nifi.web.api.entity.ParameterProviderEntity;

public class ParameterProviderMerger {
    public static void merge(ParameterProviderEntity target, ParameterProviderEntity otherEntity) {
        Collection targetParameterGroupConfigurations = target.getComponent().getParameterGroupConfigurations();
        if (targetParameterGroupConfigurations != null && otherEntity.getComponent().getParameterGroupConfigurations() != null) {
            Iterator otherGroupIterator = otherEntity.getComponent().getParameterGroupConfigurations().iterator();
            for (ParameterGroupConfigurationEntity parameterGroupConfiguration : targetParameterGroupConfigurations) {
                Map targetParameterSensitivities;
                if (!otherGroupIterator.hasNext()) continue;
                ParameterGroupConfigurationEntity otherConfiguration = (ParameterGroupConfigurationEntity)otherGroupIterator.next();
                if (!StringUtils.equals((CharSequence)parameterGroupConfiguration.getGroupName(), (CharSequence)otherConfiguration.getGroupName()) || (targetParameterSensitivities = parameterGroupConfiguration.getParameterSensitivities()) == null) continue;
                if (otherConfiguration.getGroupName() != null) {
                    targetParameterSensitivities.keySet().retainAll(otherConfiguration.getParameterSensitivities().keySet());
                }
                parameterGroupConfiguration.setParameterSensitivities(new LinkedHashMap());
                targetParameterSensitivities.keySet().stream().sorted().forEach(paramName -> parameterGroupConfiguration.getParameterSensitivities().put(paramName, (ParameterSensitivity)targetParameterSensitivities.get(paramName)));
            }
        }
    }
}

