/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.firewall.impl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.net.util.SubnetUtils;
import org.apache.nifi.cluster.firewall.ClusterNodeFirewall;
import org.apache.nifi.logging.NiFiLog;
import org.apache.nifi.util.file.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileBasedClusterNodeFirewall
implements ClusterNodeFirewall {
    private final File config;
    private final File restoreDirectory;
    private final Collection<SubnetUtils.SubnetInfo> subnetInfos = new ArrayList<SubnetUtils.SubnetInfo>();
    private static final Logger logger = new NiFiLog(LoggerFactory.getLogger(FileBasedClusterNodeFirewall.class));

    public FileBasedClusterNodeFirewall(File config) throws IOException {
        this(config, null);
    }

    public FileBasedClusterNodeFirewall(File config, File restoreDirectory) throws IOException {
        if (config == null) {
            throw new IllegalArgumentException("Firewall configuration file may not be null.");
        }
        this.config = config;
        this.restoreDirectory = restoreDirectory;
        if (restoreDirectory != null) {
            try {
                this.syncWithRestoreDirectory();
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }
        if (!config.exists() && !config.createNewFile()) {
            throw new IOException("Firewall configuration file did not exist and could not be created: " + config.getAbsolutePath());
        }
        logger.info("Loading cluster firewall configuration.");
        this.parseConfig(config);
        logger.info("Cluster firewall configuration loaded.");
    }

    @Override
    public boolean isPermissible(String hostOrIp) {
        try {
            String ip;
            if (this.subnetInfos.isEmpty()) {
                return true;
            }
            try {
                ip = InetAddress.getByName(hostOrIp).getHostAddress();
            }
            catch (UnknownHostException uhe) {
                logger.warn("Blocking unknown host '{}'", (Object)hostOrIp, (Object)uhe);
                return false;
            }
            for (SubnetUtils.SubnetInfo subnetInfo : this.subnetInfos) {
                if (!subnetInfo.isInRange(ip)) continue;
                return true;
            }
            logger.debug("Blocking host '{}' because it does not match our allowed list.", (Object)hostOrIp);
            return false;
        }
        catch (IllegalArgumentException iae) {
            logger.debug("Blocking requested host, '{}', because it is malformed.", (Object)hostOrIp, (Object)iae);
            return false;
        }
    }

    private void syncWithRestoreDirectory() throws IOException {
        FileUtils.ensureDirectoryExistAndCanAccess((File)this.restoreDirectory);
        if (this.config.getParentFile().getAbsolutePath().equals(this.restoreDirectory.getAbsolutePath())) {
            throw new IllegalStateException(String.format("Cluster firewall configuration file '%s' cannot be in the restore directory '%s' ", this.config.getAbsolutePath(), this.restoreDirectory.getAbsolutePath()));
        }
        File restoreFile = new File(this.restoreDirectory, this.config.getName());
        FileUtils.syncWithRestore((File)this.config, (File)restoreFile, (Logger)logger);
    }

    private void parseConfig(File config) throws IOException {
        this.subnetInfos.clear();
        try (BufferedReader br = new BufferedReader(new FileReader(config));){
            String ipOrHostLine;
            int totalIpsAdded = 0;
            while ((ipOrHostLine = br.readLine()) != null) {
                Object ipCidr;
                if ((ipOrHostLine = ipOrHostLine.trim()).isEmpty() || ipOrHostLine.startsWith("#")) continue;
                if (ipOrHostLine.contains("#")) {
                    ipOrHostLine = ipOrHostLine.substring(0, ipOrHostLine.indexOf("#")).trim();
                }
                if (ipOrHostLine.contains("/")) {
                    ipCidr = ipOrHostLine;
                } else if (ipOrHostLine.contains("\\")) {
                    logger.warn("CIDR IP notation uses forward slashes '/'.  Replacing backslash '\\' with forward slash'/' for '{}'", (Object)ipOrHostLine);
                    ipCidr = ipOrHostLine.replace("\\", "/");
                } else {
                    try {
                        ipCidr = InetAddress.getByName(ipOrHostLine).getHostAddress();
                        if (!ipOrHostLine.equals(ipCidr)) {
                            logger.debug("Resolved host '{}' to ip '{}'", (Object)ipOrHostLine, ipCidr);
                        }
                        ipCidr = (String)ipCidr + "/32";
                        logger.debug("Adding CIDR to exact IP: '{}'", ipCidr);
                    }
                    catch (UnknownHostException uhe) {
                        logger.warn("Firewall is skipping unknown host address: '{}'", (Object)ipOrHostLine);
                        continue;
                    }
                }
                try {
                    logger.debug("Adding CIDR IP to firewall: '{}'", ipCidr);
                    SubnetUtils subnetUtils = new SubnetUtils((String)ipCidr);
                    subnetUtils.setInclusiveHostCount(true);
                    this.subnetInfos.add(subnetUtils.getInfo());
                    ++totalIpsAdded;
                }
                catch (IllegalArgumentException iae) {
                    logger.warn("Firewall is skipping invalid CIDR address: '{}'", (Object)ipOrHostLine);
                }
            }
            if (totalIpsAdded == 0) {
                logger.info("No IPs added to firewall.  Firewall will accept all requests.");
            } else {
                logger.info("Added {} IP(s) to firewall.  Only requests originating from the configured IPs will be accepted.", (Object)totalIpsAdded);
            }
        }
    }
}

