/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.coordination.http.replication.okhttp;

import java.net.SocketAddress;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Map;
import okhttp3.Call;

public class CallEventListener {
    private final Call call;
    private final Map<String, Timing> dnsTimings = new HashMap<String, Timing>();
    private final Map<String, Timing> establishConnectionTiming = new HashMap<String, Timing>();
    private long callStart;
    private long callEnd;
    private long responseBodyStart;
    private long responseBodyEnd;
    private long responseHeaderStart;
    private long responseHeaderEnd;
    private long requestHeaderStart;
    private long requestHeaderEnd;
    private long requestBodyStart;
    private long requestBodyEnd;
    private long secureConnectStart;
    private long secureConnectEnd;

    public CallEventListener(Call call) {
        this.call = call;
    }

    public void callStart() {
        this.callStart = System.nanoTime();
    }

    public void callEnd() {
        this.callEnd = System.nanoTime();
    }

    public void dnsStart(String domainName) {
        this.dnsTimings.computeIfAbsent(domainName, k -> new Timing(domainName)).start();
    }

    public void dnsEnd(String domainName) {
        this.dnsTimings.computeIfAbsent(domainName, k -> new Timing(domainName)).end();
    }

    public void responseBodyStart() {
        this.responseBodyStart = System.nanoTime();
    }

    public void responseBodyEnd() {
        this.responseBodyEnd = System.nanoTime();
    }

    public void responseHeaderStart() {
        this.responseHeaderStart = System.nanoTime();
    }

    public void responseHeaderEnd() {
        this.responseHeaderEnd = System.nanoTime();
    }

    public void requestHeaderStart() {
        this.requestHeaderStart = System.nanoTime();
    }

    public void requestHeaderEnd() {
        this.requestHeaderEnd = System.nanoTime();
    }

    public void requestBodyStart() {
        this.requestBodyStart = System.nanoTime();
    }

    public void requestBodyEnd() {
        this.requestBodyEnd = System.nanoTime();
    }

    public void connectStart(SocketAddress address) {
        this.establishConnectionTiming.computeIfAbsent(address.toString(), Timing::new).start();
    }

    public void connectionAcquired(SocketAddress address) {
        this.establishConnectionTiming.computeIfAbsent(address.toString(), Timing::new).end();
    }

    public void secureConnectStart() {
        this.secureConnectStart = System.nanoTime();
    }

    public void secureConnectEnd() {
        this.secureConnectEnd = System.nanoTime();
    }

    public Call getCall() {
        return this.call;
    }

    public String toString() {
        NumberFormat numberFormat = NumberFormat.getInstance();
        return "CallEventListener{url=" + this.call.request().url() + ", dnsTimings=" + this.dnsTimings.values() + ", establishConnectionTiming=" + this.establishConnectionTiming.values() + ", tlsInitialization=" + numberFormat.format(this.secureConnectEnd - this.secureConnectStart) + " nanos, writeRequestHeaders=" + numberFormat.format(this.requestHeaderEnd - this.requestHeaderStart) + " nanos, writeRequestBody=" + numberFormat.format(this.requestBodyEnd - this.requestBodyStart) + " nanos, readResponseHeaders=" + numberFormat.format(this.responseHeaderEnd - this.responseHeaderStart) + " nanos, readResponseBody=" + numberFormat.format(this.responseBodyEnd - this.responseBodyStart) + " nanos, callTime=" + numberFormat.format(this.callEnd - this.callStart) + " nanos}";
    }

    private static class Timing {
        private final String address;
        private long start;
        private long nanos;

        public Timing(String address) {
            this.address = address;
        }

        public String getAddress() {
            return this.address;
        }

        public void start() {
            this.start = System.nanoTime();
        }

        public void end() {
            if (this.start > 0L) {
                this.nanos += System.nanoTime() - this.start;
            }
        }

        public String toString() {
            return "{address=" + this.address + ", nanos=" + NumberFormat.getInstance().format(this.nanos) + "}";
        }
    }
}

