/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.coordination.http.endpoints;

import java.net.URI;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.nifi.cluster.coordination.http.endpoints.AbstractSingleEntityEndpoint;
import org.apache.nifi.cluster.manager.ComponentEntityStatusMerger;
import org.apache.nifi.cluster.manager.NodeResponse;
import org.apache.nifi.cluster.manager.StatusMerger;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.web.api.dto.status.NodeProcessGroupStatusSnapshotDTO;
import org.apache.nifi.web.api.dto.status.ProcessGroupStatusDTO;
import org.apache.nifi.web.api.entity.ProcessGroupStatusEntity;

public class GroupStatusEndpointMerger
extends AbstractSingleEntityEndpoint<ProcessGroupStatusEntity>
implements ComponentEntityStatusMerger<ProcessGroupStatusDTO> {
    public static final Pattern GROUP_STATUS_URI_PATTERN = Pattern.compile("/nifi-api/flow/process-groups/(?:(?:root)|(?:[a-f0-9\\-]{36}))/status");

    @Override
    public boolean canHandle(URI uri, String method) {
        return "GET".equalsIgnoreCase(method) && GROUP_STATUS_URI_PATTERN.matcher(uri.getPath()).matches();
    }

    @Override
    protected Class<ProcessGroupStatusEntity> getEntityClass() {
        return ProcessGroupStatusEntity.class;
    }

    @Override
    protected void mergeResponses(ProcessGroupStatusEntity clientEntity, Map<NodeIdentifier, ProcessGroupStatusEntity> entityMap, Set<NodeResponse> successfulResponses, Set<NodeResponse> problematicResponses) {
        ProcessGroupStatusDTO mergedProcessGroupStatus = clientEntity.getProcessGroupStatus();
        mergedProcessGroupStatus.setNodeSnapshots(new ArrayList());
        NodeIdentifier selectedNodeId = entityMap.entrySet().stream().filter(e -> e.getValue() == clientEntity).map(e -> (NodeIdentifier)e.getKey()).findFirst().orElse(null);
        NodeProcessGroupStatusSnapshotDTO selectedNodeSnapshot = new NodeProcessGroupStatusSnapshotDTO();
        selectedNodeSnapshot.setStatusSnapshot(mergedProcessGroupStatus.getAggregateSnapshot().clone());
        selectedNodeSnapshot.setAddress(selectedNodeId.getApiAddress());
        selectedNodeSnapshot.setApiPort(Integer.valueOf(selectedNodeId.getApiPort()));
        selectedNodeSnapshot.setNodeId(selectedNodeId.getId());
        mergedProcessGroupStatus.getNodeSnapshots().add(selectedNodeSnapshot);
        for (Map.Entry<NodeIdentifier, ProcessGroupStatusEntity> entry : entityMap.entrySet()) {
            NodeIdentifier nodeId = entry.getKey();
            ProcessGroupStatusEntity nodeProcessGroupStatusEntity = entry.getValue();
            ProcessGroupStatusDTO nodeProcessGroupStatus = nodeProcessGroupStatusEntity.getProcessGroupStatus();
            if (nodeProcessGroupStatus == mergedProcessGroupStatus) continue;
            this.mergeStatus(mergedProcessGroupStatus, (boolean)clientEntity.getCanRead(), nodeProcessGroupStatus, (boolean)nodeProcessGroupStatusEntity.getCanRead(), nodeId);
        }
    }

    @Override
    public void mergeStatus(ProcessGroupStatusDTO clientStatus, boolean clientStatusReadablePermission, ProcessGroupStatusDTO status, boolean statusReadablePermission, NodeIdentifier statusNodeIdentifier) {
        StatusMerger.merge(clientStatus, clientStatusReadablePermission, status, statusReadablePermission, statusNodeIdentifier.getId(), statusNodeIdentifier.getApiAddress(), (Integer)statusNodeIdentifier.getApiPort());
    }
}

