/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.manager;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.components.validation.ValidationStatus;
import org.apache.nifi.controller.service.ControllerServiceState;
import org.apache.nifi.controller.status.FlowFileAvailability;
import org.apache.nifi.controller.status.ProcessGroupStatus;
import org.apache.nifi.controller.status.RunStatus;
import org.apache.nifi.controller.status.TransmissionStatus;
import org.apache.nifi.registry.flow.VersionedFlowState;
import org.apache.nifi.util.FormatUtils;
import org.apache.nifi.web.api.dto.CounterDTO;
import org.apache.nifi.web.api.dto.CountersDTO;
import org.apache.nifi.web.api.dto.CountersSnapshotDTO;
import org.apache.nifi.web.api.dto.NodeCountersSnapshotDTO;
import org.apache.nifi.web.api.dto.NodeSystemDiagnosticsSnapshotDTO;
import org.apache.nifi.web.api.dto.SystemDiagnosticsDTO;
import org.apache.nifi.web.api.dto.SystemDiagnosticsSnapshotDTO;
import org.apache.nifi.web.api.dto.diagnostics.GCDiagnosticsSnapshotDTO;
import org.apache.nifi.web.api.dto.diagnostics.GarbageCollectionDiagnosticsDTO;
import org.apache.nifi.web.api.dto.diagnostics.JVMControllerDiagnosticsSnapshotDTO;
import org.apache.nifi.web.api.dto.diagnostics.JVMDiagnosticsSnapshotDTO;
import org.apache.nifi.web.api.dto.diagnostics.JVMFlowDiagnosticsSnapshotDTO;
import org.apache.nifi.web.api.dto.diagnostics.JVMSystemDiagnosticsSnapshotDTO;
import org.apache.nifi.web.api.dto.status.ConnectionStatusDTO;
import org.apache.nifi.web.api.dto.status.ConnectionStatusPredictionsSnapshotDTO;
import org.apache.nifi.web.api.dto.status.ConnectionStatusSnapshotDTO;
import org.apache.nifi.web.api.dto.status.ControllerServiceStatusDTO;
import org.apache.nifi.web.api.dto.status.ControllerStatusDTO;
import org.apache.nifi.web.api.dto.status.NodeConnectionStatusSnapshotDTO;
import org.apache.nifi.web.api.dto.status.NodePortStatusSnapshotDTO;
import org.apache.nifi.web.api.dto.status.NodeProcessGroupStatusSnapshotDTO;
import org.apache.nifi.web.api.dto.status.NodeProcessorStatusSnapshotDTO;
import org.apache.nifi.web.api.dto.status.NodeRemoteProcessGroupStatusSnapshotDTO;
import org.apache.nifi.web.api.dto.status.PortStatusDTO;
import org.apache.nifi.web.api.dto.status.PortStatusSnapshotDTO;
import org.apache.nifi.web.api.dto.status.ProcessGroupStatusDTO;
import org.apache.nifi.web.api.dto.status.ProcessGroupStatusSnapshotDTO;
import org.apache.nifi.web.api.dto.status.ProcessorStatusDTO;
import org.apache.nifi.web.api.dto.status.ProcessorStatusSnapshotDTO;
import org.apache.nifi.web.api.dto.status.RemoteProcessGroupStatusDTO;
import org.apache.nifi.web.api.dto.status.RemoteProcessGroupStatusSnapshotDTO;
import org.apache.nifi.web.api.dto.status.ReportingTaskStatusDTO;
import org.apache.nifi.web.api.entity.ConnectionStatusSnapshotEntity;
import org.apache.nifi.web.api.entity.PortStatusSnapshotEntity;
import org.apache.nifi.web.api.entity.ProcessGroupStatusSnapshotEntity;
import org.apache.nifi.web.api.entity.ProcessorStatusSnapshotEntity;
import org.apache.nifi.web.api.entity.RemoteProcessGroupStatusSnapshotEntity;

public class StatusMerger {
    private static final String ZERO_COUNT = "0";
    private static final String ZERO_BYTES = "0 bytes";
    private static final String ZERO_COUNT_AND_BYTES = "0 (0 bytes)";
    private static final String EMPTY_COUNT = "-";
    private static final String EMPTY_BYTES = "-";

    public static void merge(ControllerStatusDTO target, ControllerStatusDTO toMerge) {
        if (target == null || toMerge == null) {
            return;
        }
        target.setActiveThreadCount(Integer.valueOf(target.getActiveThreadCount() + toMerge.getActiveThreadCount()));
        target.setTerminatedThreadCount(Integer.valueOf(target.getTerminatedThreadCount() + toMerge.getTerminatedThreadCount()));
        target.setBytesQueued(Long.valueOf(target.getBytesQueued() + toMerge.getBytesQueued()));
        target.setFlowFilesQueued(Integer.valueOf(target.getFlowFilesQueued() + toMerge.getFlowFilesQueued()));
        StatusMerger.updatePrettyPrintedFields(target);
    }

    public static void updatePrettyPrintedFields(ControllerStatusDTO target) {
        target.setQueued(StatusMerger.prettyPrint(target.getFlowFilesQueued(), target.getBytesQueued()));
    }

    public static void merge(ProcessGroupStatusDTO target, boolean targetReadablePermission, ProcessGroupStatusDTO toMerge, boolean toMergeReadablePermission, String nodeId, String nodeAddress, Integer nodeApiPort) {
        if (toMerge == null) {
            return;
        }
        if (targetReadablePermission && !toMergeReadablePermission) {
            target.setId(toMerge.getId());
            target.setName(toMerge.getName());
        }
        StatusMerger.merge(target.getAggregateSnapshot(), targetReadablePermission, toMerge.getAggregateSnapshot(), toMergeReadablePermission);
        if (target.getNodeSnapshots() != null) {
            NodeProcessGroupStatusSnapshotDTO nodeSnapshot = new NodeProcessGroupStatusSnapshotDTO();
            nodeSnapshot.setStatusSnapshot(toMerge.getAggregateSnapshot());
            nodeSnapshot.setAddress(nodeAddress);
            nodeSnapshot.setApiPort(nodeApiPort);
            nodeSnapshot.setNodeId(nodeId);
            target.getNodeSnapshots().add(nodeSnapshot);
        }
    }

    public static void merge(ProcessGroupStatusSnapshotEntity target, ProcessGroupStatusSnapshotEntity toMerge) {
        if (target == null || toMerge == null) {
            return;
        }
        StatusMerger.merge(target.getProcessGroupStatusSnapshot(), (boolean)target.getCanRead(), toMerge.getProcessGroupStatusSnapshot(), (boolean)toMerge.getCanRead());
    }

    public static void merge(ProcessGroupStatusSnapshotDTO target, boolean targetReadablePermission, ProcessGroupStatusSnapshotDTO toMerge, boolean toMergeReadablePermission) {
        if (target == null || toMerge == null) {
            return;
        }
        if (targetReadablePermission && !toMergeReadablePermission) {
            target.setId(toMerge.getId());
            target.setName(toMerge.getName());
        }
        if (VersionedFlowState.SYNC_FAILURE.name().equals(toMerge.getVersionedFlowState())) {
            target.setVersionedFlowState(VersionedFlowState.SYNC_FAILURE.name());
        }
        target.setBytesIn(Long.valueOf(target.getBytesIn() + toMerge.getBytesIn()));
        target.setFlowFilesIn(Integer.valueOf(target.getFlowFilesIn() + toMerge.getFlowFilesIn()));
        target.setBytesQueued(Long.valueOf(target.getBytesQueued() + toMerge.getBytesQueued()));
        target.setFlowFilesQueued(Integer.valueOf(target.getFlowFilesQueued() + toMerge.getFlowFilesQueued()));
        target.setBytesRead(Long.valueOf(target.getBytesRead() + toMerge.getBytesRead()));
        target.setBytesWritten(Long.valueOf(target.getBytesWritten() + toMerge.getBytesWritten()));
        target.setBytesOut(Long.valueOf(target.getBytesOut() + toMerge.getBytesOut()));
        target.setFlowFilesOut(Integer.valueOf(target.getFlowFilesOut() + toMerge.getFlowFilesOut()));
        target.setBytesTransferred(Long.valueOf(target.getBytesTransferred() + toMerge.getBytesTransferred()));
        target.setFlowFilesTransferred(Integer.valueOf(target.getFlowFilesTransferred() + toMerge.getFlowFilesTransferred()));
        target.setBytesReceived(Long.valueOf(target.getBytesReceived() + toMerge.getBytesReceived()));
        target.setFlowFilesReceived(Integer.valueOf(target.getFlowFilesReceived() + toMerge.getFlowFilesReceived()));
        target.setBytesSent(Long.valueOf(target.getBytesSent() + toMerge.getBytesSent()));
        target.setFlowFilesSent(Integer.valueOf(target.getFlowFilesSent() + toMerge.getFlowFilesSent()));
        target.setActiveThreadCount(Integer.valueOf(target.getActiveThreadCount() + toMerge.getActiveThreadCount()));
        target.setTerminatedThreadCount(Integer.valueOf(target.getTerminatedThreadCount() + toMerge.getTerminatedThreadCount()));
        StatusMerger.updatePrettyPrintedFields(target);
        HashMap<String, ConnectionStatusSnapshotEntity> mergedConnectionMap = new HashMap<String, ConnectionStatusSnapshotEntity>();
        for (ConnectionStatusSnapshotEntity status : StatusMerger.replaceNull(target.getConnectionStatusSnapshots())) {
            mergedConnectionMap.put(status.getId(), status);
        }
        for (Object statusToMerge : StatusMerger.replaceNull(toMerge.getConnectionStatusSnapshots())) {
            ConnectionStatusSnapshotEntity merged = (ConnectionStatusSnapshotEntity)mergedConnectionMap.get(statusToMerge.getId());
            if (merged == null) {
                mergedConnectionMap.put(statusToMerge.getId(), statusToMerge.clone());
                continue;
            }
            StatusMerger.merge(merged, (ConnectionStatusSnapshotEntity)statusToMerge);
        }
        target.setConnectionStatusSnapshots(mergedConnectionMap.values());
        HashMap<String, ProcessorStatusSnapshotEntity> mergedProcessorMap = new HashMap<String, ProcessorStatusSnapshotEntity>();
        for (ProcessorStatusSnapshotEntity status : StatusMerger.replaceNull(target.getProcessorStatusSnapshots())) {
            mergedProcessorMap.put(status.getId(), status);
        }
        for (Object statusToMerge : StatusMerger.replaceNull(toMerge.getProcessorStatusSnapshots())) {
            ProcessorStatusSnapshotEntity merged = (ProcessorStatusSnapshotEntity)mergedProcessorMap.get(statusToMerge.getId());
            if (merged == null) {
                mergedProcessorMap.put(statusToMerge.getId(), statusToMerge.clone());
                continue;
            }
            StatusMerger.merge(merged, (ProcessorStatusSnapshotEntity)statusToMerge);
        }
        target.setProcessorStatusSnapshots(mergedProcessorMap.values());
        HashMap<String, PortStatusSnapshotEntity> mergedInputPortMap = new HashMap<String, PortStatusSnapshotEntity>();
        for (PortStatusSnapshotEntity status : StatusMerger.replaceNull(target.getInputPortStatusSnapshots())) {
            mergedInputPortMap.put(status.getId(), status);
        }
        for (Object statusToMerge : StatusMerger.replaceNull(toMerge.getInputPortStatusSnapshots())) {
            PortStatusSnapshotEntity merged = (PortStatusSnapshotEntity)mergedInputPortMap.get(statusToMerge.getId());
            if (merged == null) {
                mergedInputPortMap.put(statusToMerge.getId(), statusToMerge.clone());
                continue;
            }
            StatusMerger.merge(merged, (PortStatusSnapshotEntity)statusToMerge);
        }
        target.setInputPortStatusSnapshots(mergedInputPortMap.values());
        HashMap<String, PortStatusSnapshotEntity> mergedOutputPortMap = new HashMap<String, PortStatusSnapshotEntity>();
        for (PortStatusSnapshotEntity status : StatusMerger.replaceNull(target.getOutputPortStatusSnapshots())) {
            mergedOutputPortMap.put(status.getId(), status);
        }
        for (Object statusToMerge : StatusMerger.replaceNull(toMerge.getOutputPortStatusSnapshots())) {
            PortStatusSnapshotEntity merged = (PortStatusSnapshotEntity)mergedOutputPortMap.get(statusToMerge.getId());
            if (merged == null) {
                mergedOutputPortMap.put(statusToMerge.getId(), statusToMerge.clone());
                continue;
            }
            StatusMerger.merge(merged, (PortStatusSnapshotEntity)statusToMerge);
        }
        target.setOutputPortStatusSnapshots(mergedOutputPortMap.values());
        HashMap<String, ProcessGroupStatusSnapshotEntity> mergedGroupMap = new HashMap<String, ProcessGroupStatusSnapshotEntity>();
        for (ProcessGroupStatusSnapshotEntity status : StatusMerger.replaceNull(target.getProcessGroupStatusSnapshots())) {
            mergedGroupMap.put(status.getId(), status);
        }
        for (ProcessGroupStatusSnapshotEntity statusToMerge : StatusMerger.replaceNull(toMerge.getProcessGroupStatusSnapshots())) {
            ProcessGroupStatusSnapshotEntity merged = (ProcessGroupStatusSnapshotEntity)mergedGroupMap.get(statusToMerge.getId());
            if (merged == null) {
                mergedGroupMap.put(statusToMerge.getId(), statusToMerge.clone());
                continue;
            }
            StatusMerger.merge(merged, statusToMerge);
        }
        target.setOutputPortStatusSnapshots(mergedOutputPortMap.values());
        HashMap<String, RemoteProcessGroupStatusSnapshotEntity> mergedRemoteGroupMap = new HashMap<String, RemoteProcessGroupStatusSnapshotEntity>();
        for (RemoteProcessGroupStatusSnapshotEntity status : StatusMerger.replaceNull(target.getRemoteProcessGroupStatusSnapshots())) {
            mergedRemoteGroupMap.put(status.getId(), status);
        }
        for (RemoteProcessGroupStatusSnapshotEntity statusToMerge : StatusMerger.replaceNull(toMerge.getRemoteProcessGroupStatusSnapshots())) {
            RemoteProcessGroupStatusSnapshotEntity merged = (RemoteProcessGroupStatusSnapshotEntity)mergedRemoteGroupMap.get(statusToMerge.getId());
            if (merged == null) {
                mergedRemoteGroupMap.put(statusToMerge.getId(), statusToMerge.clone());
                continue;
            }
            StatusMerger.merge(merged, statusToMerge);
        }
        target.setRemoteProcessGroupStatusSnapshots(mergedRemoteGroupMap.values());
    }

    private static <T> Collection<T> replaceNull(Collection<T> collection) {
        return collection == null ? Collections.emptyList() : collection;
    }

    public static void updatePrettyPrintedFields(ProcessGroupStatusSnapshotDTO target) {
        target.setQueued(StatusMerger.prettyPrint(target.getFlowFilesQueued(), target.getBytesQueued()));
        target.setQueuedCount(StatusMerger.formatCount(target.getFlowFilesQueued()));
        target.setQueuedSize(StatusMerger.formatDataSize(target.getBytesQueued()));
        target.setInput(StatusMerger.prettyPrint(target.getFlowFilesIn(), target.getBytesIn()));
        target.setRead(StatusMerger.formatDataSize(target.getBytesRead()));
        target.setWritten(StatusMerger.formatDataSize(target.getBytesWritten()));
        target.setOutput(StatusMerger.prettyPrint(target.getFlowFilesOut(), target.getBytesOut()));
        target.setTransferred(StatusMerger.prettyPrint(target.getFlowFilesTransferred(), target.getBytesTransferred()));
        target.setReceived(StatusMerger.prettyPrint(target.getFlowFilesReceived(), target.getBytesReceived()));
        target.setSent(StatusMerger.prettyPrint(target.getFlowFilesSent(), target.getBytesSent()));
    }

    public static void merge(RemoteProcessGroupStatusDTO target, boolean targetReadablePermission, RemoteProcessGroupStatusDTO toMerge, boolean toMergeReadablePermission, String nodeId, String nodeAddress, Integer nodeApiPort) {
        if (targetReadablePermission && !toMergeReadablePermission) {
            target.setGroupId(toMerge.getGroupId());
            target.setId(toMerge.getId());
            target.setName(toMerge.getName());
            target.setTargetUri(toMerge.getTargetUri());
            target.setValidationStatus(toMerge.getValidationStatus());
        }
        StatusMerger.merge(target.getAggregateSnapshot(), targetReadablePermission, toMerge.getAggregateSnapshot(), toMergeReadablePermission);
        if (target.getNodeSnapshots() != null) {
            NodeRemoteProcessGroupStatusSnapshotDTO nodeSnapshot = new NodeRemoteProcessGroupStatusSnapshotDTO();
            nodeSnapshot.setStatusSnapshot(toMerge.getAggregateSnapshot());
            nodeSnapshot.setAddress(nodeAddress);
            nodeSnapshot.setApiPort(nodeApiPort);
            nodeSnapshot.setNodeId(nodeId);
            target.getNodeSnapshots().add(nodeSnapshot);
        }
    }

    public static void merge(PortStatusDTO target, boolean targetReadablePermission, PortStatusDTO toMerge, boolean toMergeReadablePermission, String nodeId, String nodeAddress, Integer nodeApiPort) {
        if (targetReadablePermission && !toMergeReadablePermission) {
            target.setGroupId(toMerge.getGroupId());
            target.setId(toMerge.getId());
            target.setName(toMerge.getName());
        }
        StatusMerger.merge(target.getAggregateSnapshot(), targetReadablePermission, toMerge.getAggregateSnapshot(), toMergeReadablePermission);
        target.setTransmitting(Boolean.valueOf(Boolean.TRUE.equals(target.isTransmitting()) || Boolean.TRUE.equals(toMerge.isTransmitting())));
        if (target.getNodeSnapshots() != null) {
            NodePortStatusSnapshotDTO nodeSnapshot = new NodePortStatusSnapshotDTO();
            nodeSnapshot.setStatusSnapshot(toMerge.getAggregateSnapshot());
            nodeSnapshot.setAddress(nodeAddress);
            nodeSnapshot.setApiPort(nodeApiPort);
            nodeSnapshot.setNodeId(nodeId);
            target.getNodeSnapshots().add(nodeSnapshot);
        }
    }

    public static void merge(ConnectionStatusDTO target, boolean targetReadablePermission, ConnectionStatusDTO toMerge, boolean toMergeReadablePermission, String nodeId, String nodeAddress, Integer nodeApiPort) {
        if (targetReadablePermission && !toMergeReadablePermission) {
            target.setGroupId(toMerge.getGroupId());
            target.setId(toMerge.getId());
            target.setName(toMerge.getName());
            target.setSourceId(toMerge.getSourceId());
            target.setSourceName(toMerge.getSourceName());
            target.setDestinationId(toMerge.getDestinationId());
            target.setDestinationName(toMerge.getDestinationName());
        }
        StatusMerger.merge(target.getAggregateSnapshot(), targetReadablePermission, toMerge.getAggregateSnapshot(), toMergeReadablePermission);
        if (target.getNodeSnapshots() != null) {
            NodeConnectionStatusSnapshotDTO nodeSnapshot = new NodeConnectionStatusSnapshotDTO();
            nodeSnapshot.setStatusSnapshot(toMerge.getAggregateSnapshot());
            nodeSnapshot.setAddress(nodeAddress);
            nodeSnapshot.setApiPort(nodeApiPort);
            nodeSnapshot.setNodeId(nodeId);
            target.getNodeSnapshots().add(nodeSnapshot);
        }
    }

    public static void merge(ProcessorStatusDTO target, boolean targetReadablePermission, ProcessorStatusDTO toMerge, boolean toMergeReadablePermission, String nodeId, String nodeAddress, Integer nodeApiPort) {
        if (targetReadablePermission && !toMergeReadablePermission) {
            target.setGroupId(toMerge.getGroupId());
            target.setId(toMerge.getId());
            target.setName(toMerge.getName());
            target.setType(toMerge.getType());
        }
        StatusMerger.merge(target.getAggregateSnapshot(), targetReadablePermission, toMerge.getAggregateSnapshot(), toMergeReadablePermission);
        if (target.getAggregateSnapshot() != null) {
            target.setRunStatus(target.getAggregateSnapshot().getRunStatus());
        }
        if (target.getNodeSnapshots() != null) {
            NodeProcessorStatusSnapshotDTO nodeSnapshot = new NodeProcessorStatusSnapshotDTO();
            nodeSnapshot.setStatusSnapshot(toMerge.getAggregateSnapshot());
            nodeSnapshot.setAddress(nodeAddress);
            nodeSnapshot.setApiPort(nodeApiPort);
            nodeSnapshot.setNodeId(nodeId);
            target.getNodeSnapshots().add(nodeSnapshot);
        }
    }

    public static void merge(ProcessorStatusSnapshotEntity target, ProcessorStatusSnapshotEntity toMerge) {
        if (target == null || toMerge == null) {
            return;
        }
        StatusMerger.merge(target.getProcessorStatusSnapshot(), (boolean)target.getCanRead(), toMerge.getProcessorStatusSnapshot(), (boolean)toMerge.getCanRead());
    }

    public static void merge(ProcessorStatusSnapshotDTO target, boolean targetReadablePermission, ProcessorStatusSnapshotDTO toMerge, boolean toMergeReadablePermission) {
        if (target == null || toMerge == null) {
            return;
        }
        if (targetReadablePermission && !toMergeReadablePermission) {
            target.setGroupId(toMerge.getGroupId());
            target.setId(toMerge.getId());
            target.setName(toMerge.getName());
            target.setType(toMerge.getType());
        }
        if (RunStatus.Validating.toString().equals(toMerge.getRunStatus())) {
            target.setRunStatus(RunStatus.Validating.toString());
        } else if (RunStatus.Invalid.toString().equals(toMerge.getRunStatus())) {
            target.setRunStatus(RunStatus.Invalid.toString());
        }
        target.setBytesRead(Long.valueOf(target.getBytesRead() + toMerge.getBytesRead()));
        target.setBytesWritten(Long.valueOf(target.getBytesWritten() + toMerge.getBytesWritten()));
        target.setFlowFilesIn(Integer.valueOf(target.getFlowFilesIn() + toMerge.getFlowFilesIn()));
        target.setBytesIn(Long.valueOf(target.getBytesIn() + toMerge.getBytesIn()));
        target.setFlowFilesOut(Integer.valueOf(target.getFlowFilesOut() + toMerge.getFlowFilesOut()));
        target.setBytesOut(Long.valueOf(target.getBytesOut() + toMerge.getBytesOut()));
        target.setTaskCount(Integer.valueOf(target.getTaskCount() + toMerge.getTaskCount()));
        target.setTasksDurationNanos(Long.valueOf(target.getTasksDurationNanos() + toMerge.getTasksDurationNanos()));
        target.setActiveThreadCount(Integer.valueOf(target.getActiveThreadCount() + toMerge.getActiveThreadCount()));
        target.setTerminatedThreadCount(Integer.valueOf(target.getTerminatedThreadCount() + toMerge.getTerminatedThreadCount()));
        StatusMerger.updatePrettyPrintedFields(target);
    }

    public static void updatePrettyPrintedFields(ProcessorStatusSnapshotDTO target) {
        target.setInput(StatusMerger.prettyPrint(target.getFlowFilesIn(), target.getBytesIn()));
        target.setRead(StatusMerger.formatDataSize(target.getBytesRead()));
        target.setWritten(StatusMerger.formatDataSize(target.getBytesWritten()));
        target.setOutput(StatusMerger.prettyPrint(target.getFlowFilesOut(), target.getBytesOut()));
        Integer taskCount = target.getTaskCount();
        String tasks = taskCount == null ? "-" : StatusMerger.formatCount(taskCount);
        target.setTasks(tasks);
        target.setTasksDuration(FormatUtils.formatHoursMinutesSeconds((long)target.getTasksDurationNanos(), (TimeUnit)TimeUnit.NANOSECONDS));
    }

    public static void merge(ConnectionStatusSnapshotEntity target, ConnectionStatusSnapshotEntity toMerge) {
        if (target == null || toMerge == null) {
            return;
        }
        StatusMerger.merge(target.getConnectionStatusSnapshot(), (boolean)target.getCanRead(), toMerge.getConnectionStatusSnapshot(), (boolean)toMerge.getCanRead());
    }

    public static void merge(ConnectionStatusSnapshotDTO target, boolean targetReadablePermission, ConnectionStatusSnapshotDTO toMerge, boolean toMergeReadablePermission) {
        if (target == null || toMerge == null) {
            return;
        }
        if (targetReadablePermission && !toMergeReadablePermission) {
            target.setGroupId(toMerge.getGroupId());
            target.setId(toMerge.getId());
            target.setName(toMerge.getName());
            target.setSourceId(toMerge.getSourceId());
            target.setSourceName(toMerge.getSourceName());
            target.setDestinationId(toMerge.getDestinationId());
            target.setDestinationName(toMerge.getDestinationName());
        }
        target.setFlowFilesIn(Integer.valueOf(target.getFlowFilesIn() + toMerge.getFlowFilesIn()));
        target.setBytesIn(Long.valueOf(target.getBytesIn() + toMerge.getBytesIn()));
        target.setFlowFilesOut(Integer.valueOf(target.getFlowFilesOut() + toMerge.getFlowFilesOut()));
        target.setBytesOut(Long.valueOf(target.getBytesOut() + toMerge.getBytesOut()));
        target.setFlowFilesQueued(Integer.valueOf(target.getFlowFilesQueued() + toMerge.getFlowFilesQueued()));
        target.setBytesQueued(Long.valueOf(target.getBytesQueued() + toMerge.getBytesQueued()));
        FlowFileAvailability targetFlowFileAvailability = target.getFlowFileAvailability() == null ? null : FlowFileAvailability.valueOf((String)target.getFlowFileAvailability());
        FlowFileAvailability toMergeFlowFileAvailability = toMerge.getFlowFileAvailability() == null ? null : FlowFileAvailability.valueOf((String)toMerge.getFlowFileAvailability());
        FlowFileAvailability mergedFlowFileAvailability = ProcessGroupStatus.mergeFlowFileAvailability((FlowFileAvailability)targetFlowFileAvailability, (FlowFileAvailability)toMergeFlowFileAvailability);
        target.setFlowFileAvailability(mergedFlowFileAvailability == null ? null : mergedFlowFileAvailability.name());
        if (target.getPercentUseBytes() == null) {
            target.setPercentUseBytes(toMerge.getPercentUseBytes());
        } else if (toMerge.getPercentUseBytes() != null) {
            target.setPercentUseBytes(Integer.valueOf(Math.max(target.getPercentUseBytes(), toMerge.getPercentUseBytes())));
        }
        if (target.getPercentUseCount() == null) {
            target.setPercentUseCount(toMerge.getPercentUseCount());
        } else if (toMerge.getPercentUseCount() != null) {
            target.setPercentUseCount(Integer.valueOf(Math.max(target.getPercentUseCount(), toMerge.getPercentUseCount())));
        }
        ConnectionStatusPredictionsSnapshotDTO targetPredictions = target.getPredictions();
        ConnectionStatusPredictionsSnapshotDTO toMergePredictions = toMerge.getPredictions();
        if (targetPredictions == null) {
            target.setPredictions(toMergePredictions);
        } else if (toMergePredictions != null) {
            if (targetPredictions.getPredictionIntervalSeconds() == null) {
                targetPredictions.setPredictionIntervalSeconds(toMergePredictions.getPredictionIntervalSeconds());
            }
            if (targetPredictions.getPredictedMillisUntilBytesBackpressure() == null) {
                targetPredictions.setPredictedMillisUntilBytesBackpressure(toMergePredictions.getPredictedMillisUntilBytesBackpressure());
            } else if (toMergePredictions.getPredictedMillisUntilBytesBackpressure() != null) {
                targetPredictions.setPredictedMillisUntilBytesBackpressure(Long.valueOf(StatusMerger.minNonNegative(targetPredictions.getPredictedMillisUntilBytesBackpressure(), toMergePredictions.getPredictedMillisUntilBytesBackpressure())));
            }
            if (targetPredictions.getPredictedMillisUntilCountBackpressure() == null) {
                targetPredictions.setPredictedMillisUntilCountBackpressure(toMergePredictions.getPredictedMillisUntilCountBackpressure());
            } else if (toMergePredictions.getPredictedMillisUntilCountBackpressure() != null) {
                targetPredictions.setPredictedMillisUntilCountBackpressure(Long.valueOf(StatusMerger.minNonNegative(targetPredictions.getPredictedMillisUntilCountBackpressure(), toMergePredictions.getPredictedMillisUntilCountBackpressure())));
            }
            if (targetPredictions.getPredictedPercentBytes() == null) {
                targetPredictions.setPredictedPercentBytes(toMergePredictions.getPredictedPercentBytes());
            } else if (toMerge.getPercentUseBytes() != null) {
                targetPredictions.setPredictedPercentBytes(Integer.valueOf(Math.max(targetPredictions.getPredictedPercentBytes(), toMergePredictions.getPredictedPercentBytes())));
            }
            if (targetPredictions.getPredictedPercentCount() == null) {
                targetPredictions.setPredictedPercentCount(toMergePredictions.getPredictedPercentCount());
            } else if (toMergePredictions.getPredictedPercentCount() != null) {
                targetPredictions.setPredictedPercentCount(Integer.valueOf(Math.max(targetPredictions.getPredictedPercentCount(), toMergePredictions.getPredictedPercentCount())));
            }
        }
        StatusMerger.updatePrettyPrintedFields(target);
    }

    private static long minNonNegative(long a, long b) {
        if (a < 0L) {
            return b;
        }
        if (b < 0L) {
            return a;
        }
        return Math.min(a, b);
    }

    public static void updatePrettyPrintedFields(ConnectionStatusSnapshotDTO target) {
        target.setQueued(StatusMerger.prettyPrint(target.getFlowFilesQueued(), target.getBytesQueued()));
        target.setQueuedCount(StatusMerger.formatCount(target.getFlowFilesQueued()));
        target.setQueuedSize(StatusMerger.formatDataSize(target.getBytesQueued()));
        target.setInput(StatusMerger.prettyPrint(target.getFlowFilesIn(), target.getBytesIn()));
        target.setOutput(StatusMerger.prettyPrint(target.getFlowFilesOut(), target.getBytesOut()));
    }

    public static void merge(RemoteProcessGroupStatusSnapshotEntity target, RemoteProcessGroupStatusSnapshotEntity toMerge) {
        if (target == null || toMerge == null) {
            return;
        }
        StatusMerger.merge(target.getRemoteProcessGroupStatusSnapshot(), (boolean)target.getCanRead(), toMerge.getRemoteProcessGroupStatusSnapshot(), (boolean)toMerge.getCanRead());
    }

    public static void merge(RemoteProcessGroupStatusSnapshotDTO target, boolean targetReadablePermission, RemoteProcessGroupStatusSnapshotDTO toMerge, boolean toMergeReadablePermission) {
        String transmittingValue;
        if (target == null || toMerge == null) {
            return;
        }
        if (targetReadablePermission && !toMergeReadablePermission) {
            target.setGroupId(toMerge.getGroupId());
            target.setId(toMerge.getId());
            target.setName(toMerge.getName());
            target.setTargetUri(toMerge.getTargetUri());
        }
        if ((transmittingValue = TransmissionStatus.Transmitting.name()).equals(target.getTransmissionStatus()) || transmittingValue.equals(toMerge.getTransmissionStatus())) {
            target.setTransmissionStatus(transmittingValue);
        }
        target.setActiveThreadCount(Integer.valueOf(target.getActiveThreadCount() + toMerge.getActiveThreadCount()));
        target.setFlowFilesSent(Integer.valueOf(target.getFlowFilesSent() + toMerge.getFlowFilesSent()));
        target.setBytesSent(Long.valueOf(target.getBytesSent() + toMerge.getBytesSent()));
        target.setFlowFilesReceived(Integer.valueOf(target.getFlowFilesReceived() + toMerge.getFlowFilesReceived()));
        target.setBytesReceived(Long.valueOf(target.getBytesReceived() + toMerge.getBytesReceived()));
        StatusMerger.updatePrettyPrintedFields(target);
    }

    public static void updatePrettyPrintedFields(RemoteProcessGroupStatusSnapshotDTO target) {
        target.setReceived(StatusMerger.prettyPrint(target.getFlowFilesReceived(), target.getBytesReceived()));
        target.setSent(StatusMerger.prettyPrint(target.getFlowFilesSent(), target.getBytesSent()));
    }

    public static void merge(PortStatusSnapshotEntity target, PortStatusSnapshotEntity toMerge) {
        if (target == null || toMerge == null) {
            return;
        }
        StatusMerger.merge(target.getPortStatusSnapshot(), (boolean)target.getCanRead(), toMerge.getPortStatusSnapshot(), (boolean)toMerge.getCanRead());
    }

    public static void merge(PortStatusSnapshotDTO target, boolean targetReadablePermission, PortStatusSnapshotDTO toMerge, boolean toMergeReadablePermission) {
        if (target == null || toMerge == null) {
            return;
        }
        if (targetReadablePermission && !toMergeReadablePermission) {
            target.setGroupId(toMerge.getGroupId());
            target.setId(toMerge.getId());
            target.setName(toMerge.getName());
        }
        target.setActiveThreadCount(Integer.valueOf(target.getActiveThreadCount() + toMerge.getActiveThreadCount()));
        target.setFlowFilesIn(Integer.valueOf(target.getFlowFilesIn() + toMerge.getFlowFilesIn()));
        target.setBytesIn(Long.valueOf(target.getBytesIn() + toMerge.getBytesIn()));
        target.setFlowFilesOut(Integer.valueOf(target.getFlowFilesOut() + toMerge.getFlowFilesOut()));
        target.setBytesOut(Long.valueOf(target.getBytesOut() + toMerge.getBytesOut()));
        target.setTransmitting(Boolean.valueOf(Boolean.TRUE.equals(target.isTransmitting()) || Boolean.TRUE.equals(toMerge.isTransmitting())));
        if (RunStatus.Invalid.toString().equals(toMerge.getRunStatus())) {
            target.setRunStatus(RunStatus.Invalid.toString());
        }
        StatusMerger.updatePrettyPrintedFields(target);
    }

    public static void updatePrettyPrintedFields(PortStatusSnapshotDTO target) {
        target.setInput(StatusMerger.prettyPrint(target.getFlowFilesIn(), target.getBytesIn()));
        target.setOutput(StatusMerger.prettyPrint(target.getFlowFilesOut(), target.getBytesOut()));
    }

    public static void merge(SystemDiagnosticsDTO target, SystemDiagnosticsDTO toMerge, String nodeId, String nodeAddress, Integer nodeApiPort) {
        StatusMerger.merge(target.getAggregateSnapshot(), toMerge.getAggregateSnapshot());
        ArrayList<NodeSystemDiagnosticsSnapshotDTO> nodeSnapshots = target.getNodeSnapshots();
        if (nodeSnapshots == null) {
            nodeSnapshots = new ArrayList<NodeSystemDiagnosticsSnapshotDTO>();
        }
        NodeSystemDiagnosticsSnapshotDTO nodeSnapshot = new NodeSystemDiagnosticsSnapshotDTO();
        nodeSnapshot.setAddress(nodeAddress);
        nodeSnapshot.setApiPort(nodeApiPort);
        nodeSnapshot.setNodeId(nodeId);
        nodeSnapshot.setSnapshot(toMerge.getAggregateSnapshot());
        nodeSnapshots.add(nodeSnapshot);
        target.setNodeSnapshots(nodeSnapshots);
    }

    public static void merge(SystemDiagnosticsSnapshotDTO target, SystemDiagnosticsSnapshotDTO toMerge) {
        if (target == null || toMerge == null) {
            return;
        }
        target.setAvailableProcessors(Integer.valueOf(target.getAvailableProcessors() + toMerge.getAvailableProcessors()));
        target.setDaemonThreads(Integer.valueOf(target.getDaemonThreads() + toMerge.getDaemonThreads()));
        target.setFreeHeapBytes(Long.valueOf(target.getFreeHeapBytes() + toMerge.getFreeHeapBytes()));
        target.setFreeNonHeapBytes(Long.valueOf(target.getFreeNonHeapBytes() + toMerge.getFreeNonHeapBytes()));
        target.setMaxHeapBytes(Long.valueOf(target.getMaxHeapBytes() + toMerge.getMaxHeapBytes()));
        target.setMaxNonHeapBytes(Long.valueOf(target.getMaxNonHeapBytes() + toMerge.getMaxNonHeapBytes()));
        double systemLoad = target.getProcessorLoadAverage();
        double toMergeSystemLoad = toMerge.getProcessorLoadAverage();
        if (systemLoad >= 0.0 && toMergeSystemLoad >= 0.0) {
            systemLoad += toMergeSystemLoad;
        } else if (systemLoad < 0.0 && toMergeSystemLoad >= 0.0) {
            systemLoad = toMergeSystemLoad;
        }
        target.setProcessorLoadAverage(Double.valueOf(systemLoad));
        target.setTotalHeapBytes(Long.valueOf(target.getTotalHeapBytes() + toMerge.getTotalHeapBytes()));
        target.setTotalNonHeapBytes(Long.valueOf(target.getTotalNonHeapBytes() + toMerge.getTotalNonHeapBytes()));
        target.setTotalThreads(Integer.valueOf(target.getTotalThreads() + toMerge.getTotalThreads()));
        target.setUsedHeapBytes(Long.valueOf(target.getUsedHeapBytes() + toMerge.getUsedHeapBytes()));
        target.setUsedNonHeapBytes(Long.valueOf(target.getUsedNonHeapBytes() + toMerge.getUsedNonHeapBytes()));
        StatusMerger.merge(target.getContentRepositoryStorageUsage(), toMerge.getContentRepositoryStorageUsage());
        StatusMerger.merge(target.getProvenanceRepositoryStorageUsage(), toMerge.getProvenanceRepositoryStorageUsage());
        StatusMerger.merge(target.getFlowFileRepositoryStorageUsage(), toMerge.getFlowFileRepositoryStorageUsage());
        StatusMerger.mergeGarbageCollection(target.getGarbageCollection(), toMerge.getGarbageCollection());
        StatusMerger.updatePrettyPrintedFields(target);
    }

    public static void merge(JVMDiagnosticsSnapshotDTO target, JVMDiagnosticsSnapshotDTO toMerge, long numMillis) {
        if (target == null || toMerge == null) {
            return;
        }
        if (toMerge.getControllerDiagnostics() == null) {
            target.setControllerDiagnostics(null);
        } else {
            StatusMerger.merge(target.getControllerDiagnostics(), toMerge.getControllerDiagnostics());
        }
        if (toMerge.getFlowDiagnosticsDto() == null) {
            target.setFlowDiagnosticsDto(null);
        } else {
            StatusMerger.merge(target.getFlowDiagnosticsDto(), toMerge.getFlowDiagnosticsDto());
        }
        if (toMerge.getSystemDiagnosticsDto() == null) {
            target.setSystemDiagnosticsDto(null);
        } else {
            StatusMerger.merge(target.getSystemDiagnosticsDto(), toMerge.getSystemDiagnosticsDto(), numMillis);
        }
    }

    private static void merge(JVMControllerDiagnosticsSnapshotDTO target, JVMControllerDiagnosticsSnapshotDTO toMerge) {
        if (toMerge == null || target == null) {
            return;
        }
        target.setMaxEventDrivenThreads(StatusMerger.add(target.getMaxEventDrivenThreads(), toMerge.getMaxEventDrivenThreads()));
        target.setMaxTimerDrivenThreads(StatusMerger.add(target.getMaxTimerDrivenThreads(), toMerge.getMaxTimerDrivenThreads()));
        target.setClusterCoordinator(null);
        target.setPrimaryNode(null);
    }

    private static void merge(JVMFlowDiagnosticsSnapshotDTO target, JVMFlowDiagnosticsSnapshotDTO toMerge) {
        if (toMerge == null || target == null) {
            return;
        }
        target.setActiveEventDrivenThreads(StatusMerger.add(target.getActiveEventDrivenThreads(), toMerge.getActiveEventDrivenThreads()));
        target.setActiveTimerDrivenThreads(StatusMerger.add(target.getActiveTimerDrivenThreads(), toMerge.getActiveTimerDrivenThreads()));
        target.setBundlesLoaded(null);
        target.setUptime(null);
        if (!Objects.equals(target.getTimeZone(), toMerge.getTimeZone())) {
            target.setTimeZone(null);
        }
    }

    private static void merge(JVMSystemDiagnosticsSnapshotDTO target, JVMSystemDiagnosticsSnapshotDTO toMerge, long numMillis) {
        if (toMerge == null || target == null) {
            return;
        }
        target.setCpuCores(StatusMerger.add(target.getCpuCores(), toMerge.getCpuCores()));
        target.setCpuLoadAverage(StatusMerger.add(target.getCpuLoadAverage(), toMerge.getCpuLoadAverage()));
        target.setOpenFileDescriptors(StatusMerger.add(target.getOpenFileDescriptors(), toMerge.getOpenFileDescriptors()));
        target.setMaxOpenFileDescriptors(StatusMerger.add(target.getMaxOpenFileDescriptors(), toMerge.getMaxOpenFileDescriptors()));
        target.setPhysicalMemoryBytes(StatusMerger.add(target.getPhysicalMemoryBytes(), toMerge.getPhysicalMemoryBytes()));
        target.setPhysicalMemory(FormatUtils.formatDataSize((double)target.getPhysicalMemoryBytes().longValue()));
        target.setContentRepositoryStorageUsage(null);
        target.setFlowFileRepositoryStorageUsage(null);
        target.setProvenanceRepositoryStorageUsage(null);
        target.setMaxHeapBytes(StatusMerger.add(target.getMaxHeapBytes(), toMerge.getMaxHeapBytes()));
        target.setMaxHeap(FormatUtils.formatDataSize((double)target.getMaxHeapBytes().longValue()));
        List<GarbageCollectionDiagnosticsDTO> mergedGcDiagnosticsDtos = StatusMerger.mergeGarbageCollectionDiagnostics(target.getGarbageCollectionDiagnostics(), toMerge.getGarbageCollectionDiagnostics(), numMillis);
        target.setGarbageCollectionDiagnostics(mergedGcDiagnosticsDtos);
    }

    private static List<GarbageCollectionDiagnosticsDTO> mergeGarbageCollectionDiagnostics(List<GarbageCollectionDiagnosticsDTO> target, List<GarbageCollectionDiagnosticsDTO> toMerge, long numMillis) {
        HashMap<String, Map<Date, GCDiagnosticsSnapshotDTO>> metricsByMemoryMgr = new HashMap<String, Map<Date, GCDiagnosticsSnapshotDTO>>();
        StatusMerger.merge(target, metricsByMemoryMgr, numMillis);
        StatusMerger.merge(toMerge, metricsByMemoryMgr, numMillis);
        ArrayList<GarbageCollectionDiagnosticsDTO> gcDiagnosticsDtos = new ArrayList<GarbageCollectionDiagnosticsDTO>();
        for (Map.Entry entry : metricsByMemoryMgr.entrySet()) {
            String memoryManagerName = (String)entry.getKey();
            Map snapshotMap = (Map)entry.getValue();
            GarbageCollectionDiagnosticsDTO gcDiagnosticsDto = new GarbageCollectionDiagnosticsDTO();
            gcDiagnosticsDto.setMemoryManagerName(memoryManagerName);
            ArrayList gcDiagnosticsSnapshots = new ArrayList(snapshotMap.values());
            gcDiagnosticsSnapshots.sort(Comparator.comparing(GCDiagnosticsSnapshotDTO::getTimestamp).reversed());
            gcDiagnosticsDto.setSnapshots(gcDiagnosticsSnapshots);
            gcDiagnosticsDtos.add(gcDiagnosticsDto);
        }
        return gcDiagnosticsDtos;
    }

    private static void merge(List<GarbageCollectionDiagnosticsDTO> toMerge, Map<String, Map<Date, GCDiagnosticsSnapshotDTO>> metricsByMemoryMgr, long numMillis) {
        for (GarbageCollectionDiagnosticsDTO gcDiagnostics : toMerge) {
            String memoryManagerName = gcDiagnostics.getMemoryManagerName();
            Map metricsByDate = metricsByMemoryMgr.computeIfAbsent(memoryManagerName, key -> new HashMap());
            for (GCDiagnosticsSnapshotDTO snapshot : gcDiagnostics.getSnapshots()) {
                long timestamp = snapshot.getTimestamp().getTime();
                Date normalized = new Date(timestamp - timestamp % numMillis);
                GCDiagnosticsSnapshotDTO aggregate = metricsByDate.computeIfAbsent(normalized, key -> new GCDiagnosticsSnapshotDTO());
                aggregate.setCollectionCount(StatusMerger.add(aggregate.getCollectionCount(), snapshot.getCollectionCount()));
                aggregate.setCollectionMillis(StatusMerger.add(aggregate.getCollectionMillis(), snapshot.getCollectionMillis()));
                aggregate.setTimestamp(normalized);
            }
        }
    }

    private static Integer add(Integer a, Integer b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        return a + b;
    }

    private static Double add(Double a, Double b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        return a + b;
    }

    private static Long add(Long a, Long b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        return a + b;
    }

    public static void updatePrettyPrintedFields(SystemDiagnosticsSnapshotDTO target) {
        target.setMaxHeap(FormatUtils.formatDataSize((double)target.getMaxHeapBytes().longValue()));
        target.setTotalHeap(FormatUtils.formatDataSize((double)target.getTotalHeapBytes().longValue()));
        target.setUsedHeap(FormatUtils.formatDataSize((double)target.getUsedHeapBytes().longValue()));
        target.setFreeHeap(FormatUtils.formatDataSize((double)target.getFreeHeapBytes().longValue()));
        if (target.getMaxHeapBytes() != -1L) {
            target.setHeapUtilization(FormatUtils.formatUtilization((double)StatusMerger.getUtilization(target.getUsedHeapBytes().longValue(), target.getMaxHeapBytes().longValue())));
        }
        target.setMaxNonHeap(FormatUtils.formatDataSize((double)target.getMaxNonHeapBytes().longValue()));
        target.setTotalNonHeap(FormatUtils.formatDataSize((double)target.getTotalNonHeapBytes().longValue()));
        target.setUsedNonHeap(FormatUtils.formatDataSize((double)target.getUsedNonHeapBytes().longValue()));
        target.setFreeNonHeap(FormatUtils.formatDataSize((double)target.getFreeNonHeapBytes().longValue()));
        if (target.getMaxNonHeapBytes() != -1L) {
            target.setNonHeapUtilization(FormatUtils.formatUtilization((double)StatusMerger.getUtilization(target.getUsedNonHeapBytes().longValue(), target.getMaxNonHeapBytes().longValue())));
        }
    }

    public static void merge(Set<SystemDiagnosticsSnapshotDTO.StorageUsageDTO> targetSet, Set<SystemDiagnosticsSnapshotDTO.StorageUsageDTO> toMerge) {
        HashMap<String, SystemDiagnosticsSnapshotDTO.StorageUsageDTO> storageById = new HashMap<String, SystemDiagnosticsSnapshotDTO.StorageUsageDTO>();
        for (SystemDiagnosticsSnapshotDTO.StorageUsageDTO targetUsage : targetSet) {
            storageById.put(targetUsage.getIdentifier(), targetUsage);
        }
        for (SystemDiagnosticsSnapshotDTO.StorageUsageDTO usageToMerge : toMerge) {
            SystemDiagnosticsSnapshotDTO.StorageUsageDTO targetUsage = (SystemDiagnosticsSnapshotDTO.StorageUsageDTO)storageById.get(usageToMerge.getIdentifier());
            if (targetUsage == null) {
                storageById.put(usageToMerge.getIdentifier(), usageToMerge);
                continue;
            }
            StatusMerger.merge(targetUsage, usageToMerge);
        }
        targetSet.clear();
        targetSet.addAll(storageById.values());
    }

    public static void merge(SystemDiagnosticsSnapshotDTO.StorageUsageDTO target, SystemDiagnosticsSnapshotDTO.StorageUsageDTO toMerge) {
        target.setFreeSpaceBytes(Long.valueOf(target.getFreeSpaceBytes() + toMerge.getFreeSpaceBytes()));
        target.setTotalSpaceBytes(Long.valueOf(target.getTotalSpaceBytes() + toMerge.getTotalSpaceBytes()));
        target.setUsedSpaceBytes(Long.valueOf(target.getUsedSpaceBytes() + toMerge.getUsedSpaceBytes()));
        StatusMerger.updatePrettyPrintedFields(target);
    }

    public static void updatePrettyPrintedFields(SystemDiagnosticsSnapshotDTO.StorageUsageDTO target) {
        target.setFreeSpace(FormatUtils.formatDataSize((double)target.getFreeSpaceBytes().longValue()));
        target.setTotalSpace(FormatUtils.formatDataSize((double)target.getTotalSpaceBytes().longValue()));
        target.setUsedSpace(FormatUtils.formatDataSize((double)target.getUsedSpaceBytes().longValue()));
        if (target.getTotalSpaceBytes() != -1L) {
            target.setUtilization(FormatUtils.formatUtilization((double)StatusMerger.getUtilization(target.getUsedSpaceBytes().longValue(), target.getTotalSpaceBytes().longValue())));
        }
    }

    public static void mergeGarbageCollection(Set<SystemDiagnosticsSnapshotDTO.GarbageCollectionDTO> targetSet, Set<SystemDiagnosticsSnapshotDTO.GarbageCollectionDTO> toMerge) {
        HashMap<String, SystemDiagnosticsSnapshotDTO.GarbageCollectionDTO> storageById = new HashMap<String, SystemDiagnosticsSnapshotDTO.GarbageCollectionDTO>();
        for (SystemDiagnosticsSnapshotDTO.GarbageCollectionDTO targetUsage : targetSet) {
            storageById.put(targetUsage.getName(), targetUsage);
        }
        for (SystemDiagnosticsSnapshotDTO.GarbageCollectionDTO usageToMerge : toMerge) {
            SystemDiagnosticsSnapshotDTO.GarbageCollectionDTO targetUsage = (SystemDiagnosticsSnapshotDTO.GarbageCollectionDTO)storageById.get(usageToMerge.getName());
            if (targetUsage == null) {
                storageById.put(usageToMerge.getName(), usageToMerge);
                continue;
            }
            StatusMerger.merge(targetUsage, usageToMerge);
        }
        targetSet.clear();
        targetSet.addAll(storageById.values());
    }

    public static void merge(SystemDiagnosticsSnapshotDTO.GarbageCollectionDTO target, SystemDiagnosticsSnapshotDTO.GarbageCollectionDTO toMerge) {
        target.setCollectionCount(target.getCollectionCount() + toMerge.getCollectionCount());
        target.setCollectionMillis(Long.valueOf(target.getCollectionMillis() + toMerge.getCollectionMillis()));
        StatusMerger.updatePrettyPrintedFields(target);
    }

    public static void updatePrettyPrintedFields(SystemDiagnosticsSnapshotDTO.GarbageCollectionDTO target) {
        target.setCollectionTime(FormatUtils.formatHoursMinutesSeconds((long)target.getCollectionMillis(), (TimeUnit)TimeUnit.MILLISECONDS));
    }

    public static void merge(CountersDTO target, CountersDTO toMerge, String nodeId, String nodeAddress, Integer nodeApiPort) {
        StatusMerger.merge(target.getAggregateSnapshot(), toMerge.getAggregateSnapshot());
        ArrayList<NodeCountersSnapshotDTO> nodeSnapshots = target.getNodeSnapshots();
        if (nodeSnapshots == null) {
            nodeSnapshots = new ArrayList<NodeCountersSnapshotDTO>();
        }
        NodeCountersSnapshotDTO nodeCountersSnapshot = new NodeCountersSnapshotDTO();
        nodeCountersSnapshot.setNodeId(nodeId);
        nodeCountersSnapshot.setAddress(nodeAddress);
        nodeCountersSnapshot.setApiPort(nodeApiPort);
        nodeCountersSnapshot.setSnapshot(toMerge.getAggregateSnapshot());
        nodeSnapshots.add(nodeCountersSnapshot);
        target.setNodeSnapshots(nodeSnapshots);
    }

    public static void merge(CountersSnapshotDTO target, CountersSnapshotDTO toMerge) {
        HashMap<String, CounterDTO> counters = new HashMap<String, CounterDTO>();
        for (CounterDTO counter : target.getCounters()) {
            counters.put(counter.getId(), counter);
        }
        for (CounterDTO counter : toMerge.getCounters()) {
            CounterDTO existing = (CounterDTO)counters.get(counter.getId());
            if (existing == null) {
                counters.put(counter.getId(), counter);
                continue;
            }
            StatusMerger.merge(existing, counter);
        }
        target.setCounters(counters.values());
    }

    public static void merge(CounterDTO target, CounterDTO toMerge) {
        target.setValueCount(Long.valueOf(target.getValueCount() + toMerge.getValueCount()));
        target.setValue(FormatUtils.formatCount((long)target.getValueCount()));
    }

    public static int getUtilization(double used, double total) {
        return (int)Math.round(used / total * 100.0);
    }

    public static String formatCount(Integer intStatus) {
        if (intStatus == null) {
            return "-";
        }
        if (intStatus == 0) {
            return ZERO_COUNT;
        }
        return FormatUtils.formatCount((long)intStatus.intValue());
    }

    public static String formatDataSize(Long longStatus) {
        if (longStatus == null) {
            return "-";
        }
        if (longStatus == 0L) {
            return ZERO_BYTES;
        }
        return FormatUtils.formatDataSize((double)longStatus.longValue());
    }

    public static String prettyPrint(Integer count, Long bytes) {
        if (count != null && bytes != null && count == 0 && bytes == 0L) {
            return ZERO_COUNT_AND_BYTES;
        }
        return StatusMerger.formatCount(count) + " (" + StatusMerger.formatDataSize(bytes) + ")";
    }

    public static void merge(ControllerServiceStatusDTO target, ControllerServiceStatusDTO toMerge) {
        if (target == null || toMerge == null) {
            return;
        }
        if (ControllerServiceState.DISABLING.name().equalsIgnoreCase(toMerge.getRunStatus())) {
            target.setRunStatus(ControllerServiceState.DISABLING.name());
        } else if (ControllerServiceState.ENABLING.name().equalsIgnoreCase(toMerge.getRunStatus())) {
            target.setRunStatus(ControllerServiceState.ENABLING.name());
        }
        if (ValidationStatus.VALIDATING.name().equalsIgnoreCase(toMerge.getValidationStatus())) {
            target.setValidationStatus(ValidationStatus.VALIDATING.name());
        } else if (ValidationStatus.INVALID.name().equalsIgnoreCase(toMerge.getRunStatus())) {
            target.setValidationStatus(ValidationStatus.INVALID.name());
        }
    }

    public static void merge(ReportingTaskStatusDTO target, ReportingTaskStatusDTO toMerge) {
        if (target == null || toMerge == null) {
            return;
        }
        target.setActiveThreadCount(Integer.valueOf(target.getActiveThreadCount() + toMerge.getActiveThreadCount()));
        if (ValidationStatus.VALIDATING.name().equalsIgnoreCase(toMerge.getValidationStatus())) {
            target.setValidationStatus(ValidationStatus.VALIDATING.name());
        } else if (ValidationStatus.INVALID.name().equalsIgnoreCase(toMerge.getRunStatus())) {
            target.setValidationStatus(ValidationStatus.INVALID.name());
        }
    }
}

