/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.coordination.http.endpoints;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.components.ConfigVerificationResult;
import org.apache.nifi.web.api.dto.ConfigVerificationResultDTO;

public class ConfigVerificationResultMerger {
    private final Map<String, List<ConfigVerificationResultDTO>> verificationResultDtos = new HashMap<String, List<ConfigVerificationResultDTO>>();

    public void addNodeResults(NodeIdentifier nodeId, List<ConfigVerificationResultDTO> nodeResults) {
        if (nodeResults == null || nodeResults.isEmpty()) {
            return;
        }
        this.verificationResultDtos.put(nodeId.getApiAddress() + ":" + nodeId.getApiPort(), nodeResults);
    }

    public List<ConfigVerificationResultDTO> computeAggregateResults() {
        String stepName;
        HashMap<String, List> resultsByStepName = new HashMap<String, List>();
        for (Map.Entry<String, List<ConfigVerificationResultDTO>> entry : this.verificationResultDtos.entrySet()) {
            String string = entry.getKey();
            List<ConfigVerificationResultDTO> nodeResults = entry.getValue();
            if (nodeResults == null) {
                return null;
            }
            for (ConfigVerificationResultDTO result : nodeResults) {
                stepName = result.getVerificationStepName();
                List resultList = resultsByStepName.computeIfAbsent(stepName, key -> new ArrayList());
                if (!ConfigVerificationResult.Outcome.SUCCESSFUL.name().equals(result.getOutcome())) {
                    result.setExplanation(string + " - " + result.getExplanation());
                }
                resultList.add(result);
            }
        }
        ArrayList<ConfigVerificationResultDTO> aggregateResults = new ArrayList<ConfigVerificationResultDTO>();
        for (Map.Entry entry : resultsByStepName.entrySet()) {
            String stepName2 = (String)entry.getKey();
            List resultList = (List)entry.getValue();
            ConfigVerificationResultDTO firstResult = (ConfigVerificationResultDTO)resultList.get(0);
            String outcome = firstResult.getOutcome();
            String explanation = firstResult.getExplanation();
            for (ConfigVerificationResultDTO result : resultList) {
                if (ConfigVerificationResult.Outcome.FAILED.name().equals(result.getOutcome())) {
                    outcome = result.getOutcome();
                    explanation = result.getExplanation();
                    continue;
                }
                if (!ConfigVerificationResult.Outcome.SKIPPED.name().equals(result.getOutcome()) || !ConfigVerificationResult.Outcome.SUCCESSFUL.name().equals(outcome)) continue;
                outcome = result.getOutcome();
                explanation = result.getExplanation();
            }
            ConfigVerificationResultDTO resultDto = new ConfigVerificationResultDTO();
            resultDto.setVerificationStepName(stepName2);
            resultDto.setOutcome(outcome);
            resultDto.setExplanation(explanation);
            aggregateResults.add(resultDto);
        }
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        for (List<ConfigVerificationResultDTO> resultDtos : this.verificationResultDtos.values()) {
            for (ConfigVerificationResultDTO resultDto : resultDtos) {
                stepName = resultDto.getVerificationStepName();
                hashMap.putIfAbsent(stepName, hashMap.size());
            }
        }
        aggregateResults.sort(Comparator.comparing(dto -> (Integer)stepOrders.get(dto.getVerificationStepName())));
        return aggregateResults;
    }
}

