/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.coordination.http.endpoints;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.nifi.cluster.coordination.http.endpoints.AbstractSingleDTOEndpoint;
import org.apache.nifi.cluster.manager.BulletinMerger;
import org.apache.nifi.cluster.manager.NodeResponse;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.web.api.dto.BulletinBoardDTO;
import org.apache.nifi.web.api.entity.BulletinBoardEntity;
import org.apache.nifi.web.api.entity.BulletinEntity;

public class BulletinBoardEndpointMerger
extends AbstractSingleDTOEndpoint<BulletinBoardEntity, BulletinBoardDTO> {
    public static final Pattern BULLETIN_BOARD_URI_PATTERN = Pattern.compile("/nifi-api/flow/bulletin-board");

    @Override
    public boolean canHandle(URI uri, String method) {
        return "GET".equalsIgnoreCase(method) && BULLETIN_BOARD_URI_PATTERN.matcher(uri.getPath()).matches();
    }

    @Override
    protected Class<BulletinBoardEntity> getEntityClass() {
        return BulletinBoardEntity.class;
    }

    @Override
    protected BulletinBoardDTO getDto(BulletinBoardEntity entity) {
        return entity.getBulletinBoard();
    }

    @Override
    protected void mergeResponses(BulletinBoardDTO clientDto, Map<NodeIdentifier, BulletinBoardDTO> dtoMap, Set<NodeResponse> successfulResponses, Set<NodeResponse> problematicResponses) {
        HashMap<NodeIdentifier, List<BulletinEntity>> bulletinEntities = new HashMap<NodeIdentifier, List<BulletinEntity>>();
        for (Map.Entry<NodeIdentifier, BulletinBoardDTO> entry : dtoMap.entrySet()) {
            NodeIdentifier nodeIdentifier = entry.getKey();
            BulletinBoardDTO boardDto = entry.getValue();
            boardDto.getBulletins().forEach(bulletin -> bulletinEntities.computeIfAbsent(nodeIdentifier, nodeId -> new ArrayList()).add(bulletin));
        }
        clientDto.setBulletins(BulletinMerger.mergeBulletins(bulletinEntities, dtoMap.size()));
    }
}

