/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.coordination.http.endpoints;

import java.net.URI;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.nifi.cluster.coordination.http.EndpointResponseMerger;
import org.apache.nifi.cluster.coordination.http.endpoints.AbstractSingleEntityEndpoint;
import org.apache.nifi.cluster.manager.NodeResponse;
import org.apache.nifi.cluster.manager.UserGroupEntityMerger;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.web.api.entity.UserGroupEntity;

public class UserGroupEndpointMerger
extends AbstractSingleEntityEndpoint<UserGroupEntity>
implements EndpointResponseMerger {
    public static final Pattern USER_GROUPS_URI_PATTERN = Pattern.compile("/nifi-api/tenants/user-groups");
    public static final Pattern USER_GROUP_URI_PATTERN = Pattern.compile("/nifi-api/tenants/user-groups/[a-f0-9\\-]{36}");
    private final UserGroupEntityMerger userGroupEntityMerger = new UserGroupEntityMerger();

    @Override
    public boolean canHandle(URI uri, String method) {
        if (("GET".equalsIgnoreCase(method) || "PUT".equalsIgnoreCase(method)) && USER_GROUP_URI_PATTERN.matcher(uri.getPath()).matches()) {
            return true;
        }
        return "POST".equalsIgnoreCase(method) && USER_GROUPS_URI_PATTERN.matcher(uri.getPath()).matches();
    }

    @Override
    protected Class<UserGroupEntity> getEntityClass() {
        return UserGroupEntity.class;
    }

    @Override
    protected void mergeResponses(UserGroupEntity clientEntity, Map<NodeIdentifier, UserGroupEntity> entityMap, Set<NodeResponse> successfulResponses, Set<NodeResponse> problematicResponses) {
        this.userGroupEntityMerger.merge(clientEntity, entityMap);
    }
}

