/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.coordination.http.endpoints;

import java.net.URI;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.nifi.cluster.coordination.http.endpoints.AbstractSingleEntityEndpoint;
import org.apache.nifi.cluster.manager.FunnelEntityMerger;
import org.apache.nifi.cluster.manager.NodeResponse;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.web.api.entity.FunnelEntity;

public class FunnelEndpointMerger
extends AbstractSingleEntityEndpoint<FunnelEntity> {
    public static final Pattern FUNNELS_URI_PATTERN = Pattern.compile("/nifi-api/process-groups/(?:(?:root)|(?:[a-f0-9\\-]{36}))/funnels");
    public static final Pattern FUNNEL_URI_PATTERN = Pattern.compile("/nifi-api/funnels/[a-f0-9\\-]{36}");
    private final FunnelEntityMerger funnelEntityMerger = new FunnelEntityMerger();

    @Override
    protected Class<FunnelEntity> getEntityClass() {
        return FunnelEntity.class;
    }

    @Override
    protected void mergeResponses(FunnelEntity clientEntity, Map<NodeIdentifier, FunnelEntity> entityMap, Set<NodeResponse> successfulResponses, Set<NodeResponse> problematicResponses) {
        this.funnelEntityMerger.merge(clientEntity, entityMap);
    }

    @Override
    public boolean canHandle(URI uri, String method) {
        if (("GET".equalsIgnoreCase(method) || "PUT".equalsIgnoreCase(method)) && FUNNEL_URI_PATTERN.matcher(uri.getPath()).matches()) {
            return true;
        }
        return "POST".equalsIgnoreCase(method) && FUNNELS_URI_PATTERN.matcher(uri.getPath()).matches();
    }
}

