/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.authorization;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import javax.xml.bind.JAXBException;
import org.apache.nifi.authorization.AbstractPolicyBasedAuthorizer;
import org.apache.nifi.authorization.AccessPolicy;
import org.apache.nifi.authorization.AccessPolicyProviderInitializationContext;
import org.apache.nifi.authorization.AccessPolicyProviderLookup;
import org.apache.nifi.authorization.AuthorizationsHolder;
import org.apache.nifi.authorization.AuthorizerConfigurationContext;
import org.apache.nifi.authorization.AuthorizerInitializationContext;
import org.apache.nifi.authorization.FileAccessPolicyProvider;
import org.apache.nifi.authorization.FileUserGroupProvider;
import org.apache.nifi.authorization.Group;
import org.apache.nifi.authorization.RequestAction;
import org.apache.nifi.authorization.StandardAuthorizerConfigurationContext;
import org.apache.nifi.authorization.User;
import org.apache.nifi.authorization.UserGroupHolder;
import org.apache.nifi.authorization.UserGroupProviderInitializationContext;
import org.apache.nifi.authorization.UserGroupProviderLookup;
import org.apache.nifi.authorization.UsersAndAccessPolicies;
import org.apache.nifi.authorization.annotation.AuthorizerContext;
import org.apache.nifi.authorization.exception.AuthorizationAccessException;
import org.apache.nifi.authorization.exception.AuthorizerCreationException;
import org.apache.nifi.util.NiFiProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileAuthorizer
extends AbstractPolicyBasedAuthorizer {
    private static final Logger logger = LoggerFactory.getLogger(FileAuthorizer.class);
    private static final String FILE_USER_GROUP_PROVIDER_ID = "file-user-group-provider";
    private static final String FILE_ACCESS_POLICY_PROVIDER_ID = "file-access-policy-provider";
    static final String PROP_LEGACY_AUTHORIZED_USERS_FILE = "Legacy Authorized Users File";
    private FileUserGroupProvider userGroupProvider = new FileUserGroupProvider();
    private FileAccessPolicyProvider accessPolicyProvider = new FileAccessPolicyProvider();

    public void initialize(AuthorizerInitializationContext initializationContext) throws AuthorizerCreationException {
        this.userGroupProvider.initialize(new UserGroupProviderInitializationContext(){

            public String getIdentifier() {
                return FileAuthorizer.FILE_USER_GROUP_PROVIDER_ID;
            }

            public UserGroupProviderLookup getUserGroupProviderLookup() {
                return identifier -> null;
            }
        });
        this.accessPolicyProvider.initialize(new AccessPolicyProviderInitializationContext(){

            public String getIdentifier() {
                return FileAuthorizer.FILE_ACCESS_POLICY_PROVIDER_ID;
            }

            public UserGroupProviderLookup getUserGroupProviderLookup() {
                return identifier -> {
                    if (FileAuthorizer.FILE_USER_GROUP_PROVIDER_ID.equals(identifier)) {
                        return FileAuthorizer.this.userGroupProvider;
                    }
                    return null;
                };
            }

            public AccessPolicyProviderLookup getAccessPolicyProviderLookup() {
                return identifier -> null;
            }
        });
    }

    public void doOnConfigured(AuthorizerConfigurationContext configurationContext) throws AuthorizerCreationException {
        Map configurationProperties = configurationContext.getProperties();
        HashMap<Object, String> userGroupProperties = new HashMap<Object, String>();
        if (configurationProperties.containsKey("Users File")) {
            userGroupProperties.put("Users File", (String)configurationProperties.get("Users File"));
        }
        if (configurationProperties.containsKey(PROP_LEGACY_AUTHORIZED_USERS_FILE)) {
            userGroupProperties.put(PROP_LEGACY_AUTHORIZED_USERS_FILE, (String)configurationProperties.get(PROP_LEGACY_AUTHORIZED_USERS_FILE));
        }
        HashMap<String, String> accessPolicyProperties = new HashMap<String, String>();
        accessPolicyProperties.put("User Group Provider", FILE_USER_GROUP_PROVIDER_ID);
        if (configurationProperties.containsKey("Authorizations File")) {
            accessPolicyProperties.put("Authorizations File", (String)configurationProperties.get("Authorizations File"));
        }
        if (configurationProperties.containsKey("Initial Admin Identity")) {
            accessPolicyProperties.put("Initial Admin Identity", (String)configurationProperties.get("Initial Admin Identity"));
        }
        if (configurationProperties.containsKey(PROP_LEGACY_AUTHORIZED_USERS_FILE)) {
            accessPolicyProperties.put(PROP_LEGACY_AUTHORIZED_USERS_FILE, (String)configurationProperties.get(PROP_LEGACY_AUTHORIZED_USERS_FILE));
        }
        configurationProperties.forEach((property, value) -> {
            Matcher matcher = FileAccessPolicyProvider.NODE_IDENTITY_PATTERN.matcher((CharSequence)property);
            if (matcher.matches()) {
                accessPolicyProperties.put((String)property, (String)value);
                userGroupProperties.put(property.replace("Node Identity ", "Initial User Identity "), (String)value);
            }
        });
        if (configurationProperties.containsKey("Initial Admin Identity")) {
            String key;
            int i = 0;
            while (userGroupProperties.containsKey(key = "Initial User Identity " + i++)) {
            }
            userGroupProperties.put(key, (String)configurationProperties.get("Initial Admin Identity"));
        }
        this.userGroupProvider.onConfigured((AuthorizerConfigurationContext)new StandardAuthorizerConfigurationContext(FILE_USER_GROUP_PROVIDER_ID, userGroupProperties));
        this.accessPolicyProvider.onConfigured((AuthorizerConfigurationContext)new StandardAuthorizerConfigurationContext(FILE_USER_GROUP_PROVIDER_ID, accessPolicyProperties));
    }

    public void preDestruction() {
    }

    public synchronized Group doAddGroup(Group group) throws AuthorizationAccessException {
        return this.userGroupProvider.addGroup(group);
    }

    public Group getGroup(String identifier) throws AuthorizationAccessException {
        return this.userGroupProvider.getGroup(identifier);
    }

    public Group getGroupByName(String name) throws AuthorizationAccessException {
        return this.userGroupProvider.getGroupByName(name);
    }

    public synchronized Group doUpdateGroup(Group group) throws AuthorizationAccessException {
        return this.userGroupProvider.updateGroup(group);
    }

    public synchronized Group deleteGroup(Group group) throws AuthorizationAccessException {
        return this.userGroupProvider.deleteGroup(group);
    }

    public Set<Group> getGroups() throws AuthorizationAccessException {
        return this.userGroupProvider.getGroups();
    }

    public synchronized User doAddUser(User user) throws AuthorizationAccessException {
        return this.userGroupProvider.addUser(user);
    }

    public User getUser(String identifier) throws AuthorizationAccessException {
        return this.userGroupProvider.getUser(identifier);
    }

    public User getUserByIdentity(String identity) throws AuthorizationAccessException {
        return this.userGroupProvider.getUserByIdentity(identity);
    }

    public synchronized User doUpdateUser(User user) throws AuthorizationAccessException {
        return this.userGroupProvider.updateUser(user);
    }

    public synchronized User deleteUser(User user) throws AuthorizationAccessException {
        return this.userGroupProvider.deleteUser(user);
    }

    public Set<User> getUsers() throws AuthorizationAccessException {
        return this.userGroupProvider.getUsers();
    }

    public synchronized AccessPolicy doAddAccessPolicy(AccessPolicy accessPolicy) throws AuthorizationAccessException {
        return this.accessPolicyProvider.addAccessPolicy(accessPolicy);
    }

    public AccessPolicy getAccessPolicy(String identifier) throws AuthorizationAccessException {
        return this.accessPolicyProvider.getAccessPolicy(identifier);
    }

    public synchronized AccessPolicy updateAccessPolicy(AccessPolicy accessPolicy) throws AuthorizationAccessException {
        return this.accessPolicyProvider.updateAccessPolicy(accessPolicy);
    }

    public synchronized AccessPolicy deleteAccessPolicy(AccessPolicy accessPolicy) throws AuthorizationAccessException {
        return this.accessPolicyProvider.deleteAccessPolicy(accessPolicy);
    }

    public Set<AccessPolicy> getAccessPolicies() throws AuthorizationAccessException {
        return this.accessPolicyProvider.getAccessPolicies();
    }

    public void purgePoliciesUsersAndGroups() {
        this.accessPolicyProvider.purgePolicies(true);
        this.userGroupProvider.purgeUsersAndGroups();
    }

    public void backupPoliciesUsersAndGroups() {
        try {
            this.accessPolicyProvider.backupPolicies();
            this.userGroupProvider.backupUsersAndGroups();
        }
        catch (JAXBException jaxb) {
            throw new AuthorizationAccessException("Failed to backup policies", (Throwable)jaxb);
        }
    }

    @AuthorizerContext
    public void setNiFiProperties(NiFiProperties properties) {
        this.userGroupProvider.setNiFiProperties(properties);
        this.accessPolicyProvider.setNiFiProperties(properties);
    }

    public synchronized UsersAndAccessPolicies getUsersAndAccessPolicies() throws AuthorizationAccessException {
        final AuthorizationsHolder authorizationsHolder = this.accessPolicyProvider.getAuthorizationsHolder();
        final UserGroupHolder userGroupHolder = this.userGroupProvider.getUserGroupHolder();
        return new UsersAndAccessPolicies(){

            public AccessPolicy getAccessPolicy(String resourceIdentifier, RequestAction action) {
                return authorizationsHolder.getAccessPolicy(resourceIdentifier, action);
            }

            public User getUser(String identity) {
                return userGroupHolder.getUser(identity);
            }

            public Set<Group> getGroups(String userIdentity) {
                return userGroupHolder.getGroups(userIdentity);
            }
        };
    }
}

