/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.authorization;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.nifi.authorization.Role;
import org.apache.nifi.authorization.resource.ResourceType;

public final class RoleAccessPolicy {
    static final String READ_ACTION = "R";
    static final String WRITE_ACTION = "W";
    private final String resource;
    private final String action;

    private RoleAccessPolicy(String resource, String action) {
        this.resource = resource;
        this.action = action;
    }

    public String getResource() {
        return this.resource;
    }

    public String getAction() {
        return this.action;
    }

    public static Map<Role, Set<RoleAccessPolicy>> getMappings(String rootGroupId) {
        HashMap<Role, Set<RoleAccessPolicy>> roleAccessPolicies = new HashMap<Role, Set<RoleAccessPolicy>>();
        HashSet<RoleAccessPolicy> monitorPolicies = new HashSet<RoleAccessPolicy>();
        monitorPolicies.add(new RoleAccessPolicy(ResourceType.Flow.getValue(), READ_ACTION));
        monitorPolicies.add(new RoleAccessPolicy(ResourceType.Controller.getValue(), READ_ACTION));
        monitorPolicies.add(new RoleAccessPolicy(ResourceType.System.getValue(), READ_ACTION));
        if (rootGroupId != null) {
            monitorPolicies.add(new RoleAccessPolicy(ResourceType.ProcessGroup.getValue() + "/" + rootGroupId, READ_ACTION));
        }
        roleAccessPolicies.put(Role.ROLE_MONITOR, Collections.unmodifiableSet(monitorPolicies));
        HashSet<RoleAccessPolicy> provenancePolicies = new HashSet<RoleAccessPolicy>();
        provenancePolicies.add(new RoleAccessPolicy(ResourceType.Provenance.getValue(), READ_ACTION));
        if (rootGroupId != null) {
            provenancePolicies.add(new RoleAccessPolicy(ResourceType.Data.getValue() + ResourceType.ProcessGroup.getValue() + "/" + rootGroupId, READ_ACTION));
            provenancePolicies.add(new RoleAccessPolicy(ResourceType.ProvenanceData.getValue() + ResourceType.ProcessGroup.getValue() + "/" + rootGroupId, READ_ACTION));
        }
        roleAccessPolicies.put(Role.ROLE_PROVENANCE, Collections.unmodifiableSet(provenancePolicies));
        HashSet<RoleAccessPolicy> dfmPolicies = new HashSet<RoleAccessPolicy>();
        dfmPolicies.add(new RoleAccessPolicy(ResourceType.Flow.getValue(), READ_ACTION));
        dfmPolicies.add(new RoleAccessPolicy(ResourceType.Controller.getValue(), READ_ACTION));
        dfmPolicies.add(new RoleAccessPolicy(ResourceType.Controller.getValue(), WRITE_ACTION));
        dfmPolicies.add(new RoleAccessPolicy(ResourceType.System.getValue(), READ_ACTION));
        dfmPolicies.add(new RoleAccessPolicy(ResourceType.RestrictedComponents.getValue(), WRITE_ACTION));
        if (rootGroupId != null) {
            dfmPolicies.add(new RoleAccessPolicy(ResourceType.ProcessGroup.getValue() + "/" + rootGroupId, READ_ACTION));
            dfmPolicies.add(new RoleAccessPolicy(ResourceType.ProcessGroup.getValue() + "/" + rootGroupId, WRITE_ACTION));
            dfmPolicies.add(new RoleAccessPolicy(ResourceType.Data.getValue() + ResourceType.ProcessGroup.getValue() + "/" + rootGroupId, READ_ACTION));
            dfmPolicies.add(new RoleAccessPolicy(ResourceType.Data.getValue() + ResourceType.ProcessGroup.getValue() + "/" + rootGroupId, WRITE_ACTION));
        }
        roleAccessPolicies.put(Role.ROLE_DFM, Collections.unmodifiableSet(dfmPolicies));
        HashSet<RoleAccessPolicy> adminPolicies = new HashSet<RoleAccessPolicy>();
        adminPolicies.add(new RoleAccessPolicy(ResourceType.Flow.getValue(), READ_ACTION));
        adminPolicies.add(new RoleAccessPolicy(ResourceType.Controller.getValue(), READ_ACTION));
        if (rootGroupId != null) {
            adminPolicies.add(new RoleAccessPolicy(ResourceType.ProcessGroup.getValue() + "/" + rootGroupId, READ_ACTION));
        }
        adminPolicies.add(new RoleAccessPolicy(ResourceType.Tenant.getValue(), READ_ACTION));
        adminPolicies.add(new RoleAccessPolicy(ResourceType.Tenant.getValue(), WRITE_ACTION));
        adminPolicies.add(new RoleAccessPolicy(ResourceType.Policy.getValue(), READ_ACTION));
        adminPolicies.add(new RoleAccessPolicy(ResourceType.Policy.getValue(), WRITE_ACTION));
        roleAccessPolicies.put(Role.ROLE_ADMIN, Collections.unmodifiableSet(adminPolicies));
        HashSet<RoleAccessPolicy> proxyPolicies = new HashSet<RoleAccessPolicy>();
        proxyPolicies.add(new RoleAccessPolicy(ResourceType.Proxy.getValue(), WRITE_ACTION));
        if (rootGroupId != null) {
            proxyPolicies.add(new RoleAccessPolicy(ResourceType.Data.getValue() + ResourceType.ProcessGroup.getValue() + "/" + rootGroupId, READ_ACTION));
            proxyPolicies.add(new RoleAccessPolicy(ResourceType.Data.getValue() + ResourceType.ProcessGroup.getValue() + "/" + rootGroupId, WRITE_ACTION));
        }
        roleAccessPolicies.put(Role.ROLE_PROXY, Collections.unmodifiableSet(proxyPolicies));
        HashSet<RoleAccessPolicy> nifiPolicies = new HashSet<RoleAccessPolicy>();
        nifiPolicies.add(new RoleAccessPolicy(ResourceType.Controller.getValue(), READ_ACTION));
        nifiPolicies.add(new RoleAccessPolicy(ResourceType.SiteToSite.getValue(), READ_ACTION));
        roleAccessPolicies.put(Role.ROLE_NIFI, Collections.unmodifiableSet(nifiPolicies));
        return roleAccessPolicies;
    }
}

